/*
 * Decompiled with CFR 0.152.
 */
package SSS.Util;

import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class HTMLEncode {
    private static Method encodeMethod14;
    private static final String[] ENTITIES;
    private static Hashtable entityTableEncode;

    static {
        try {
            Class<?> urlEncoderClass = Class.forName("java.net.URLEncoder");
            encodeMethod14 = urlEncoderClass.getMethod("encode", String.class, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ENTITIES = new String[]{">", "%3E", "<", "%3C", "&", "%26", "\"", "%22", "'", "%27", "//", "%2F", "\u00a9", "%A9", "\u00ae", "%AE", "@", "%40", "#", "%23", ".", "%2E", " ", "%20"};
        entityTableEncode = null;
    }

    private HTMLEncode() {
    }

    protected static synchronized void buildEntityTables() {
        entityTableEncode = new Hashtable(ENTITIES.length);
        int i = 0;
        while (i < ENTITIES.length) {
            if (!entityTableEncode.containsKey(ENTITIES[i])) {
                entityTableEncode.put(ENTITIES[i], ENTITIES[i + 1]);
            }
            i += 2;
        }
    }

    public static final String encode(String s) {
        return HTMLEncode.encode(s, "\n");
    }

    public static final String encode(String s, String cr) {
        if (entityTableEncode == null) {
            HTMLEncode.buildEntityTables();
        }
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ((ch >= '?' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-') && ch != '@') {
                sb.append(ch);
            } else if (ch == '\n') {
                sb.append(cr);
            } else {
                String chEnc = HTMLEncode.encodeSingleChar(String.valueOf(ch));
                if (chEnc != null) {
                    sb.append(chEnc);
                } else {
                    sb.append("&#");
                    sb.append(new Integer(ch).toString());
                    sb.append(';');
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static String encodeSingleChar(String ch) {
        return (String)entityTableEncode.get(ch);
    }

    protected static String encodeHREFParam(String url) {
        if (encodeMethod14 != null) {
            Object[] methodArgs = new Object[]{url, "UTF8"};
            try {
                return (String)encodeMethod14.invoke(null, methodArgs);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error invoking 1.4 URLEncoder.encode with reflection: " + e.getMessage());
            }
        }
        return URLEncoder.encode(url);
    }

    protected static String encodeHREFParamJava13(String value) {
        return URLEncoder.encode(value);
    }

    public static String encodeQuery(String url, String[] args) {
        return HTMLEncode.encodeHREFQuery(url, args, false);
    }

    public static String encodeHREFQuery(String url, String[] args) {
        return HTMLEncode.encodeHREFQuery(url, args, true);
    }

    public static String encodeHREFQuery(String url, String[] args, boolean forHtml) {
        StringBuffer out = new StringBuffer(128);
        out.append(url);
        if (args != null && args.length > 0) {
            out.append("?");
            int i = 0;
            while (i < (args.length + 1) / 2) {
                int k = i * 2;
                if (k != 0) {
                    if (forHtml) {
                        out.append("&amp;");
                    } else {
                        out.append("&");
                    }
                }
                out.append(HTMLEncode.encodeHREFParam(args[k]));
                if (k + 1 < args.length) {
                    out.append("=");
                    out.append(HTMLEncode.encodeHREFParam(args[k + 1]));
                }
                ++i;
            }
        }
        return out.toString();
    }

    public static String encodeHREFQuery(String url, Map args, boolean forHtml) {
        StringBuffer out = new StringBuffer(128);
        out.append(url);
        if (args != null && args.size() > 0) {
            out.append("?");
            int k = 0;
            Iterator i = args.keySet().iterator();
            while (i.hasNext()) {
                if (k != 0) {
                    if (forHtml) {
                        out.append("&amp;");
                    } else {
                        out.append("&");
                    }
                }
                String name = (String)i.next();
                out.append(HTMLEncode.encodeHREFParam(name));
                out.append("=");
                out.append(HTMLEncode.encodeHREFParam((String)args.get(name)));
                ++k;
            }
        }
        return out.toString();
    }
}

