/*
 * Decompiled with CFR 0.152.
 */
package SSS.Util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.newdawn.slick.util.ResourceLoader;

public class IconLoader {
    public static ByteBuffer[] LoadIcon(String filepath) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(ResourceLoader.getResourceAsStream(filepath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteBuffer[] buffers = new ByteBuffer[]{IconLoader.loadIconInstance(image, 128), IconLoader.loadIconInstance(image, 32), IconLoader.loadIconInstance(image, 16)};
        return buffers;
    }

    private static ByteBuffer loadIconInstance(BufferedImage image, int dimension) {
        double r2;
        BufferedImage scaledIcon = new BufferedImage(dimension, dimension, 2);
        Graphics2D g = scaledIcon.createGraphics();
        double ratio = 1.0;
        ratio = image.getWidth() > scaledIcon.getWidth() ? (double)scaledIcon.getWidth() / (double)image.getWidth() : (double)(scaledIcon.getWidth() / image.getWidth());
        if (image.getHeight() > scaledIcon.getHeight()) {
            r2 = (double)scaledIcon.getHeight() / (double)image.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        } else {
            r2 = scaledIcon.getHeight() / image.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        }
        double width = (double)image.getWidth() * ratio;
        double height = (double)image.getHeight() * ratio;
        g.drawImage(image, (int)(((double)scaledIcon.getWidth() - width) / 2.0), (int)(((double)scaledIcon.getHeight() - height) / 2.0), (int)width, (int)height, null);
        g.dispose();
        byte[] imageBuffer = new byte[dimension * dimension * 4];
        int counter = 0;
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                int colorSpace = scaledIcon.getRGB(j, i);
                imageBuffer[counter + 0] = (byte)(colorSpace << 8 >> 24);
                imageBuffer[counter + 1] = (byte)(colorSpace << 16 >> 24);
                imageBuffer[counter + 2] = (byte)(colorSpace << 24 >> 24);
                imageBuffer[counter + 3] = (byte)(colorSpace >> 24);
                counter += 4;
                ++j;
            }
            ++i;
        }
        return ByteBuffer.wrap(imageBuffer);
    }
}

