/*
 * Decompiled with CFR 0.152.
 */
package SSS.Util;

import Java.Tricks.ref;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.GamePad;
import Microsoft.Xna.Framework.Input.GamePadItemState;
import Microsoft.Xna.Framework.Input.GamePadMapper;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.PlayerIndex;
import SSS.Util.Utility;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxG;
import org.flixel.data.FlxGamepad;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InputManager {
    protected static PlayerIndex m_playerIndex = PlayerIndex.One;
    protected static PlayerIndex m_outPlayerIndex;
    protected static boolean m_handleKeyboard;
    protected static boolean m_tmpBool;
    protected static HashMap<Buttons, Keys> MappingGamePadKey;
    protected static HashMap<String, Keys> StringToKeys;
    protected static HashMap<String, Buttons> StringToButtons;
    static Keys[] m_listKeys;
    static Buttons[] m_listButtons;

    static {
        m_handleKeyboard = true;
        MappingGamePadKey = new HashMap<Buttons, Keys>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Buttons.A, Keys.Space);
                this.put(Buttons.X, Keys.X);
                this.put(Buttons.Y, Keys.C);
                this.put(Buttons.B, Keys.V);
                this.put(Buttons.RightShoulder, Keys.N);
                this.put(Buttons.RightTrigger, Keys.H);
                this.put(Buttons.LeftShoulder, Keys.B);
                this.put(Buttons.LeftTrigger, Keys.G);
                this.put(Buttons.DPadUp, Keys.NumPad8);
                this.put(Buttons.DPadDown, Keys.NumPad2);
                this.put(Buttons.DPadLeft, Keys.NumPad4);
                this.put(Buttons.DPadRight, Keys.NumPad6);
                this.put(Buttons.RightThumbstickUp, Keys.Z);
                this.put(Buttons.RightThumbstickDown, Keys.S);
                this.put(Buttons.RightThumbstickLeft, Keys.Q);
                this.put(Buttons.RightThumbstickRight, Keys.D);
                this.put(Buttons.LeftThumbstickUp, Keys.Up);
                this.put(Buttons.LeftThumbstickDown, Keys.Down);
                this.put(Buttons.LeftThumbstickLeft, Keys.Left);
                this.put(Buttons.LeftThumbstickRight, Keys.Right);
                this.put(Buttons.Start, Keys.F1);
                this.put(Buttons.Back, Keys.F2);
                this.put(Buttons.LeftStick, Keys.LeftControl);
                this.put(Buttons.RightStick, Keys.RightControl);
                this.put(Buttons.BigButton, Keys.F3);
            }
        };
        StringToKeys = new HashMap<String, Keys>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("None", Keys.None);
                this.put("Back", Keys.Back);
                this.put("Tab", Keys.Tab);
                this.put("Enter", Keys.Enter);
                this.put("Pause", Keys.Pause);
                this.put("CapsLock", Keys.CapsLock);
                this.put("Kana", Keys.Kana);
                this.put("Kanji", Keys.Kanji);
                this.put("Escape", Keys.Escape);
                this.put("ImeConvert", Keys.ImeConvert);
                this.put("ImeNoConvert", Keys.ImeNoConvert);
                this.put("Space", Keys.Space);
                this.put("PageUp", Keys.PageUp);
                this.put("PageDown", Keys.PageDown);
                this.put("End", Keys.End);
                this.put("Home", Keys.Home);
                this.put("Left", Keys.Left);
                this.put("Up", Keys.Up);
                this.put("Right", Keys.Right);
                this.put("Down", Keys.Down);
                this.put("Select", Keys.Select);
                this.put("Print", Keys.Print);
                this.put("Execute", Keys.Execute);
                this.put("PrintScreen", Keys.PrintScreen);
                this.put("Insert", Keys.Insert);
                this.put("Delete", Keys.Delete);
                this.put("Help", Keys.Help);
                this.put("D0", Keys.D0);
                this.put("D1", Keys.D1);
                this.put("D2", Keys.D2);
                this.put("D3", Keys.D3);
                this.put("D4", Keys.D4);
                this.put("D5", Keys.D5);
                this.put("D6", Keys.D6);
                this.put("D7", Keys.D7);
                this.put("D8", Keys.D8);
                this.put("D9", Keys.D9);
                this.put("A", Keys.A);
                this.put("B", Keys.B);
                this.put("C", Keys.C);
                this.put("D", Keys.D);
                this.put("E", Keys.E);
                this.put("F", Keys.F);
                this.put("G", Keys.G);
                this.put("H", Keys.H);
                this.put("I", Keys.I);
                this.put("J", Keys.J);
                this.put("K", Keys.K);
                this.put("L", Keys.L);
                this.put("M", Keys.M);
                this.put("N", Keys.N);
                this.put("O", Keys.O);
                this.put("P", Keys.P);
                this.put("Q", Keys.Q);
                this.put("R", Keys.R);
                this.put("S", Keys.S);
                this.put("T", Keys.T);
                this.put("U", Keys.U);
                this.put("V", Keys.V);
                this.put("W", Keys.W);
                this.put("X", Keys.X);
                this.put("Y", Keys.Y);
                this.put("Z", Keys.Z);
                this.put("LeftWindows", Keys.LeftWindows);
                this.put("RightWindows", Keys.RightWindows);
                this.put("Apps", Keys.Apps);
                this.put("Sleep", Keys.Sleep);
                this.put("NumPad0", Keys.NumPad0);
                this.put("NumPad1", Keys.NumPad1);
                this.put("NumPad2", Keys.NumPad2);
                this.put("NumPad3", Keys.NumPad3);
                this.put("NumPad4", Keys.NumPad4);
                this.put("NumPad5", Keys.NumPad5);
                this.put("NumPad6", Keys.NumPad6);
                this.put("NumPad7", Keys.NumPad7);
                this.put("NumPad8", Keys.NumPad8);
                this.put("NumPad9", Keys.NumPad9);
                this.put("Multiply", Keys.Multiply);
                this.put("Add", Keys.Add);
                this.put("Separator", Keys.Separator);
                this.put("Subtract", Keys.Subtract);
                this.put("Decimal", Keys.Decimal);
                this.put("Divide", Keys.Divide);
                this.put("F1", Keys.F1);
                this.put("F2", Keys.F2);
                this.put("F3", Keys.F3);
                this.put("F4", Keys.F4);
                this.put("F5", Keys.F5);
                this.put("F6", Keys.F6);
                this.put("F7", Keys.F7);
                this.put("F8", Keys.F8);
                this.put("F9", Keys.F9);
                this.put("F10", Keys.F10);
                this.put("F11", Keys.F11);
                this.put("F12", Keys.F12);
                this.put("F13", Keys.F13);
                this.put("F14", Keys.F14);
                this.put("F15", Keys.F15);
                this.put("F16", Keys.F16);
                this.put("F17", Keys.F17);
                this.put("F18", Keys.F18);
                this.put("F19", Keys.F19);
                this.put("F20", Keys.F20);
                this.put("F21", Keys.F21);
                this.put("F22", Keys.F22);
                this.put("F23", Keys.F23);
                this.put("F24", Keys.F24);
                this.put("NumLock", Keys.NumLock);
                this.put("Scroll", Keys.Scroll);
                this.put("LeftShift", Keys.LeftShift);
                this.put("RightShift", Keys.RightShift);
                this.put("LeftControl", Keys.LeftControl);
                this.put("RightControl", Keys.RightControl);
                this.put("LeftAlt", Keys.LeftAlt);
                this.put("RightAlt", Keys.RightAlt);
                this.put("BrowserBack", Keys.BrowserBack);
                this.put("BrowserForward", Keys.BrowserForward);
                this.put("BrowserRefresh", Keys.BrowserRefresh);
                this.put("BrowserStop", Keys.BrowserStop);
                this.put("BrowserSearch", Keys.BrowserSearch);
                this.put("BrowserFavorites", Keys.BrowserFavorites);
                this.put("BrowserHome", Keys.BrowserHome);
                this.put("VolumeMute", Keys.VolumeMute);
                this.put("VolumeDown", Keys.VolumeDown);
                this.put("VolumeUp", Keys.VolumeUp);
                this.put("MediaNextTrack", Keys.MediaNextTrack);
                this.put("MediaPreviousTrack", Keys.MediaPreviousTrack);
                this.put("MediaStop", Keys.MediaStop);
                this.put("MediaPlayPause", Keys.MediaPlayPause);
                this.put("LaunchMail", Keys.LaunchMail);
                this.put("SelectMedia", Keys.SelectMedia);
                this.put("LaunchApplication1", Keys.LaunchApplication1);
                this.put("LaunchApplication2", Keys.LaunchApplication2);
                this.put("OemSemicolon", Keys.OemSemicolon);
                this.put("OemPlus", Keys.OemPlus);
                this.put("OemComma", Keys.OemComma);
                this.put("OemMinus", Keys.OemMinus);
                this.put("OemPeriod", Keys.OemPeriod);
                this.put("OemQuestion", Keys.OemQuestion);
                this.put("OemTilde", Keys.OemTilde);
                this.put("ChatPadGreen", Keys.ChatPadGreen);
                this.put("ChatPadOrange", Keys.ChatPadOrange);
                this.put("OemOpenBrackets", Keys.OemOpenBrackets);
                this.put("OemPipe", Keys.OemPipe);
                this.put("OemCloseBrackets", Keys.OemCloseBrackets);
                this.put("OemQuotes", Keys.OemQuotes);
                this.put("Oem8", Keys.Oem8);
                this.put("OemBackslash", Keys.OemBackslash);
                this.put("ProcessKey", Keys.ProcessKey);
                this.put("OemCopy", Keys.OemCopy);
                this.put("OemAuto", Keys.OemAuto);
                this.put("OemEnlW", Keys.OemEnlW);
                this.put("Attn", Keys.Attn);
                this.put("Crsel", Keys.Crsel);
                this.put("Exsel", Keys.Exsel);
                this.put("EraseEof", Keys.EraseEof);
                this.put("Play", Keys.Play);
                this.put("Zoom", Keys.Zoom);
                this.put("Pa1", Keys.Pa1);
                this.put("OemClear", Keys.OemClear);
            }
        };
        StringToButtons = new HashMap<String, Buttons>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("A", Buttons.A);
                this.put("X", Buttons.X);
                this.put("Y", Buttons.Y);
                this.put("B", Buttons.B);
                this.put("RightShoulder", Buttons.RightShoulder);
                this.put("RightTrigger", Buttons.RightTrigger);
                this.put("LeftShoulder", Buttons.LeftShoulder);
                this.put("LeftTrigger", Buttons.LeftTrigger);
                this.put("DPadUp", Buttons.DPadUp);
                this.put("DPadDown", Buttons.DPadDown);
                this.put("DPadLeft", Buttons.DPadLeft);
                this.put("DPadRight", Buttons.DPadRight);
                this.put("RightThumbstickUp", Buttons.RightThumbstickUp);
                this.put("RightThumbstickDown", Buttons.RightThumbstickDown);
                this.put("RightThumbstickLeft", Buttons.RightThumbstickLeft);
                this.put("RightThumbstickRight", Buttons.RightThumbstickRight);
                this.put("LeftThumbstickUp", Buttons.LeftThumbstickUp);
                this.put("LeftThumbstickDown", Buttons.LeftThumbstickDown);
                this.put("LeftThumbstickLeft", Buttons.LeftThumbstickLeft);
                this.put("LeftThumbstickRight", Buttons.LeftThumbstickRight);
                this.put("Start", Buttons.Start);
                this.put("Back", Buttons.Back);
                this.put("LeftStick", Buttons.LeftStick);
                this.put("RightStick", Buttons.RightStick);
                this.put("BigButton", Buttons.BigButton);
            }
        };
        m_listKeys = new Keys[]{Keys.None, Keys.Back, Keys.Tab, Keys.Enter, Keys.Pause, Keys.CapsLock, Keys.Kana, Keys.Kanji, Keys.Escape, Keys.ImeConvert, Keys.ImeNoConvert, Keys.Space, Keys.PageUp, Keys.PageDown, Keys.End, Keys.Home, Keys.Left, Keys.Up, Keys.Right, Keys.Down, Keys.Select, Keys.Print, Keys.Execute, Keys.PrintScreen, Keys.Insert, Keys.Delete, Keys.Help, Keys.D0, Keys.D1, Keys.D2, Keys.D3, Keys.D4, Keys.D5, Keys.D6, Keys.D7, Keys.D8, Keys.D9, Keys.A, Keys.B, Keys.C, Keys.D, Keys.E, Keys.F, Keys.G, Keys.H, Keys.I, Keys.J, Keys.K, Keys.L, Keys.M, Keys.N, Keys.O, Keys.P, Keys.Q, Keys.R, Keys.S, Keys.T, Keys.U, Keys.V, Keys.W, Keys.X, Keys.Y, Keys.Z, Keys.LeftWindows, Keys.RightWindows, Keys.Apps, Keys.Sleep, Keys.NumPad0, Keys.NumPad1, Keys.NumPad2, Keys.NumPad3, Keys.NumPad4, Keys.NumPad5, Keys.NumPad6, Keys.NumPad7, Keys.NumPad8, Keys.NumPad9, Keys.Multiply, Keys.Add, Keys.Separator, Keys.Subtract, Keys.Decimal, Keys.Divide, Keys.F1, Keys.F2, Keys.F3, Keys.F4, Keys.F5, Keys.F6, Keys.F7, Keys.F8, Keys.F9, Keys.F10, Keys.F11, Keys.F12, Keys.F13, Keys.F14, Keys.F15, Keys.F16, Keys.F17, Keys.F18, Keys.F19, Keys.F20, Keys.F21, Keys.F22, Keys.F23, Keys.F24, Keys.NumLock, Keys.Scroll, Keys.LeftShift, Keys.RightShift, Keys.LeftControl, Keys.RightControl, Keys.LeftAlt, Keys.RightAlt, Keys.BrowserBack, Keys.BrowserForward, Keys.BrowserRefresh, Keys.BrowserStop, Keys.BrowserSearch, Keys.BrowserFavorites, Keys.BrowserHome, Keys.VolumeMute, Keys.VolumeDown, Keys.VolumeUp, Keys.MediaNextTrack, Keys.MediaPreviousTrack, Keys.MediaStop, Keys.MediaPlayPause, Keys.LaunchMail, Keys.SelectMedia, Keys.LaunchApplication1, Keys.LaunchApplication2, Keys.OemSemicolon, Keys.OemPlus, Keys.OemComma, Keys.OemMinus, Keys.OemPeriod, Keys.OemQuestion, Keys.OemTilde, Keys.ChatPadGreen, Keys.ChatPadOrange, Keys.OemOpenBrackets, Keys.OemPipe, Keys.OemCloseBrackets, Keys.OemQuotes, Keys.Oem8, Keys.OemBackslash, Keys.ProcessKey, Keys.OemCopy, Keys.OemAuto, Keys.OemEnlW, Keys.Attn, Keys.Crsel, Keys.Exsel, Keys.EraseEof, Keys.Play, Keys.Zoom, Keys.Pa1, Keys.OemClear};
        m_listButtons = new Buttons[]{Buttons.DPadUp, Buttons.DPadDown, Buttons.DPadLeft, Buttons.DPadRight, Buttons.Start, Buttons.Back, Buttons.LeftStick, Buttons.RightStick, Buttons.LeftShoulder, Buttons.RightShoulder, Buttons.BigButton, Buttons.A, Buttons.B, Buttons.X, Buttons.Y, Buttons.LeftThumbstickLeft, Buttons.RightTrigger, Buttons.LeftTrigger, Buttons.RightThumbstickUp, Buttons.RightThumbstickDown, Buttons.RightThumbstickRight, Buttons.RightThumbstickLeft, Buttons.LeftThumbstickUp, Buttons.LeftThumbstickDown, Buttons.LeftThumbstickRight};
    }

    public static PlayerIndex PlayerIndex() {
        return m_playerIndex;
    }

    public static void ChangeMappingKey(Buttons _btn, Keys _key) {
        MappingGamePadKey.put(_btn, _key);
    }

    public static Keys GetMappingKeyForButton(Buttons _btn) {
        return MappingGamePadKey.get((Object)_btn);
    }

    public static boolean IsAnyStick() {
        return InputManager.IsButtonDown(Buttons.RightThumbstickUp) || InputManager.IsButtonDown(Buttons.RightThumbstickDown) || InputManager.IsButtonDown(Buttons.RightThumbstickLeft) || InputManager.IsButtonDown(Buttons.RightThumbstickRight) || InputManager.IsButtonDown(Buttons.LeftThumbstickUp) || InputManager.IsButtonDown(Buttons.LeftThumbstickDown) || InputManager.IsButtonDown(Buttons.LeftThumbstickLeft) || InputManager.IsButtonDown(Buttons.LeftThumbstickRight);
    }

    public static boolean IsButtonDown(Buttons button) {
        m_tmpBool = FlxG.gamepads.isButtonDown(button, m_playerIndex, m_outPlayerIndex);
        if (m_handleKeyboard && !m_tmpBool) {
            m_tmpBool = FlxG.keys.isKeyDown(MappingGamePadKey.get((Object)button), m_playerIndex, m_outPlayerIndex);
            if (m_tmpBool) {
                FlxGamepad.GamepadConnectedFlagMask(false);
            }
        } else {
            FlxGamepad.GamepadConnectedFlagMask(true);
        }
        return m_tmpBool;
    }

    public static boolean IsButtonDown(Buttons button, boolean _bAvoidKeyboard) {
        m_tmpBool = FlxG.gamepads.isButtonDown(button, m_playerIndex, m_outPlayerIndex);
        if (!_bAvoidKeyboard && m_handleKeyboard && !m_tmpBool) {
            m_tmpBool = FlxG.keys.isKeyDown(MappingGamePadKey.get((Object)button), m_playerIndex, m_outPlayerIndex);
        }
        return m_tmpBool;
    }

    public static boolean IsNewButtonRelease(Buttons button) {
        m_tmpBool = FlxG.gamepads.isNewButtonRelease(button, m_playerIndex, m_outPlayerIndex);
        if (m_handleKeyboard && !m_tmpBool) {
            m_tmpBool = FlxG.keys.isNewKeyRelease(MappingGamePadKey.get((Object)button), m_playerIndex, m_outPlayerIndex);
        }
        return m_tmpBool;
    }

    public static boolean IsNewGuidePress() {
        return FlxG.gamepads.isNewGuidePress();
    }

    public static boolean IsNewButtonPress(Buttons button) {
        return InputManager.IsNewButtonPress(button, false);
    }

    public static boolean IsNewButtonPress(Buttons button, boolean avoidKeyboard) {
        m_tmpBool = FlxG.gamepads.isNewButtonPress(button, m_playerIndex, m_outPlayerIndex);
        if (m_tmpBool) {
            FlxGamepad.GamepadConnectedFlagMask(true);
        }
        if (!avoidKeyboard && m_handleKeyboard && !m_tmpBool && (m_tmpBool = FlxG.keys.isNewKeyPress(MappingGamePadKey.get((Object)button), m_playerIndex, m_outPlayerIndex))) {
            FlxGamepad.GamepadConnectedFlagMask(false);
        }
        return m_tmpBool;
    }

    public static boolean IsAnyButtonPress(boolean _bExcludeSticks) {
        Enum[] enumArray = m_listButtons;
        int n = m_listButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Buttons btn = enumArray[n2];
            if (!(_bExcludeSticks && InputManager._isAnalogButton(btn) || !FlxG.gamepads.isNewButtonPress(btn))) {
                FlxGamepad.GamepadConnectedFlagMask(true);
                return true;
            }
            ++n2;
        }
        enumArray = m_listKeys;
        n = m_listKeys.length;
        n2 = 0;
        while (n2 < n) {
            Enum key = enumArray[n2];
            if (FlxG.keys.isNewKeyPress((Keys)key, m_playerIndex, m_outPlayerIndex)) {
                FlxGamepad.GamepadConnectedFlagMask(false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean IsAnyGamepadButtonPressed() {
        Buttons[] buttonsArray = m_listButtons;
        int n = m_listButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Buttons btn = buttonsArray[n2];
            if (!InputManager._isAnalogButton(btn) && FlxG.gamepads.isNewButtonPress(btn)) {
                FlxGamepad.GamepadConnectedFlagMask(true);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean IsAnyKeyPressed() {
        Keys[] keysArray = m_listKeys;
        int n = m_listKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Keys key = keysArray[n2];
            if (FlxG.keys.isNewKeyPress(key, m_playerIndex, m_outPlayerIndex)) {
                FlxGamepad.GamepadConnectedFlagMask(false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean _isAnalogButton(Buttons _button) {
        return _button == Buttons.LeftStick || _button == Buttons.RightStick || _button == Buttons.LeftThumbstickLeft || _button == Buttons.RightTrigger || _button == Buttons.LeftTrigger || _button == Buttons.RightThumbstickUp || _button == Buttons.RightThumbstickDown || _button == Buttons.RightThumbstickRight || _button == Buttons.RightThumbstickLeft || _button == Buttons.LeftThumbstickUp || _button == Buttons.LeftThumbstickDown || _button == Buttons.LeftThumbstickRight;
    }

    public static boolean IsMainControllerIdentified() {
        if (FlxG.gamepads.isNewButtonPress(Buttons.Start, null, m_outPlayerIndex)) {
            m_playerIndex = m_outPlayerIndex;
            return true;
        }
        return false;
    }

    public static boolean IsMainControllerMatchIndex(PlayerIndex _index) {
        return _index == m_playerIndex;
    }

    public static boolean IsMainControllerLoggedIn() {
        return true;
    }

    public static boolean IsMainControllerCanGoToMarketPlace() {
        return true;
    }

    public static char GetNewKeyboardReadableKeyPress() {
        char _key = '\u0000';
        boolean shiftDown = FlxG.keys.isKeyDown(Keys.RightShift, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isKeyDown(Keys.LeftShift, m_playerIndex, m_outPlayerIndex);
        Keys[] keysArray = m_listKeys;
        int n = m_listKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Keys key = keysArray[n2];
            if (FlxG.keys.isNewKeyPress(key, m_playerIndex, m_outPlayerIndex)) {
                if (shiftDown && key == Keys.D6 || key == Keys.Subtract) {
                    _key = '-';
                    return _key;
                }
                if (shiftDown && key == Keys.D8) {
                    _key = '_';
                    return _key;
                }
                if (key == Keys.OemComma) {
                    _key = ',';
                    return _key;
                }
                if (key == Keys.Space) {
                    _key = ' ';
                    return _key;
                }
                if (key.ordinal() >= Keys.A.ordinal() && key.ordinal() <= Keys.Z.ordinal()) {
                    _key = key.name().charAt(0);
                    return _key;
                }
                if (key.ordinal() >= Keys.D0.ordinal() && key.ordinal() <= Keys.D9.ordinal()) {
                    _key = Integer.toString(key.ordinal() - Keys.D0.ordinal()).charAt(0);
                    return _key;
                }
                if (key.ordinal() >= Keys.NumPad0.ordinal() && key.ordinal() <= Keys.NumPad9.ordinal()) {
                    _key = Integer.toString(key.ordinal() - Keys.NumPad0.ordinal()).charAt(0);
                    return _key;
                }
            }
            ++n2;
        }
        return _key;
    }

    public static boolean IsNewKeyPress(Keys _key) {
        if (FlxG.keys.isNewKeyPress(_key, m_playerIndex, m_outPlayerIndex)) {
            FlxGamepad.GamepadConnectedFlagMask(false);
            return true;
        }
        return false;
    }

    public static boolean IsNewKeyRelease(Keys _key) {
        return FlxG.keys.isNewKeyRelease(_key, m_playerIndex, m_outPlayerIndex);
    }

    public static boolean IsKeyDown(Keys _key) {
        return FlxG.keys.isKeyDown(_key, m_playerIndex, m_outPlayerIndex);
    }

    public static boolean IsNewIntergerKeyPress(ref<Integer> _valueRef) {
        int _value = 0;
        boolean shiftDown = FlxG.keys.isKeyDown(Keys.RightShift, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isKeyDown(Keys.LeftShift, m_playerIndex, m_outPlayerIndex);
        Keys[] keysArray = m_listKeys;
        int n = m_listKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Keys key = keysArray[n2];
            if (FlxG.keys.isNewKeyPress(key, m_playerIndex, m_outPlayerIndex)) {
                if (shiftDown && key.ordinal() >= Keys.D0.ordinal() && key.ordinal() <= Keys.D9.ordinal()) {
                    _value = key.ordinal() - Keys.D0.ordinal();
                    _valueRef.set(_value);
                    return true;
                }
                if (key.ordinal() >= Keys.NumPad0.ordinal() && key.ordinal() <= Keys.NumPad9.ordinal()) {
                    _value = key.ordinal() - Keys.NumPad0.ordinal();
                    _valueRef.set(_value);
                    return true;
                }
            }
            ++n2;
        }
        _valueRef.set(_value);
        return false;
    }

    public static boolean IsNewMinusKeyPress() {
        boolean shiftDown;
        boolean bl = shiftDown = FlxG.keys.isKeyDown(Keys.RightShift, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isKeyDown(Keys.LeftShift, m_playerIndex, m_outPlayerIndex);
        return shiftDown && FlxG.keys.isNewKeyPress(Keys.D6, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isNewKeyPress(Keys.Subtract, m_playerIndex, m_outPlayerIndex);
    }

    public static boolean IsNewFloatDotKeyPress() {
        return FlxG.keys.isNewKeyPress(Keys.OemComma, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isNewKeyPress(Keys.OemPeriod, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isNewKeyPress(Keys.Decimal, m_playerIndex, m_outPlayerIndex);
    }

    public static char IsNewCharKeyPress(boolean _bExtendedChars) {
        char _value = '\u0000';
        boolean shiftDown = FlxG.keys.isKeyDown(Keys.RightShift, m_playerIndex, m_outPlayerIndex) || FlxG.keys.isKeyDown(Keys.LeftShift, m_playerIndex, m_outPlayerIndex);
        boolean algGr = FlxG.keys.isKeyDown(Keys.RightAlt, m_playerIndex, m_outPlayerIndex);
        Keys[] keysArray = m_listKeys;
        int n = m_listKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Keys key = keysArray[n2];
            if (FlxG.keys.isNewKeyPress(key, m_playerIndex, m_outPlayerIndex)) {
                if (key == Keys.Space) {
                    _value = ' ';
                    return _value;
                }
                if (key.ordinal() >= Keys.A.ordinal() && key.ordinal() <= Keys.Z.ordinal()) {
                    _value = shiftDown ? (char)key.name().toUpperCase().charAt(0) : (char)key.name().toLowerCase().charAt(0);
                    return _value;
                }
                if (algGr && _bExtendedChars) {
                    if (key == Keys.D0) {
                        _value = '@';
                        return _value;
                    }
                } else if (!shiftDown) {
                    if (key == Keys.D6) {
                        _value = '-';
                        return _value;
                    }
                    if (key == Keys.D8) {
                        _value = '_';
                        return _value;
                    }
                    if (key == Keys.OemComma) {
                        _value = ',';
                        return _value;
                    }
                    if (key == Keys.OemPeriod) {
                        _value = ';';
                        return _value;
                    }
                    if (_bExtendedChars && key == Keys.D4) {
                        _value = '\'';
                        return _value;
                    }
                } else if (shiftDown) {
                    if (key == Keys.Divide) {
                        _value = '/';
                        return _value;
                    }
                    if (key == Keys.OemPeriod) {
                        _value = '.';
                        return _value;
                    }
                    if (key == Keys.OemPeriod) {
                        _value = '.';
                        return _value;
                    }
                }
            }
            ++n2;
        }
        return _value;
    }

    public static void LoadKeyboardMapping() {
        Document doc = null;
        doc = FlxG.Content().LoadXDocumentOutOfContent("config/KeyMapping");
        if (doc != null) {
            NodeList gamepadDefaultMappingsNodeList;
            String controllerName;
            NodeList gamepadValidNamesList;
            String value;
            String id;
            Element elem = (Element)doc.getElementsByTagName("CustomKeyboardMappings").item(0);
            NodeList elemMappingNodeList = elem.getElementsByTagName("Mapping");
            int elemMappingId = 0;
            while (elemMappingId < elemMappingNodeList.getLength()) {
                Element elemMapping = (Element)elemMappingNodeList.item(elemMappingId);
                id = elemMapping.getAttribute("id");
                value = elemMapping.getAttribute("value");
                if (StringToButtons.containsKey(id)) {
                    Buttons button = StringToButtons.get(id);
                    if (StringToKeys.containsKey(value)) {
                        Keys key = StringToKeys.get(value);
                        MappingGamePadKey.put(button, key);
                    }
                }
                ++elemMappingId;
            }
            Element gamepadValidNames = (Element)doc.getElementsByTagName("GamepadValidNames").item(0);
            if (gamepadValidNames != null && (gamepadValidNamesList = gamepadValidNames.getElementsByTagName("Name")) != null && gamepadValidNamesList.getLength() > 0) {
                GamePad.Instance().resetValidPartialGamepadNames();
                int gamepadNameId = 0;
                while (gamepadNameId < gamepadValidNamesList.getLength()) {
                    Element elemGamePadaValidName = (Element)gamepadValidNamesList.item(gamepadNameId);
                    GamePad.Instance().addValidPartialGamepadName(elemGamePadaValidName.getAttribute("value"));
                    ++gamepadNameId;
                }
                GamePad.Instance().recomputeGamePad();
            }
            elem = null;
            NodeList gamepadMappingsCustomNodeList = doc.getElementsByTagName("CustomGamepadMappings");
            if (gamepadMappingsCustomNodeList.getLength() > 0 && (controllerName = FlxG.gamepads.curPadState()[0].ControllerName(0)) != null) {
                Element customGamepadMapping = (Element)gamepadMappingsCustomNodeList.item(0);
                NodeList customGamepadMappingNodeList = customGamepadMapping.getElementsByTagName("GamepadMappings");
                Element customElem = null;
                int i = 0;
                while (i < customGamepadMappingNodeList.getLength()) {
                    customElem = (Element)customGamepadMappingNodeList.item(i);
                    String mappingName = customElem.getAttribute("name");
                    String os = customElem.getAttribute("os");
                    if (mappingName != null && mappingName.equals(controllerName) && Utility.IsOs(os)) {
                        elem = customElem;
                        break;
                    }
                    ++i;
                }
            }
            if (elem == null && (gamepadDefaultMappingsNodeList = doc.getElementsByTagName("DefaultGamepadMappings")).getLength() > 0) {
                Element defaultMappings = (Element)gamepadDefaultMappingsNodeList.item(0);
                NodeList gamepadMappingsNodeList = defaultMappings.getElementsByTagName("GamepadMappings");
                elem = null;
                Element elemOs = null;
                int i = 0;
                while (i < gamepadMappingsNodeList.getLength()) {
                    elemOs = (Element)gamepadMappingsNodeList.item(i);
                    String os = elemOs.getAttribute("os");
                    if (os != null && os.length() > 0 && Utility.IsOs(os)) {
                        elem = elemOs;
                        break;
                    }
                    ++i;
                }
                if (elem == null) {
                    elem = (Element)gamepadMappingsNodeList.item(0);
                }
            }
            if (elem != null) {
                String forceIndex = elem.getAttribute("forceIndex");
                if (forceIndex != null && forceIndex.length() > 0) {
                    GamePad.ForcedGamePadIdSelection(Integer.parseInt(forceIndex));
                }
                NodeList elemGamepadMappingNodeList = elem.getElementsByTagName("GamepadMapping");
                int elemGamepadMappingId = 0;
                while (elemGamepadMappingId < elemGamepadMappingNodeList.getLength()) {
                    Element elemGamepadMapping = (Element)elemGamepadMappingNodeList.item(elemGamepadMappingId);
                    id = elemGamepadMapping.getAttribute("id");
                    value = elemGamepadMapping.getAttribute("value");
                    if (id != null && id.length() > 0 && value != null && value.length() > 0) {
                        InputManager._BindNewGamepadMapping(id, value);
                    }
                    ++elemGamepadMappingId;
                }
            }
        }
    }

    protected static void _BindNewGamepadMapping(String buttonId, String value) {
        GamePadItemState.GamePadItemType gtype = GamePadItemState.GamePadItemType.valueOf(value);
        if (gtype != null && StringToButtons.containsKey(buttonId)) {
            Buttons btn = StringToButtons.get(buttonId);
            GamePadMapper.Instance().changeMapping(btn, gtype);
        }
    }

    public static String GetFriendlyButtonName(Buttons _button, boolean _bUseBraket) {
        if (FlxG.gamepads.isGamepadConnected()) {
            return InputManager.GetStringKeyFromButtons(_button);
        }
        Keys key = MappingGamePadKey.get((Object)_button);
        return InputManager.GetFriendlyKeyName(key, _bUseBraket);
    }

    public static String GetFriendlyKeyName(Keys _key, boolean _bUseBraket) {
        if (_bUseBraket) {
            return "[" + InputManager.GetStringKeyFromKeys(_key) + "]";
        }
        return InputManager.GetStringKeyFromKeys(_key);
    }

    protected static String GetStringKeyFromButtons(Buttons _btn) {
        for (Map.Entry<String, Buttons> btnStr : StringToButtons.entrySet()) {
            if (_btn != btnStr.getValue()) continue;
            return btnStr.getKey();
        }
        return "?";
    }

    protected static String GetStringKeyFromKeys(Keys _key) {
        for (Map.Entry<String, Keys> keyStr : StringToKeys.entrySet()) {
            if (_key != keyStr.getValue()) continue;
            return keyStr.getKey();
        }
        return "?";
    }

    public static boolean IsAnyGamepadConnected() {
        return FlxG.gamepads.isGamepadConnected();
    }

    public static boolean IsNewGamepadConnected() {
        return FlxG.gamepads.isNewGamepadConnected();
    }

    public static boolean IsNewGamepadDisconnected() {
        return FlxG.gamepads.isNewGamepadDisconnected();
    }

    public static boolean IsAnyMouseButtonPress() {
        return FlxG.mouse.justPressed();
    }

    public static boolean IsAnyMouseButtonDown() {
        return FlxG.mouse.pressed();
    }

    public static boolean IsLeftMouseButtonPress() {
        return FlxG.mouse.justLeftPressed();
    }

    public static boolean IsLeftMouseButtonDown() {
        return FlxG.mouse.leftPressed();
    }

    public static boolean IsRightMouseButtonPress() {
        return FlxG.mouse.justRightPressed();
    }

    public static boolean IsRightMouseButtonDown() {
        return FlxG.mouse.rightPressed();
    }

    public static boolean IsJustMouseWheelUp() {
        return FlxG.mouse.justWheelUp();
    }

    public static boolean IsJustMouseWheelDown() {
        return FlxG.mouse.justWheelDown();
    }

    public static boolean IsMouseJustMoved() {
        return FlxG.mouse.justMoved();
    }

    public static int MouseWheel() {
        return FlxG.mouse.deltaWheel();
    }

    public static float MouseX() {
        return FlxG.mouse.x();
    }

    public static float MouseY() {
        return FlxG.mouse.y();
    }

    public static float MouseSpriteX() {
        if (FlxG.mouse.cursor != null) {
            return FlxG.mouse.cursor.x + (float)FlxG.mouse.cursor.offset.X - FlxG.mouse.cursor.width * 0.5f;
        }
        return 0.0f;
    }

    public static float MouseSpriteY() {
        if (FlxG.mouse.cursor != null) {
            return FlxG.mouse.cursor.y + (float)FlxG.mouse.cursor.offset.Y - FlxG.mouse.cursor.height * 0.5f;
        }
        return 0.0f;
    }
}

