/*
 * Decompiled with CFR 0.152.
 */
package SSS.Util;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import SSS.Tween.Tweenable;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class MultipleLinesText
extends FlxSprite
implements Tweenable {
    FlxText.FlxJustification m_justification = FlxText.FlxJustification.Center;
    FlxText[] m_texts;
    float m_interline = 0.0f;

    public FlxText.FlxJustification Justification() {
        return this.m_justification;
    }

    public void Justification(FlxText.FlxJustification value) {
        this.m_justification = value;
    }

    public void updateAttributes(float _x, float _y, float _scale, float _angle, float _alpha) {
        if (this.scale() != _scale) {
            this.scale(_scale);
            this._scaleTexts();
        }
        if (this.x != _x || this.y != _y || this.scale() != _scale) {
            this.x = _x;
            this.y = _y;
            this._positionnateTexts();
        }
        if (this.alpha() != _alpha) {
            this.alpha(_alpha);
            this._transparenceTexts();
        }
    }

    public void updateShadowColor(Color _color, float _offset) {
        FlxText txt = null;
        int i = 0;
        while (i < this.m_texts.length) {
            txt = this.m_texts[i];
            if (txt != null) {
                txt.UseShadow(true);
                txt.shadow(_color);
                txt.ShadowOffset(_offset);
            }
            ++i;
        }
    }

    public void setAlpha(float _alpha) {
        if (this.alpha() != _alpha) {
            this.alpha(_alpha);
            this._transparenceTexts();
        }
    }

    public void initAttributes(String _text, Color _color, float _x, float _y, float _scale, float _alpha, float _interline) {
        this.x = _x;
        this.y = _y;
        this.scale(_scale);
        this.alpha(_alpha);
        this.color(_color);
        this.m_interline = _interline;
        this.changeText(_text);
    }

    public void changePosition(float _x, float _y) {
        this.x = _x;
        this.y = _y;
        this._positionnateTexts();
    }

    public void changeText(String _text) {
        String[] lines = _text.split(FlxText.LineDelimiterRegEx);
        this.m_texts = new FlxText[lines.length];
        FlxText txt = null;
        int i = 0;
        while (i < this.m_texts.length) {
            txt = new FlxText(0.0f, 0.0f, FlxG.width);
            txt.text(lines[i]);
            txt.color(this._color);
            txt.alpha(this._alpha);
            txt.scale(this.scale());
            txt.UseSpecialBalises = true;
            txt.ComposedText = true;
            txt.UseShadow(false);
            this.m_texts[i] = txt;
            ++i;
        }
        this._positionnateTexts();
    }

    public void changeAlpha(float alpha) {
        this._alpha = alpha;
        this._transparenceTexts();
    }

    protected void _positionnateTexts() {
        if (this.m_texts != null && this.m_texts.length > 0) {
            float step = (float)this.m_texts[0].textHeight() + this.m_interline;
            float curx = this.m_justification == FlxText.FlxJustification.Center ? this.x - this.m_texts[0].width * 0.5f : this.x;
            float cury = this.y;
            cury -= step * (float)(this.m_texts.length - 1) * 0.5f - this.m_texts[0].height * 0.5f;
            FlxText txt = null;
            int i = 0;
            while (i < this.m_texts.length) {
                txt = this.m_texts[i];
                txt.alignment = this.m_justification;
                txt.x = curx;
                txt.y = cury;
                cury += step;
                ++i;
            }
        }
    }

    protected void _colorizeTexts() {
        if (this.m_texts != null && this.m_texts.length > 0) {
            int i = 0;
            while (i < this.m_texts.length) {
                this.m_texts[i].color(this.color());
                ++i;
            }
        }
    }

    protected void _transparenceTexts() {
        if (this.m_texts != null && this.m_texts.length > 0) {
            int i = 0;
            while (i < this.m_texts.length) {
                this.m_texts[i].alpha(this.alpha());
                ++i;
            }
        }
    }

    protected void _scaleTexts() {
        if (this.m_texts != null && this.m_texts.length > 0) {
            int i = 0;
            while (i < this.m_texts.length) {
                this.m_texts[i].scale(this.scale());
                ++i;
            }
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (this.m_texts != null && this.m_texts.length > 0) {
            float step = this.m_texts[0].textHeight();
            int i = 0;
            while (i < this.m_texts.length) {
                this.m_texts[i].render(spriteBatch);
                ++i;
            }
        }
    }

    @Override
    public void TweenPosition(float _cx, float _cy) {
        this.x = _cx - this.width * 0.5f;
        this.y = _cy - this.height * 0.5f;
        this._positionnateTexts();
    }

    @Override
    public void TweenColor(float _r, float _g, float _b) {
        this.color(new Color(_r, _g, _b));
        this._colorizeTexts();
    }

    @Override
    public void TweenAlpha(float _a) {
        this.setAlpha(_a);
        this._transparenceTexts();
    }

    @Override
    public void TweenAngle(float _angle) {
    }

    @Override
    public void TweenScale(float _scalex, float _scaley) {
        this.scale(_scalex);
        this._scaleTexts();
    }

    @Override
    public void TweenVolume(float _volume) {
    }

    @Override
    public Vector2 GetTweenPosition() {
        return new Vector2(this.x + this.width * 0.5f, this.y + this.height * 0.5f);
    }

    @Override
    public Vector2 GetTweenScale() {
        return new Vector2(this.scaleX(), this.scaleY());
    }

    @Override
    public float GetTweenAlpha() {
        return this.alpha();
    }

    @Override
    public float GetTweenVolume() {
        return 0.0f;
    }
}

