/*
 * Decompiled with CFR 0.152.
 */
package SSS.Util;

import Microsoft.Xna.Framework.GamerServices.Guide;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Behaviour;
import SSS.SssGroup;
import SSS.Util.InputManager;
import System.Globalization.CultureInfo;
import org.flixel.FlxEvent;
import org.flixel.FlxSprite;
import org.flixel.FlxText;
import org.flixel.FlxU;
import org.flixel.event.FlxSpriteCollisionEvent;

public class Utility {
    static FlxSpriteCollisionEvent CollisionEventObject = new FlxSpriteCollisionEvent(null, null);
    static String[] m_contentPath = new String[eContentPath.eContentPath_Num.ordinal()];
    public static String[] ArrayStringDigit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    static Vector2 D1 = new Vector2();
    static Vector2 D2 = new Vector2();
    static Vector2 ptD1beg = new Vector2();
    static Vector2 ptD1end = new Vector2();
    static Vector2 ptD2beg = new Vector2();
    static Vector2 ptD2end = new Vector2();
    protected static CultureInfo Culture_French = new CultureInfo("fr-FR");
    protected static CultureInfo Culture_English = new CultureInfo("en-US");
    static eOsType OsType = eOsType.Unknown;

    public static String GetContentPath(eContentPath _contentPath) {
        String contentPath;
        if (m_contentPath[_contentPath.ordinal()] == null) {
            contentPath = "Content/";
            switch (_contentPath) {
                case eContentPath_Cinematic: {
                    contentPath = String.valueOf(contentPath) + "sss/cinematics/";
                    break;
                }
                case eContentPath_Particle: {
                    contentPath = String.valueOf(contentPath) + "sss/particles/";
                    break;
                }
                case eContentPath_Level: {
                    contentPath = String.valueOf(contentPath) + "sss/level/";
                    break;
                }
                case eContentPath_Resource: {
                    contentPath = String.valueOf(contentPath) + "sss/resource/";
                }
            }
            Utility.m_contentPath[_contentPath.ordinal()] = contentPath;
        }
        contentPath = m_contentPath[_contentPath.ordinal()];
        return contentPath;
    }

    public static boolean IsHorizontallyNearby(float _actor1Centerx, float _actor1Width, float _actor2Centerx, float _actor2Width, float _marginFactor) {
        float maxDistMargin;
        float dist = _actor1Centerx - _actor2Centerx;
        if (dist < 0.0f) {
            dist *= -1.0f;
        }
        return dist < (maxDistMargin = (_actor1Width * 0.5f + _actor2Width * 0.5f) * _marginFactor);
    }

    public static CultureInfo DefaultCulture() {
        return Culture_English;
    }

    public static float ToSingle(String _value) {
        return Float.parseFloat(_value);
    }

    public static eOsType GetOsType() {
        if (OsType == eOsType.Unknown) {
            Utility.DetermineOsName();
        }
        return OsType;
    }

    public static float GetTextButtonScale(FlxSprite _iconKey, FlxText _text) {
        float txtWidth = _text.textWidth();
        int numLetter = _text.text().length();
        float scale = 1.0f + (_iconKey.scale() - 1.0f) * 1.5f;
        if (numLetter <= 3) {
            return 2.0f * scale;
        }
        return scale * (_iconKey.width / (txtWidth * 2.5f));
    }

    public static boolean IsOs(String osName) {
        eOsType osType = null;
        try {
            osType = eOsType.valueOf(osName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (osType != null) {
            return osType == OsType;
        }
        return false;
    }

    public static eOsType DetermineOsName() {
        String os = System.getProperty("os.name");
        OsType = os.toLowerCase().indexOf("windows") > -1 ? eOsType.Windows : (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1 ? eOsType.Linux : (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? eOsType.OSX : eOsType.Linux));
        return OsType;
    }

    public static boolean IsActorsPhysicsOverlappingFast(FlxSprite _a1, FlxSprite _a2) {
        Utility.ptD1beg.X = _a1.x;
        Utility.ptD1beg.Y = _a1.y;
        Utility.ptD1end.X = _a2.x + _a2.width;
        Utility.ptD1end.Y = _a2.y + _a2.height;
        Utility.ptD2beg.X = _a2.x;
        Utility.ptD2beg.Y = _a2.y;
        Utility.ptD2end.X = _a1.x + _a1.width;
        Utility.ptD2end.Y = _a1.y + _a1.height;
        Utility.D1.X = Utility.ptD1end.X - Utility.ptD1beg.X;
        Utility.D1.Y = Utility.ptD1end.Y - Utility.ptD1beg.Y;
        Utility.D2.X = Utility.ptD2end.X - Utility.ptD2beg.X;
        Utility.D2.Y = Utility.ptD2end.Y - Utility.ptD2beg.Y;
        if (Utility.D1.X < 0.0f || Utility.D1.Y < 0.0f) {
            return false;
        }
        return !(Utility.D2.X < 0.0f) && !(Utility.D2.Y < 0.0f);
    }

    public static boolean IsActorsVisualOverlappingFast(FlxSprite _a1, FlxSprite _a2) {
        Utility.ptD1beg.X = _a1.x;
        Utility.ptD1beg.Y = _a1.y;
        Utility.ptD1end.X = _a2.x + _a2.realWidth() * _a2.scaleX();
        Utility.ptD1end.Y = _a2.y + _a2.realHeight() * _a2.scaleY();
        Utility.ptD2beg.X = _a2.x;
        Utility.ptD2beg.Y = _a2.y;
        Utility.ptD2end.X = _a1.x + _a1.realWidth() * _a1.scaleX();
        Utility.ptD2end.Y = _a1.y + _a1.realHeight() * _a1.scaleY();
        Utility.D1.X = Utility.ptD1end.X - Utility.ptD1beg.X;
        Utility.D1.Y = Utility.ptD1end.Y - Utility.ptD1beg.Y;
        Utility.D2.X = Utility.ptD2end.X - Utility.ptD2beg.X;
        Utility.D2.Y = Utility.ptD2end.Y - Utility.ptD2beg.Y;
        if (Utility.D1.X < 0.0f || Utility.D1.Y < 0.0f) {
            return false;
        }
        return !(Utility.D2.X < 0.0f) && !(Utility.D2.Y < 0.0f);
    }

    public static int Clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static void SssU_collide(Actor _actorToCollide, SssGroup _listToCollide, FlxEvent.SpriteCollisionEvent Callback) {
        Actor actor = null;
        int i = 0;
        while (i < _listToCollide.members.size()) {
            actor = (Actor)_listToCollide.members.get(i);
            if (actor != null && !actor.equals(_actorToCollide) && Utility.IsActorsPhysicsOverlappingFast(_actorToCollide, actor)) {
                CollisionEventObject.Object1(actor);
                CollisionEventObject.Object2(_actorToCollide);
                FlxU.solveXCollision(_actorToCollide, CollisionEventObject);
                FlxU.solveYCollision(_actorToCollide, CollisionEventObject);
                Callback.callback(actor, actor, _actorToCollide);
            }
            ++i;
        }
    }

    public static boolean GuideIsVisible() {
        try {
            return Guide.IsVisible;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void ShowSignInGuideNotBlocking() {
        if (!Utility.GuideIsVisible()) {
            try {
                Guide.ShowSignIn(1, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void ShowSignInGuideIfneededNotBlocking() {
        if (!InputManager.IsMainControllerLoggedIn() && !Utility.GuideIsVisible()) {
            try {
                Guide.ShowSignIn(1, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void ShowSignInGuideIfneeded() {
        if (!InputManager.IsMainControllerLoggedIn()) {
            while (Utility.GuideIsVisible()) {
            }
            try {
                Guide.ShowSignIn(1, false);
            }
            catch (Exception e) {
                return;
            }
            while (Utility.GuideIsVisible()) {
            }
        }
    }

    public static boolean IsActorsOverlappingFastWithScale(FlxSprite _a1, FlxSprite _a2, float _scaleMargin) {
        Utility.ptD1beg.X = _a1.x;
        Utility.ptD1beg.Y = _a1.y;
        Utility.ptD1end.X = _a2.x + _a2.width * _scaleMargin;
        Utility.ptD1end.Y = _a2.y + _a2.height * _scaleMargin;
        Utility.ptD2beg.X = _a2.x;
        Utility.ptD2beg.Y = _a2.y;
        Utility.ptD2end.X = _a1.x + _a1.width * _scaleMargin;
        Utility.ptD2end.Y = _a1.y + _a1.height * _scaleMargin;
        Utility.D1.X = Utility.ptD1end.X - Utility.ptD1beg.X;
        Utility.D1.Y = Utility.ptD1end.Y - Utility.ptD1beg.Y;
        Utility.D2.X = Utility.ptD2end.X - Utility.ptD2beg.X;
        Utility.D2.Y = Utility.ptD2end.Y - Utility.ptD2beg.Y;
        if (Utility.D1.X < 0.0f || Utility.D1.Y < 0.0f) {
            return false;
        }
        return !(Utility.D2.X < 0.0f) && !(Utility.D2.Y < 0.0f);
    }

    public static void SssU_overlap(SssGroup _group, Actor _actor, Behaviour _behaviourCallback, int _callBackId) {
        Actor a = null;
        int i = 0;
        while (i < _group.members.size()) {
            a = (Actor)_group.members.get(i);
            if (a != null && !_actor.equals(a) && a.overlaps(_actor)) {
                CollisionEventObject.Object1(a);
                CollisionEventObject.Object2(_actor);
                _behaviourCallback.onOverlapsCallback(CollisionEventObject, _callBackId);
            }
            ++i;
        }
    }

    public static boolean SssU_overlapSomething(SssGroup _group, Actor _actor) {
        Actor a = null;
        int i = 0;
        while (i < _group.members.size()) {
            a = (Actor)_group.members.get(i);
            if (a != null && !_actor.equals(a) && a.overlaps(_actor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void SssU_overlapWithScale(SssGroup _group, Actor _actor, Behaviour _behaviourCallback, int _callBackId, float _scaleMargin) {
        Actor a = null;
        int i = 0;
        while (i < _group.members.size()) {
            a = (Actor)_group.members.get(i);
            if (a != null && !_actor.equals(a) && Utility.IsActorsOverlappingFastWithScale(a, _actor, _scaleMargin)) {
                CollisionEventObject.Object1(a);
                CollisionEventObject.Object2(_actor);
                _behaviourCallback.onOverlapsCallback(CollisionEventObject, _callBackId);
            }
            ++i;
        }
    }

    public static void SssU_overlapWithScale_Garbage(SssGroup _group, Actor _actor, FlxEvent.SpriteCollisionEvent Collide, float _scaleMargin) {
        Actor a = null;
        int i = 0;
        while (i < _group.members.size()) {
            a = (Actor)_group.members.get(i);
            if (a != null && !_actor.equals(a) && Utility.IsActorsOverlappingFastWithScale(a, _actor, _scaleMargin)) {
                CollisionEventObject.Object1(a);
                CollisionEventObject.Object2(_actor);
                Collide.callback(a, a, _actor);
            }
            ++i;
        }
    }

    public static boolean SssU_overlapSomethingWithScale(SssGroup _group, Actor _actor, float _scaleMargin) {
        Actor a = null;
        int i = 0;
        while (i < _group.members.size()) {
            a = (Actor)_group.members.get(i);
            if (a != null && !_actor.equals(a) && Utility.IsActorsOverlappingFastWithScale(a, _actor, _scaleMargin)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static enum eContentPath {
        eContentPath_Root,
        eContentPath_Level,
        eContentPath_Cinematic,
        eContentPath_Particle,
        eContentPath_Sound,
        eContentPath_Texture,
        eContentPath_Resource,
        eContentPath_Num;

    }

    public static enum eOsType {
        Windows,
        OSX,
        Linux,
        Unknown;

    }
}

