/*
 * Decompiled with CFR 0.152.
 */
package SSS.bigfile;

import SSS.Managers.FileManager;
import SSS.bigfile.BigFileItem;
import SSS.bigfile.BigFileTable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.Deflater;

public class BigFile {
    String m_path;
    String m_name;
    BigFileTable m_bfTable;
    BufferedInputStream m_buffer;
    boolean m_bLoaded = false;
    boolean m_bCompressed = false;
    byte[] m_tmpBuffer = null;
    int m_tmpBufferSize = 0;
    Deflater m_compresser = new Deflater();
    ArrayList<String> m_levelsAutorizedList = null;
    FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isFile()) {
                File dir;
                boolean valid;
                String name = file.getName();
                int dotPos = name.lastIndexOf(".");
                String extension = name.substring(dotPos);
                boolean bl = valid = !name.startsWith("-") && !name.contains("--") && !name.startsWith("Copie") && !name.startsWith("Copy") && !extension.equals(".db");
                if (file.length() > 153600L && extension.equals(".ogg")) {
                    valid = false;
                }
                if (BigFile.this.m_levelsAutorizedList != null && (dir = file.getParentFile()).isDirectory() && dir.getName().equals("level") && !BigFile.this.m_levelsAutorizedList.contains(name)) {
                    valid = false;
                }
                if (!valid) {
                    System.out.println("@@ Discared file: " + name);
                }
                return valid;
            }
            return false;
        }
    };
    FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                boolean valid;
                String name = file.getName();
                boolean bl = valid = !name.contains("backup") && !name.startsWith("_");
                if (!valid) {
                    System.out.println("## Discared DIR: " + name);
                }
                return valid;
            }
            return false;
        }
    };

    public BigFile(String path, String name, boolean _bCompressed) {
        this.m_path = path;
        this.m_name = name;
        this.m_bCompressed = _bCompressed;
        if (this.m_bCompressed) {
            this.m_name = String.valueOf(this.m_name) + "tm";
        }
        this.m_bfTable = new BigFileTable(this.m_bCompressed);
    }

    public void load() throws IOException {
        File file = new File(String.valueOf(this.m_path) + this.m_name);
        this.m_buffer = new BufferedInputStream(new FileInputStream(String.valueOf(this.m_path) + this.m_name), (int)file.length());
        this.m_buffer.mark(Integer.MAX_VALUE);
        this.m_bfTable.readTableFromStream(this.m_buffer);
        this.m_buffer.reset();
        this.m_bLoaded = true;
    }

    public ByteArrayInputStream getResourceStream(String resourceName) {
        int entryId;
        if (this.m_bLoaded && (entryId = this.m_bfTable.getEntryId(resourceName)) > -1) {
            try {
                int offset = this.m_bfTable.getOffset(entryId);
                int length = this.m_bfTable.getLenght(entryId);
                this._checkTmpBuffer(length);
                this.m_buffer.reset();
                int actuallySkiped = 0;
                while (offset > 0) {
                    actuallySkiped = (int)this.m_buffer.skip(offset);
                    offset -= actuallySkiped;
                }
                this.m_buffer.read(this.m_tmpBuffer, 0, length);
                this.m_buffer.reset();
                if (this.m_bCompressed && BigFile.IsFilenameCompressible(resourceName)) {
                    byte[] uncompressed = FileManager.Instance().decompressData(this.m_tmpBuffer);
                    return new ByteArrayInputStream(uncompressed, 0, uncompressed.length);
                }
                return new ByteArrayInputStream(this.m_tmpBuffer, 0, length);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    void _checkTmpBuffer(int length) {
        if (length > this.m_tmpBufferSize) {
            this.m_tmpBuffer = new byte[length];
            this.m_tmpBufferSize = length;
        }
    }

    public void setLevelsAutorizedList(ArrayList<String> _list) {
        this.m_levelsAutorizedList = _list;
    }

    public void build(String rootPath, String rootDir) {
        String originalRootPath = rootPath;
        rootPath = String.valueOf(rootPath) + rootDir + "/";
        ArrayList<BigFileItem> m_items = new ArrayList<BigFileItem>(200);
        File root = new File(rootPath);
        this.fillItems(root, m_items, originalRootPath);
        this.m_bfTable.createTableFromBigFileItem(m_items);
        try {
            DataOutputStream os = new DataOutputStream(new FileOutputStream(this.m_name));
            this.m_bfTable.writeTableToStream(os);
            for (BigFileItem bfItem : m_items) {
                this._writeBfItemToStream(os, bfItem);
            }
            os.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void _writeBfItemToStream(DataOutputStream os, BigFileItem bfItem) throws IOException {
        if (!bfItem.writeToStream(os)) {
            System.out.println("ERROR PARSING BF ITEM " + bfItem.EntryName());
        }
    }

    void fillItems(File rootdir, ArrayList<BigFileItem> _items, String rootPath) {
        File[] dirs;
        File[] files;
        File[] fileArray = files = rootdir.listFiles(this.fileFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getAbsolutePath().replace('\\', '/');
            String entryName = name.replace(rootPath, "");
            System.out.println("++ " + entryName);
            _items.add(new BigFileItem(name, entryName, this.m_bCompressed));
            ++n2;
        }
        File[] fileArray2 = dirs = rootdir.listFiles(this.directoryFilter);
        int n3 = dirs.length;
        n = 0;
        while (n < n3) {
            File dir = fileArray2[n];
            this.fillItems(dir, _items, rootPath);
            ++n;
        }
    }

    public static boolean IsFilenameCompressible(String filename) {
        return filename.endsWith(".xml") || filename.endsWith(".jsb") || filename.endsWith(".jgs") || filename.endsWith(".spritefont");
    }
}

