/*
 * Decompiled with CFR 0.152.
 */
package SSS.bigfile;

import SSS.Managers.FileManager;
import SSS.bigfile.BigFile;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class BigFileItem {
    String m_entryName;
    int m_offset;
    int m_lenght;
    File m_file;
    byte[] m_fileCompressedData = null;

    public String EntryName() {
        return this.m_entryName;
    }

    public void Offset(int value) {
        this.m_offset = value;
    }

    public int Length() {
        return this.m_lenght;
    }

    public BigFileItem(String filename, String entryName, boolean _bCompress) {
        this.m_entryName = entryName;
        this.m_file = new File(filename);
        if (_bCompress && BigFile.IsFilenameCompressible(filename)) {
            this.m_fileCompressedData = FileManager.Instance().compressData(FileManager.Instance().getFileContentByte(this.m_file, false));
            this.m_lenght = this.m_fileCompressedData.length;
            if (this.m_lenght <= 0) {
                System.out.println("ERROR SIZE on " + filename);
            }
        } else {
            this.m_lenght = (int)this.m_file.length();
        }
        this.m_offset = 0;
    }

    public boolean writeToStream(DataOutputStream os) {
        if (this.m_fileCompressedData != null) {
            try {
                os.write(this.m_fileCompressedData);
            }
            catch (IOException e) {
                return false;
            }
        }
        byte[] content = FileManager.Instance().getFileContentByte(this.m_file, false);
        try {
            os.write(content);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

