/*
 * Decompiled with CFR 0.152.
 */
package SSS.bigfile;

import SSS.Managers.FileManager;
import SSS.bigfile.BigFileItem;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.Deflater;

public class BigFileTable {
    Integer m_tableLen;
    Integer m_numEntry;
    Integer[] m_nameLenght;
    String[] m_name;
    Integer[] m_dataOffset;
    Integer[] m_dataLenght;
    ByteBuffer[] m_nameCompressed;
    HashMap<String, Integer> m_resourceNameToEntryId = null;
    boolean m_bCompressed = false;
    Deflater m_compresser;

    public BigFileTable(boolean _bCompressed) {
        this.m_bCompressed = _bCompressed;
        if (_bCompressed) {
            this.m_compresser = new Deflater();
        }
    }

    public void createTableFromBigFileItem(ArrayList<BigFileItem> _items) {
        int IntegerLength = 4;
        this.m_numEntry = _items.size();
        this.m_nameLenght = new Integer[this.m_numEntry.intValue()];
        if (this.m_bCompressed) {
            this.m_nameCompressed = new ByteBuffer[this.m_numEntry.intValue()];
            this.m_dataOffset = new Integer[this.m_numEntry.intValue()];
            this.m_dataLenght = new Integer[this.m_numEntry.intValue()];
        } else {
            this.m_name = new String[this.m_numEntry.intValue()];
            this.m_dataOffset = new Integer[this.m_numEntry.intValue()];
            this.m_dataLenght = new Integer[this.m_numEntry.intValue()];
        }
        int offset = 0;
        offset += IntegerLength;
        offset += this.m_nameLenght.length * IntegerLength;
        int i = 0;
        for (BigFileItem bfItem : _items) {
            if (this.m_bCompressed) {
                String stuffToCompress = bfItem.EntryName();
                byte[] output = new byte[stuffToCompress.length() * 2];
                Deflater compresser = new Deflater();
                compresser.setInput(stuffToCompress.getBytes());
                compresser.finish();
                int compressedDataLength = compresser.deflate(output);
                this.m_nameCompressed[i] = ByteBuffer.wrap(output);
                this.m_nameLenght[i] = compressedDataLength;
                offset += this.m_nameLenght[i] + IntegerLength;
                this.m_dataLenght[i] = bfItem.Length();
            } else {
                this.m_name[i] = bfItem.EntryName();
                this.m_nameLenght[i] = this.m_name[i].getBytes().length;
                offset += this.m_nameLenght[i] + IntegerLength;
                this.m_dataLenght[i] = bfItem.Length();
            }
            offset += IntegerLength;
            ++i;
        }
        i = 0;
        for (BigFileItem bfItem : _items) {
            this.m_dataOffset[i] = this.m_bCompressed ? Integer.valueOf(offset) : Integer.valueOf(offset);
            bfItem.Offset(offset);
            offset += bfItem.Length();
            ++i;
        }
    }

    public void writeTableToStream(DataOutputStream os) throws IOException {
        os.writeInt(this.m_numEntry);
        int i = 0;
        while (i < this.m_numEntry) {
            if (this.m_bCompressed) {
                os.writeInt(this.m_nameLenght[i]);
                byte[] nameCompressed = this.m_nameCompressed[i].array();
                os.write(nameCompressed, 0, this.m_nameLenght[i]);
                os.writeInt(this.m_dataOffset[i]);
                os.writeInt(this.m_dataLenght[i]);
                if (this.m_dataLenght[i] <= 0) {
                    System.out.println("ERROR SIZE on entry " + i);
                }
            } else {
                os.writeInt(this.m_nameLenght[i]);
                os.write(this.m_name[i].getBytes());
                os.writeInt(this.m_dataOffset[i]);
                os.writeInt(this.m_dataLenght[i]);
            }
            ++i;
        }
    }

    protected void intToByteArray(int value, byte[] array) {
        array[0] = (byte)(value >>> 24);
        array[1] = (byte)(value >>> 16);
        array[2] = (byte)(value >>> 8);
        array[3] = (byte)(value >>> 0);
    }

    int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public void readTableFromStream(BufferedInputStream is) throws IOException {
        byte[] intArray = new byte[4];
        int offset = 0;
        offset += is.read(intArray);
        this.m_numEntry = this.byteArrayToInt(intArray);
        this.m_nameLenght = new Integer[this.m_numEntry.intValue()];
        if (this.m_bCompressed) {
            this.m_name = new String[this.m_numEntry.intValue()];
            this.m_dataOffset = new Integer[this.m_numEntry.intValue()];
            this.m_dataLenght = new Integer[this.m_numEntry.intValue()];
        } else {
            this.m_name = new String[this.m_numEntry.intValue()];
            this.m_dataOffset = new Integer[this.m_numEntry.intValue()];
            this.m_dataLenght = new Integer[this.m_numEntry.intValue()];
        }
        this.m_resourceNameToEntryId = new HashMap(this.m_numEntry);
        int i = 0;
        while (i < this.m_numEntry) {
            offset += is.read(intArray);
            this.m_nameLenght[i] = this.byteArrayToInt(intArray);
            byte[] stringByte = new byte[this.m_nameLenght[i].intValue()];
            offset += is.read(stringByte);
            if (this.m_bCompressed) {
                byte[] nameBytes = FileManager.Instance().decompressData(stringByte);
                this.m_name[i] = new String(nameBytes);
                offset += is.read(intArray);
                this.m_dataOffset[i] = this.byteArrayToInt(intArray);
                offset += is.read(intArray);
                this.m_dataLenght[i] = this.byteArrayToInt(intArray);
            } else {
                this.m_name[i] = new String(stringByte);
                offset += is.read(intArray);
                this.m_dataOffset[i] = this.byteArrayToInt(intArray);
                offset += is.read(intArray);
                this.m_dataLenght[i] = this.byteArrayToInt(intArray);
            }
            this.m_resourceNameToEntryId.put(this.m_name[i], i);
            ++i;
        }
    }

    public int getEntryId(String _resourceName) {
        if (this.m_resourceNameToEntryId.containsKey(_resourceName)) {
            return this.m_resourceNameToEntryId.get(_resourceName);
        }
        return -1;
    }

    public int getOffset(int entryId) {
        return this.m_dataOffset[entryId];
    }

    public int getLenght(int entryId) {
        return this.m_dataLenght[entryId];
    }
}

