/*
 * Decompiled with CFR 0.152.
 */
package SSS.editor;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Behaviour;
import SSS.Events.CallbackSimple;
import SSS.UI.MenuActorParamEdit;
import SSS.Util.InputManager;
import SSS.editor.Editor;
import java.util.ArrayList;
import org.flixel.FlxEvent;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxObject;
import org.flixel.FlxSprite;

public class Cursor {
    int m_lastCursorColId = 0;
    int m_lastCursorLineId = 0;
    int m_lastCursorColIdOld = 0;
    int m_lastCursorLineIdOld = 0;
    FlxSprite m_cursor = null;
    Actor m_curActor = null;
    FlxGroup m_refLayer = null;
    Editor m_refEditor = null;
    ArrayList<Actor> m_listToErase = new ArrayList();
    ArrayList<Actor> m_listOverlaps = new ArrayList();
    MenuActorParamEdit m_editParamsActorMenu;
    eCursorDir m_lastDir = eCursorDir.eCursorDir_None;
    eCursorMode m_mode = eCursorMode.eCursorMode_Insert;
    float m_timeThumbDown = 0.0f;
    float m_maxTimeThumbDown = 0.25f;
    CallbackSimple m_onLevelJustLoaded = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Cursor.this._onLevelJustLoaded(_sender, _args);
        }
    };
    FlxEvent.SpriteCollisionEvent m_eraseOverlappingActor = new FlxEvent.SpriteCollisionEvent(){

        @Override
        public boolean callback(Object _sender, FlxObject Attacker, FlxObject Target) {
            return Cursor.this.eraseOverlappingActor(_sender, Attacker, Target);
        }
    };
    FlxEvent.SpriteCollisionEvent m_actorOverlapsExisting = new FlxEvent.SpriteCollisionEvent(){

        @Override
        public boolean callback(Object _sender, FlxObject Attacker, FlxObject Target) {
            return Cursor.this.actorOverlapsExisting(_sender, Attacker, Target);
        }
    };

    public Actor CurActorCursor() {
        return this.m_curActor;
    }

    public Actor ActorOverlapingFirst() {
        return this.m_listOverlaps.size() > 0 ? this.m_listOverlaps.get(0) : null;
    }

    public float X() {
        return this.m_cursor.x;
    }

    public float Y() {
        return this.m_cursor.y;
    }

    public boolean TweakingActor() {
        return this.m_editParamsActorMenu.Visible();
    }

    public Cursor(FlxGroup _layer, Editor _editor) {
        this.m_refLayer = _layer;
        this.m_refEditor = _editor;
        this.m_cursor = new FlxSprite();
        this.m_cursor.loadGraphic(FlxG.Content().LoadTexture2D("sss/editor/cursor_64"), false, false, 64, 64);
        this.m_cursor.scale((float)GameVars.TileStep() / 64.0f);
        this.m_refLayer.add(this.m_cursor);
        this.m_editParamsActorMenu = new MenuActorParamEdit(this.m_refLayer);
        this.m_refEditor.addLevelJustLoaded(this.m_onLevelJustLoaded);
    }

    protected void _onLevelJustLoaded(Object sender, Object e) {
        if (!this.m_refEditor.Level().PlayableMode()) {
            this.onLibItemChanged();
        }
    }

    public void toggleShowHide() {
        this.m_cursor.visible = !this.m_cursor.visible;
        this.m_curActor.visible = !this.m_curActor.visible;
    }

    public void update() {
        boolean bA;
        if (this.m_editParamsActorMenu.Visible()) {
            this.m_editParamsActorMenu.update();
            return;
        }
        boolean bJustMove = false;
        boolean bAuto = false;
        if ((InputManager.IsNewButtonPress(Buttons.RightTrigger) || InputManager.IsRightMouseButtonPress() && (InputManager.IsKeyDown(Keys.LeftShift) || InputManager.IsKeyDown(Keys.RightShift)) || InputManager.IsNewKeyPress(Keys.Enter) && !this.m_refEditor.Level().isEditMenuVisible()) && !InputManager.IsAnyStick()) {
            this.m_editParamsActorMenu.tweakActor(this.ActorOverlapingFirst() != null ? this.ActorOverlapingFirst() : this.CurActorCursor());
        }
        if (InputManager.IsNewButtonPress(Buttons.LeftTrigger) || InputManager.IsLeftMouseButtonPress() && (InputManager.IsKeyDown(Keys.LeftShift) || InputManager.IsKeyDown(Keys.RightShift))) {
            if (this.ActorOverlapingFirst() != null && this.CurActorCursor() != null) {
                this.m_refEditor.LibExplorer().selectActor(this.ActorOverlapingFirst());
                this._copyParams(this.ActorOverlapingFirst(), this.CurActorCursor());
            } else if (this.CurActorCursor() != null && this._foundAndSwitchToOtherLayerOverlapping()) {
                if (this.ActorOverlapingFirst() != null && this.CurActorCursor() != null) {
                    this.m_refEditor.LibExplorer().selectActor(this.ActorOverlapingFirst());
                    this._copyParams(this.ActorOverlapingFirst(), this.CurActorCursor());
                }
            } else {
                FlxG.flash.start(Color.Red());
            }
        }
        this.m_lastDir = InputManager.IsButtonDown(Buttons.LeftThumbstickDown, true) ? eCursorDir.eCursorDir_Down : (InputManager.IsButtonDown(Buttons.LeftThumbstickLeft, true) ? eCursorDir.eCursorDir_Left : (InputManager.IsButtonDown(Buttons.LeftThumbstickRight, true) ? eCursorDir.eCursorDir_Right : (InputManager.IsButtonDown(Buttons.LeftThumbstickUp, true) ? eCursorDir.eCursorDir_Up : eCursorDir.eCursorDir_None)));
        if (this.m_lastDir != eCursorDir.eCursorDir_None) {
            this.m_timeThumbDown += FlxG.elapsed;
            float f = InputManager.IsButtonDown(Buttons.RightTrigger) ? 0.25f : 1.0f;
            if (this.m_timeThumbDown > this.m_maxTimeThumbDown * f) {
                bAuto = true;
                this.m_timeThumbDown = 0.0f;
            }
        } else {
            this.m_timeThumbDown = 0.0f;
        }
        if (InputManager.IsMouseJustMoved()) {
            this.m_lastCursorColIdOld = this.m_lastCursorColId;
            this.m_lastCursorLineIdOld = this.m_lastCursorLineId;
            float cX = -FlxG.scroll.X + InputManager.MouseSpriteX();
            float cY = -FlxG.scroll.Y + InputManager.MouseSpriteY();
            this.m_lastCursorColId = (int)(cX * GameVars.OneOverTileStep()) - 1;
            this.m_lastCursorLineId = (int)(cY * GameVars.OneOverTileStep()) - 1;
            if (cX >= 0.0f) {
                ++this.m_lastCursorColId;
            }
            if (cY >= 0.0f) {
                ++this.m_lastCursorLineId;
            }
            if (this.m_lastCursorColIdOld != this.m_lastCursorColId || this.m_lastCursorLineIdOld != this.m_lastCursorLineId) {
                this.m_cursor.x = this.m_lastCursorColId * GameVars.TileStep();
                this.m_cursor.y = this.m_lastCursorLineId * GameVars.TileStep();
                this._synchronizeCurInstanceWithCursor();
                bJustMove = true;
            }
        }
        if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickLeft, true) || bAuto && this.m_lastDir == eCursorDir.eCursorDir_Left) {
            this.m_cursor.x -= (float)GameVars.TileStep();
            this._synchronizeCurInstanceWithCursor();
            bJustMove = true;
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickRight, true) || bAuto && this.m_lastDir == eCursorDir.eCursorDir_Right) {
            this.m_cursor.x += (float)GameVars.TileStep();
            this._synchronizeCurInstanceWithCursor();
            bJustMove = true;
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickUp, true) || bAuto && this.m_lastDir == eCursorDir.eCursorDir_Up) {
            this.m_cursor.y -= (float)GameVars.TileStep();
            this._synchronizeCurInstanceWithCursor();
            bJustMove = true;
        } else if (InputManager.IsNewButtonPress(Buttons.LeftThumbstickDown, true) || bAuto && this.m_lastDir == eCursorDir.eCursorDir_Down) {
            this.m_cursor.y += (float)GameVars.TileStep();
            this._synchronizeCurInstanceWithCursor();
            bJustMove = true;
        }
        if (InputManager.IsNewButtonPress(Buttons.X, true)) {
            this._toggleMode();
        }
        if (this.m_cursor.x < -FlxG.scroll.X) {
            int tmp = (int)(-FlxG.scroll.X / this.m_cursor.width);
            if (bJustMove) {
                this.m_refEditor.Level().MainPlayer().x -= (float)GameVars.TileStep();
            } else {
                this.m_cursor.x = (float)tmp * this.m_cursor.width;
            }
            this._synchronizeCurInstanceWithCursor();
        } else if (this.m_cursor.x + this.m_cursor.width > (float)FlxG.width - FlxG.scroll.X) {
            int tmp = (int)(((float)FlxG.width - FlxG.scroll.X - this.m_cursor.width) / this.m_cursor.width);
            if (bJustMove) {
                this.m_refEditor.Level().MainPlayer().x += (float)GameVars.TileStep();
            } else {
                this.m_cursor.x = (float)tmp * this.m_cursor.width;
            }
            this._synchronizeCurInstanceWithCursor();
        }
        if (this.m_cursor.y < -FlxG.scroll.Y) {
            int tmp = (int)(-FlxG.scroll.Y / this.m_cursor.width);
            if (bJustMove) {
                this.m_refEditor.Level().MainPlayer().y -= (float)GameVars.TileStep();
            } else {
                this.m_cursor.y = (float)tmp * this.m_cursor.height;
            }
            this._synchronizeCurInstanceWithCursor();
        } else if (this.m_cursor.y + this.m_cursor.height > (float)FlxG.height - FlxG.scroll.Y) {
            int tmp = (int)(((float)FlxG.height - FlxG.scroll.Y - this.m_cursor.height) / this.m_cursor.height);
            if (bJustMove) {
                this.m_refEditor.Level().MainPlayer().y += (float)GameVars.TileStep();
            } else {
                this.m_cursor.y = (float)tmp * this.m_cursor.height;
            }
            this._synchronizeCurInstanceWithCursor();
        }
        boolean bJustA = InputManager.IsNewButtonPress(Buttons.A, true) || InputManager.IsAnyMouseButtonPress();
        boolean bl = bA = InputManager.IsButtonDown(Buttons.A, true) || InputManager.IsAnyMouseButtonDown();
        if (InputManager.IsLeftMouseButtonPress()) {
            this.setMode(eCursorMode.eCursorMode_Insert);
        } else if (InputManager.IsRightMouseButtonPress() && !InputManager.IsKeyDown(Keys.LeftShift) && !InputManager.IsKeyDown(Keys.RightShift)) {
            this.setMode(eCursorMode.eCursorMode_Delete);
        }
        if (bJustA || bA && bJustMove) {
            this._checkOverlaps(true);
            if (this.m_mode == eCursorMode.eCursorMode_Insert) {
                float x = this.m_curActor.x;
                float y = this.m_curActor.y;
                this.m_curActor.visible = true;
                Actor newActor = this.m_refEditor.instanciateActorUnderCursor(this.m_curActor, x, y);
                if (newActor.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) {
                    this.m_refEditor.Level().recomputeGround();
                }
                this.m_refEditor.LayerExplorer().removeActorInCurrentLayer(this.m_curActor);
                this.m_refEditor.LayerExplorer().addActorInCurrentLayer(this.m_curActor);
                this._actorOverlapsFeedBack(true);
            }
        }
    }

    protected boolean _foundAndSwitchToOtherLayerOverlapping() {
        return this.m_refEditor.LayerExplorer().findNextOverlappingLayer(this.CurActorCursor());
    }

    protected void _copyParams(Actor _source, Actor _dest) {
        for (Behaviour bvrSource : _source.Behaviours()) {
            for (Behaviour bvrDest : _dest.Behaviours()) {
                bvrDest.copyParametersValue(bvrSource);
            }
        }
    }

    protected void _toggleMode() {
        if (this.m_mode == eCursorMode.eCursorMode_Insert) {
            this.m_curActor.visible = false;
            this.m_mode = eCursorMode.eCursorMode_Delete;
        } else if (this.m_mode == eCursorMode.eCursorMode_Delete) {
            this.m_curActor.visible = true;
            this.m_mode = eCursorMode.eCursorMode_Insert;
        }
    }

    public void setMode(eCursorMode _mode) {
        if (this.m_mode != _mode) {
            if (this.m_curActor != null) {
                this.m_curActor.visible = _mode == eCursorMode.eCursorMode_Insert;
            }
            this.m_mode = _mode;
        }
    }

    protected void _synchronizeCurInstanceWithCursor() {
        if (this.m_curActor != null) {
            this._checkUnHilight();
            this.m_curActor.x = this.m_cursor.x;
            this.m_curActor.y = this.m_cursor.y + this.m_cursor.height - this.m_curActor.height;
            this._checkOverlaps(false);
        }
        this.m_refEditor.updateInfoText();
    }

    protected void _checkUnHilight() {
        for (Actor act : this.m_listOverlaps) {
            act.color(Color.White());
            act.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ActorInitDefaultColor, null);
        }
        this.m_listOverlaps.clear();
    }

    protected void _checkOverlaps(boolean _destroyOverlapping) {
        this._actorOverlapsFeedBack(false);
        if (_destroyOverlapping) {
            this.m_refEditor.LayerExplorer().overlapActorWithCurrentLayer(this.m_curActor, this.m_eraseOverlappingActor);
            this._flushEraseList();
        } else {
            this.m_refEditor.LayerExplorer().overlapActorWithCurrentLayer(this.m_curActor, this.m_actorOverlapsExisting);
        }
    }

    public boolean eraseOverlappingActor(Object _object, FlxObject Attacker, FlxObject Target) {
        Actor act = (Actor)Attacker;
        if (act.Material() != Actor.eActorMaterial.eActorMaterial_Player) {
            this.m_listToErase.add(act);
        }
        return true;
    }

    protected void _flushEraseList() {
        boolean bRecomputeOrdering = false;
        for (Actor actor : this.m_listToErase) {
            if (actor.Material() == Actor.eActorMaterial.eActorMaterial_UnbreakableAutoAnim) {
                bRecomputeOrdering = true;
            }
            this.m_refEditor.LayerExplorer().removeActorInCurrentLayer(actor);
            actor.destroyEdit();
        }
        this.m_listToErase.clear();
        if (bRecomputeOrdering) {
            this.m_refEditor.Level().recomputeGround();
        }
    }

    public void showHide(boolean _visible) {
        if (_visible) {
            this.onLibItemChanged();
        } else if (!_visible && this.m_curActor != null) {
            this.m_refEditor.LayerExplorer().removeActorInCurrentLayer(this.m_curActor);
            this.m_curActor.kill();
            this.m_curActor = null;
        }
    }

    public void onLibItemChanged() {
        if (this.m_curActor != null) {
            this.m_refEditor.LayerExplorer().removeActorInCurrentLayer(this.m_curActor);
        }
        this.m_curActor = this.m_refEditor.LibExplorer().instanciateLibActor(this.m_refEditor.Level());
        this.m_curActor.scrollFactor = Vector2.One();
        this.m_refEditor.LayerExplorer().addActorInCurrentLayer(this.m_curActor);
        if (this.m_mode == eCursorMode.eCursorMode_Delete) {
            this._toggleMode();
        }
        this._synchronizeCurInstanceWithCursor();
    }

    protected void _actorOverlapsFeedBack(boolean _overlap) {
        if (_overlap) {
            this.m_curActor.color(Color.Gray());
        } else {
            this.m_curActor.color(Color.White());
        }
    }

    public boolean actorOverlapsExisting(Object _object, FlxObject Attacker, FlxObject Target) {
        Actor act = (Actor)Attacker;
        this.m_listOverlaps.add(act);
        act.color(Color.Red());
        return true;
    }

    public void reinit() {
        this.m_listToErase.clear();
    }

    public void onLayerChanged() {
        if (this.m_curActor != null) {
            this._checkUnHilight();
            this.m_refEditor.LayerExplorer().removeActorInOldLayer(this.m_curActor);
            this.m_refEditor.LayerExplorer().addActorInCurrentLayer(this.m_curActor);
            this._checkOverlaps(false);
        }
    }

    public static enum eCursorDir {
        eCursorDir_None,
        eCursorDir_Left,
        eCursorDir_Right,
        eCursorDir_Up,
        eCursorDir_Down;

    }

    public static enum eCursorMode {
        eCursorMode_Insert,
        eCursorMode_Delete;

    }
}

