/*
 * Decompiled with CFR 0.152.
 */
package SSS.editor;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Util.InputManager;
import SSS.editor.Cursor;
import SSS.editor.LayerExplorer;
import SSS.editor.LibExplorer;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;

public class Editor {
    protected ArrayList<CallbackSimple> LevelJustLoaded = null;
    protected ArrayList<CallbackSimple> LevelBeingDestroy = null;
    public static int m_FrameRate = 15;
    static boolean m_bEditMode = false;
    Actor m_player = null;
    FlxGroup m_layerCursorScene;
    FlxGroup m_layerText;
    FlxText m_textActorDesc = null;
    FlxText m_textHelp = null;
    LibExplorer m_libExplorer;
    LayerExplorer m_layerExplorer;
    Cursor m_editorCursor = null;
    Level m_level = null;
    boolean m_bYcount = false;
    float m_elapsedTimeYdown = 0.0f;
    CallbackSimple m_layerExplorerLayerChangedEvent = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Editor.this.layerExplorerLayerChangedEvent(_sender, _args);
        }
    };
    CallbackSimple m_libItemChangedEvent = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Editor.this.libItemChangedEvent(_sender, _args);
        }
    };
    CallbackSimple m_levelJustLoaded = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Editor.this._levelJustLoaded(_sender, _args);
        }
    };
    CallbackSimple m_levelBeingDestroy = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            Editor.this._levelBeingDestroy(_sender, _args);
        }
    };

    public void addLevelJustLoaded(CallbackSimple callback) {
        if (this.LevelJustLoaded == null) {
            this.LevelJustLoaded = new ArrayList();
        }
        this.LevelJustLoaded.add(callback);
    }

    public void addLevelBeingDestroy(CallbackSimple callback) {
        if (this.LevelBeingDestroy == null) {
            this.LevelBeingDestroy = new ArrayList();
        }
        this.LevelBeingDestroy.add(callback);
    }

    public static int FrameRate() {
        return m_FrameRate;
    }

    public static boolean EditMode() {
        return m_bEditMode;
    }

    public Actor Player() {
        return this.m_player;
    }

    public LibExplorer LibExplorer() {
        return this.m_libExplorer;
    }

    public LayerExplorer LayerExplorer() {
        return this.m_layerExplorer;
    }

    public Level Level() {
        return this.m_level;
    }

    public Editor(Level _level) {
        this.m_level = _level;
        this._buildLayers();
        this.m_textActorDesc = new FlxText(0.0f, (float)FlxG.height - 20.0f, FlxG.width);
        this.m_textActorDesc.alignment = FlxText.FlxJustification.Left;
        this.m_textActorDesc.text("");
        this.m_textActorDesc.scrollFactor = Vector2.Zero();
        this.m_layerText.add(this.m_textActorDesc);
        this.m_textHelp = new FlxText(0.0f, (float)FlxG.height - 40.0f, FlxG.width);
        this.m_textHelp.alignment = FlxText.FlxJustification.Left;
        this.m_textHelp.text("Press Select, F1 or ESC for HELP");
        this.m_textHelp.scrollFactor = Vector2.Zero();
        this.m_layerText.add(this.m_textHelp);
        this.m_layerExplorer = new LayerExplorer(this);
        this.m_layerExplorer.LayerChanged = this.m_layerExplorerLayerChangedEvent;
        this.m_libExplorer = new LibExplorer();
        this.m_libExplorer.ItemChanged = this.m_libItemChangedEvent;
        this.m_editorCursor = new Cursor(this.m_layerCursorScene, this);
        this._showHideLayers(false);
        this.m_level.addLevelJustLoaded(this.m_levelJustLoaded);
        this.m_level.addLevelBeingDestroy(this.m_levelBeingDestroy);
    }

    public void updateInfoText() {
        Actor cursor = this.m_editorCursor.CurActorCursor();
        Actor underCursor = this.m_editorCursor.ActorOverlapingFirst();
        if (underCursor != null) {
            this.m_textActorDesc.text("[map] " + underCursor.getEditorDescription());
        } else if (cursor != null) {
            this.m_textActorDesc.text("[cursor] " + cursor.getEditorDescription());
        } else {
            this.m_textActorDesc.text("[none]");
        }
    }

    public boolean hasLevelsSequence(String _sequenceName) {
        return this.m_libExplorer.hasLevelsSequence(_sequenceName);
    }

    public ArrayList<String> getLevelsSequences() {
        return this.m_libExplorer.getLevelsSequences();
    }

    public String getFirstLevelInSequence(String _sequenceName) {
        return this.m_libExplorer.getFirstLevelInSequence(_sequenceName);
    }

    public String getLevelNextToLevel(String _levelName, String _sequenceName, boolean _bPreviousLevel) {
        return this.m_libExplorer.getLevelNextToLevel(_levelName, _sequenceName, _bPreviousLevel);
    }

    protected void _levelJustLoaded(Object sender, Object e) {
        this._notifyLevelJustLoaded();
    }

    protected void _levelBeingDestroy(Object sender, Object e) {
        this._notifyLevelBeingDestroyed();
    }

    public void initDefaultLevel() {
        this._defaultPlayerLoad();
    }

    protected void _defaultPlayerLoad() {
        this._notifyLevelJustLoaded();
    }

    protected void _notifyLevelJustLoaded() {
        if (this.LevelJustLoaded != null) {
            int i = 0;
            while (i < this.LevelJustLoaded.size()) {
                this.LevelJustLoaded.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    protected void _notifyLevelBeingDestroyed() {
        if (this.LevelBeingDestroy != null) {
            int i = 0;
            while (i < this.LevelBeingDestroy.size()) {
                this.LevelBeingDestroy.get(i).onCallback(this, null);
                ++i;
            }
        }
    }

    protected void _buildLayers() {
        this.m_layerCursorScene = new FlxGroup();
        this.m_layerText = new FlxGroup();
        this.m_layerText.scrollFactor = Vector2.Zero();
    }

    public Actor instanciateActor(String _friendly, Level _level) {
        return this.m_libExplorer.instanciateActor(_friendly, _level);
    }

    public FlxSprite instanciateSprite(String _friendly) {
        return this.m_libExplorer.instanciateSprite(_friendly);
    }

    public void registerLayer(FlxState _ownerState) {
        _ownerState.add(this.m_layerCursorScene);
        _ownerState.add(this.m_libExplorer.LayerBackground());
        _ownerState.add(this.m_libExplorer.LayerAtlas());
        _ownerState.add(this.m_libExplorer.LayerCursor());
        _ownerState.add(this.m_layerExplorer.Layer());
        _ownerState.add(this.m_layerText);
    }

    public void showCursorActor() {
        this.m_editorCursor.setMode(Cursor.eCursorMode.eCursorMode_Insert);
    }

    public void hideCursorActor() {
        this.m_editorCursor.setMode(Cursor.eCursorMode.eCursorMode_Delete);
    }

    protected void _showHideLayers(boolean _visible) {
        m_bEditMode = _visible;
        this.m_layerCursorScene.visible = _visible;
        this.m_layerText.visible = _visible;
        this.m_layerExplorer.showHideLayer(_visible);
        this.m_libExplorer.showHideLayer(_visible);
        this.m_editorCursor.showHide(_visible);
    }

    protected void layerExplorerLayerChangedEvent(Object sender, Object e) {
        this.m_editorCursor.onLayerChanged();
        this.m_libExplorer.onNewLayerSelected(this.m_layerExplorer.CurLayerSprite().TextString());
    }

    protected void libItemChangedEvent(Object sender, Object e) {
        this.m_editorCursor.onLibItemChanged();
    }

    public void enterEditMode() {
        this._showHideLayers(true);
    }

    public void leaveEditMode() {
        this._showHideLayers(false);
    }

    public void update() {
        if (!this.m_editorCursor.TweakingActor()) {
            this.m_libExplorer.update();
            this.m_layerExplorer.update();
        }
        this.m_editorCursor.update();
        if (!this.m_level.PlayableMode()) {
            if (InputManager.IsNewButtonPress(Buttons.Y, true) || InputManager.IsNewKeyPress(Keys.F6)) {
                this.m_libExplorer.toggleShowHide();
                this.m_layerExplorer.toggleShowHide();
                this.m_editorCursor.toggleShowHide();
                this.m_textActorDesc.visible = !this.m_textActorDesc.visible;
                this.m_bYcount = true;
                this.m_elapsedTimeYdown = 0.0f;
            }
            if ((InputManager.IsButtonDown(Buttons.Y, true) || InputManager.IsKeyDown(Keys.F6)) && this.m_bYcount) {
                this.m_elapsedTimeYdown += FlxG.elapsed;
                if (this.m_elapsedTimeYdown > 1.0f) {
                    this.m_bYcount = false;
                    this.m_elapsedTimeYdown = 0.0f;
                    this.m_level.MainPlayer().visible = !this.m_level.MainPlayer().visible;
                }
            }
        }
    }

    public Actor getLibraryActor(String _friendlyName) {
        return this.m_libExplorer.getLibraryActor(_friendlyName);
    }

    public Actor getActorCursor() {
        return this.m_editorCursor != null ? this.m_editorCursor.CurActorCursor() : null;
    }

    public Actor instanciateActorUnderCursor(Actor _actor, float _x, float _y) {
        if (_actor != null) {
            _actor.reinitValueBBoxTweakRelated();
            Actor newActor = new Actor(_actor, this.m_level);
            newActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_OnEditSpawn, _actor);
            newActor.createComponents(this.m_level, false);
            newActor.scrollFactor.X = 1.0f;
            newActor.scrollFactor.Y = 1.0f;
            newActor.x = _x;
            newActor.y = _y;
            newActor.color(Color.White());
            newActor.handleGenericMessage(Actor.eGenericMessage.eGenericMessage_ActorInitDefaultColor, _actor);
            this.m_layerExplorer.addActorInCurrentLayer(newActor);
            _actor.restaureValueBBoxTweakRelated();
            return newActor;
        }
        return null;
    }

    protected void _unloadLevel() {
        this._notifyLevelBeingDestroyed();
        this.m_level.unload();
    }

    public void onLevelLoaded() {
        this.m_editorCursor.reinit();
    }
}

