/*
 * Decompiled with CFR 0.152.
 */
package SSS.editor;

import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.SssGroup;
import SSS.Util.InputManager;
import SSS.Util.Utility;
import SSS.editor.Editor;
import SSS.editor.LayerSprite;
import java.util.ArrayList;
import org.flixel.FlxEvent;
import org.flixel.FlxG;
import org.flixel.FlxGroup;

public class LayerExplorer {
    float m_marginRight = 5.0f;
    float m_marginTop = (float)GameVars.TileStep() * 2.0f;
    float m_marginInterLayer = 2.0f;
    float m_cur_y;
    eLayerDisplay m_displayMode = eLayerDisplay.eLayerDisplay_All;
    Editor m_editor;
    FlxGroup m_layerHud;
    ArrayList<LayerSprite> m_layerSprites = null;
    LayerSprite m_curLayerSprite = null;
    LayerSprite m_oldLayerSprite = null;
    int m_curLayerSpriteId = 0;
    public CallbackSimple LayerChanged = null;
    CallbackSimple m_onLevelJustLoaded = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LayerExplorer.this._onLevelJustLoaded(_sender, _args);
        }
    };
    CallbackSimple m_onLevelJustDestroyed = new CallbackSimple(){

        @Override
        public void onCallback(Object _sender, Object _args) {
            LayerExplorer.this._onLevelJustDestroyed(_sender, _args);
        }
    };

    public FlxGroup Layer() {
        return this.m_layerHud;
    }

    public LayerSprite CurLayerSprite() {
        return this.m_curLayerSprite;
    }

    public LayerExplorer(Editor _editor) {
        this.m_layerSprites = new ArrayList(20);
        this.m_layerHud = new FlxGroup();
        this.m_editor = _editor;
        this.m_editor.addLevelBeingDestroy(this.m_onLevelJustDestroyed);
        this.m_editor.addLevelJustLoaded(this.m_onLevelJustLoaded);
        this._rebuildLayer();
    }

    protected void _onLevelJustLoaded(Object sender, Object e) {
        this._rebuildLayer();
        this.m_curLayerSprite = null;
        this.m_oldLayerSprite = null;
        this._layerChange(0);
    }

    protected void _onLevelJustDestroyed(Object sender, Object e) {
        this.m_curLayerSprite = null;
        this.m_oldLayerSprite = null;
    }

    public void toggleShowHide() {
        this.m_layerHud.visible = !this.m_layerHud.visible;
    }

    public void removeActorInCurrentLayer(Actor _actor) {
        if (this.m_curLayerSprite.containsActor(_actor)) {
            this.m_editor.Level().removeActorFromLayer(this.m_curLayerSprite.Layer(), _actor, true);
        }
    }

    public void removeActorInOldLayer(Actor _actor) {
        if (this.m_oldLayerSprite != null && this.m_oldLayerSprite.containsActor(_actor)) {
            this.m_editor.Level().removeActorFromLayer(this.m_oldLayerSprite.Layer(), _actor, true);
        }
    }

    public void addActorInCurrentLayer(Actor _actor) {
        this.m_editor.Level().addActorToLayer(this.m_curLayerSprite.Layer(), _actor);
    }

    public void overlapActorWithCurrentLayer(Actor _actor, FlxEvent.SpriteCollisionEvent Collide) {
        Utility.SssU_overlapWithScale_Garbage(this.m_curLayerSprite.Layer(), _actor, Collide, 0.99f);
    }

    public void updateContent() {
        this._rebuildLayer();
    }

    public void update() {
        this._handleInput();
    }

    protected void _notifyOnLayerChanged() {
        if (this.LayerChanged != null) {
            this.LayerChanged.onCallback(this, null);
        }
    }

    protected void _handleInput() {
        if (InputManager.IsNewButtonPress(Buttons.DPadDown) || InputManager.IsJustMouseWheelDown() && (InputManager.IsKeyDown(Keys.LeftShift) || InputManager.IsKeyDown(Keys.RightShift))) {
            this._layerChange(1);
        } else if (InputManager.IsNewButtonPress(Buttons.DPadUp) || InputManager.IsJustMouseWheelUp() && (InputManager.IsKeyDown(Keys.LeftShift) || InputManager.IsKeyDown(Keys.RightShift))) {
            this._layerChange(-1);
        }
        if (InputManager.IsNewButtonPress(Buttons.B, true) || InputManager.IsNewKeyPress(Keys.F5)) {
            this._toggleDisplay();
        }
    }

    protected void _toggleDisplay() {
        switch (this.m_displayMode) {
            case eLayerDisplay_All: {
                this._gotoActiveMode();
                break;
            }
            case eLayerDisplay_Active: {
                this._gotoAllVisibleMode();
            }
        }
    }

    protected void _updateDisplayMode() {
        switch (this.m_displayMode) {
            case eLayerDisplay_All: {
                this._gotoAllVisibleMode();
                break;
            }
            case eLayerDisplay_Active: {
                this._gotoActiveMode();
            }
        }
    }

    protected void _gotoActiveMode() {
        this.m_displayMode = eLayerDisplay.eLayerDisplay_Active;
        this._layersVisibility(true, false);
    }

    protected void _gotoAllVisibleMode() {
        this.m_displayMode = eLayerDisplay.eLayerDisplay_All;
        this._layersVisibility(true, true);
    }

    protected void _layersVisibility(boolean _bCurrentLayerVisible, boolean _bAllOtherLayersVisible) {
        for (LayerSprite layer : this.m_layerSprites) {
            if (_bAllOtherLayersVisible) {
                layer.unselectAnim();
            } else {
                layer.unvisibleAnim();
            }
            this._showHideLayerAndAllContent(layer.Layer(), _bAllOtherLayersVisible);
        }
        this.m_curLayerSprite.selectedAnim();
        this._showHideLayerAndAllContent(this.m_curLayerSprite.Layer(), _bCurrentLayerVisible);
    }

    protected void _showHideLayerAndAllContent(FlxGroup _layer, boolean _bVisible) {
        if (_layer.visible != _bVisible) {
            _layer.visible = _bVisible;
            Actor act = null;
            int i = 0;
            while (i < _layer.members.size()) {
                act = (Actor)_layer.members.get(i);
                if (act != null) {
                    act.visible = _bVisible;
                }
                ++i;
            }
        }
    }

    protected void _layerChange(int _sense) {
        this.m_curLayerSpriteId += _sense;
        if (this.m_curLayerSpriteId < 0) {
            this.m_curLayerSpriteId = this.m_layerSprites.size() - 1;
        } else if (this.m_curLayerSpriteId >= this.m_layerSprites.size()) {
            this.m_curLayerSpriteId = 0;
        }
        this.m_oldLayerSprite = this.m_curLayerSprite;
        this.m_curLayerSprite = this.m_layerSprites.get(this.m_curLayerSpriteId);
        if (this.m_oldLayerSprite != null) {
            this.m_oldLayerSprite.unselectAnim();
        }
        this.m_curLayerSprite.selectedAnim();
        this._updateDisplayMode();
        this._notifyOnLayerChanged();
    }

    public boolean findNextOverlappingLayer(Actor _actor) {
        int nextLayerId = this.m_curLayerSpriteId;
        int layerId = this.m_layerSprites.size() - 1;
        while (layerId >= 0) {
            if (layerId != this.m_curLayerSpriteId && Utility.SssU_overlapSomethingWithScale(this.m_layerSprites.get(layerId).Layer(), _actor, 0.99f)) {
                nextLayerId = layerId;
                break;
            }
            --layerId;
        }
        if (nextLayerId != this.m_curLayerSpriteId) {
            this._layerChange(nextLayerId - this.m_curLayerSpriteId);
            return true;
        }
        return false;
    }

    protected void _rebuildLayer() {
        this.m_layerSprites.clear();
        this.m_layerHud.destroy();
        this.m_cur_y = this.m_marginTop;
        this.m_curLayerSpriteId = 0;
        for (SssGroup lay : this.m_editor.Level().LayerBackGround()) {
            this._addLayerSprite(lay, this.m_editor.Level().LayerBackGround(), LayerSprite.eLayerType.eLayerType_Background);
            ++this.m_curLayerSpriteId;
        }
        this._addLayerSprite(this.m_editor.Level().LayerPhysics(), null, LayerSprite.eLayerType.eLayerType_Physics);
        this._addLayerSprite(this.m_editor.Level().LayerPlayer(), null, LayerSprite.eLayerType.eLayerType_Player);
        for (SssGroup lay : this.m_editor.Level().LayerForeGround()) {
            this._addLayerSprite(lay, this.m_editor.Level().LayerForeGround(), LayerSprite.eLayerType.eLayerType_Foreground);
        }
        this.m_curLayerSprite = this.m_layerSprites.get(this.m_curLayerSpriteId);
        this.m_curLayerSprite.selectedAnim();
    }

    protected LayerSprite _addLayerSprite(SssGroup _layer, ArrayList<SssGroup> _layerList, LayerSprite.eLayerType _layerType) {
        LayerSprite ls = new LayerSprite(_layerType);
        ls.selfInit();
        ls.Layer(_layer);
        ls.LayerList(this.m_editor.Level().LayerBackGround());
        this.m_layerHud.add(ls);
        this.m_layerSprites.add(ls);
        ls.x = (float)FlxG.width - ls.width - this.m_marginRight;
        ls.y = this.m_cur_y;
        this.m_cur_y += ls.height + this.m_marginInterLayer;
        return ls;
    }

    public void showHideLayer(boolean _visible) {
        this.m_layerHud.visible = _visible;
    }

    public static enum eLayerDisplay {
        eLayerDisplay_All,
        eLayerDisplay_Active;

    }
}

