/*
 * Decompiled with CFR 0.152.
 */
package SSS.editor;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.SssGroup;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.FlxText;

public class LayerSprite
extends FlxSprite {
    String m_textString = "";
    String m_animSelected = "selected";
    String m_animNotSelected = "nselected";
    protected SssGroup m_refLayer = null;
    protected FlxText m_text = null;
    eLayerType m_type;
    ArrayList<SssGroup> m_refList = null;

    public String TextString() {
        return this.m_textString;
    }

    public SssGroup Layer() {
        return this.m_refLayer;
    }

    public void Layer(SssGroup value) {
        this.m_refLayer = value;
    }

    public ArrayList<SssGroup> LayerList() {
        return this.m_refList;
    }

    public void LayerList(ArrayList<SssGroup> value) {
        this.m_refList = value;
    }

    public LayerSprite(eLayerType _type) {
        this.m_type = _type;
    }

    public void selfInit() {
        this.loadGraphic(FlxG.Content().LoadTexture2D("sss/editor/layer"), false, false, 128, 32);
        this.scrollFactor = Vector2.Zero();
        this.addAnimation(this.m_animNotSelected, new int[1], 0, false);
        this.addAnimation(this.m_animSelected, new int[]{1}, 0, false);
        this._buildName();
        this.unselectAnim();
    }

    protected void _buildName() {
        this.m_textString = "none";
        switch (this.m_type) {
            case eLayerType_Background: {
                this.m_textString = "background";
                break;
            }
            case eLayerType_Foreground: {
                this.m_textString = "foreground";
                break;
            }
            case eLayerType_Physics: {
                this.m_textString = "physics";
                break;
            }
            case eLayerType_Player: {
                this.m_textString = "player";
            }
        }
        this.m_text = new FlxText(0.0f, 0.0f, 50.0f, this.m_textString);
        this.m_text.color(Color.White());
        this.m_text.alignment = FlxText.FlxJustification.Center;
        this.m_text.scrollFactor = Vector2.Zero();
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        super.render(spriteBatch);
        this.m_text.x = this.x + this.width * 0.5f;
        this.m_text.y = this.y + this.height * 0.5f;
        this.m_text.render(spriteBatch);
    }

    public void unselectAnim() {
        this.play(this.m_animNotSelected);
        this.color(Color.LightPink());
    }

    public void selectedAnim() {
        this.play(this.m_animSelected);
        this.color(Color.Blue());
    }

    public void unvisibleAnim() {
        this.play(this.m_animNotSelected);
        this.color(Color.DarkGray());
    }

    public boolean containsActor(Actor _actor) {
        if (this.m_refLayer != null) {
            return this.m_refLayer.members.contains(_actor);
        }
        return false;
    }

    public static enum eLayerType {
        eLayerType_Player,
        eLayerType_Physics,
        eLayerType_Background,
        eLayerType_Foreground;

    }
}

