/*
 * Decompiled with CFR 0.152.
 */
package SSS.editor;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.Vector2;
import SSS.Actor;
import SSS.BTM.GameVars;
import SSS.Events.CallbackSimple;
import SSS.Level;
import SSS.Managers.BTM.ResourcesLibrary;
import SSS.Util.InputManager;
import SSS.editor.Editor;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxSprite;

public class LibExplorer {
    ResourcesLibrary m_resourceLibrary = null;
    int m_indexCursorPos = 0;
    int m_indexCursorTab = 0;
    FlxSprite m_cursorLib;
    FlxSprite m_shellBackground;
    boolean m_bVisible = false;
    FlxGroup m_layerBackground = new FlxGroup();
    FlxGroup m_layerCursorAtlas = new FlxGroup();
    FlxGroup m_layerAtlas = new FlxGroup();
    public CallbackSimple ItemChanged = null;

    public boolean hasLelevelSequences() {
        return this.m_resourceLibrary.hasLelevelSequences();
    }

    public ArrayList<String> getLevelsSequences() {
        return this.m_resourceLibrary.getLevelsSequences();
    }

    public String getFirstLevelInSequence(String _sequenceName) {
        return this.m_resourceLibrary.getFirstLevelInSequence(_sequenceName);
    }

    public String getLevelNextToLevel(String _levelName, String _sequenceName, boolean _bPreviousLevel) {
        return this.m_resourceLibrary.getLevelNextToLevel(_levelName, _sequenceName, _bPreviousLevel);
    }

    public boolean hasLevelsSequence(String _sequenceName) {
        return this.m_resourceLibrary.hasLevelsSequence(_sequenceName);
    }

    public FlxGroup LayerBackground() {
        return this.m_layerBackground;
    }

    public FlxGroup LayerCursor() {
        return this.m_layerCursorAtlas;
    }

    public FlxGroup LayerAtlas() {
        return this.m_layerAtlas;
    }

    public LibExplorer() {
        this.m_shellBackground = new FlxSprite(0.0f, 0.0f);
        this.m_shellBackground.createGraphic(FlxG.width, 32, Color.Beige());
        this.m_shellBackground.scrollFactor = Vector2.Zero();
        this.m_cursorLib = new FlxSprite();
        this.m_cursorLib.loadGraphic(FlxG.Content().LoadTexture2D("sss/editor/lib_cursor"), false, false, 16, 16);
        this.m_cursorLib.scrollFactor = Vector2.Zero();
        this.m_layerCursorAtlas.add(this.m_cursorLib);
        this.m_resourceLibrary = ResourcesLibrary.Instance();
        this._populateLayerAtlas();
        this._positionatedLibCursor();
    }

    protected void _onLibItemChanged() {
        if (this.ItemChanged != null) {
            this.ItemChanged.onCallback(this, null);
        }
    }

    protected void _positionatedLibCursor() {
        float x;
        Actor actor = this.m_resourceLibrary.GetTabActor(this.m_indexCursorTab, this.m_indexCursorPos);
        this.m_cursorLib.x = x = actor.x + actor.width * 0.5f - this.m_cursorLib.width * 0.5f;
        this.m_cursorLib.y = 64.0f;
    }

    protected void _populateLayerAtlas() {
        int posxStep = GameVars.TileStep() + GameVars.TileStep() / 2;
        boolean posx = false;
        this.m_layerAtlas.destroy();
        this.m_resourceLibrary.PopulateLayer(this.m_layerAtlas, this.m_indexCursorTab, (float)posx, posxStep, 0.0f, 0.0f);
    }

    public boolean onNewLayerSelected(String _layerName) {
        boolean bTabChanged = false;
        int newTabIndex = this._findTabIndexAssociateWithLayer(_layerName);
        if (this.m_indexCursorTab != newTabIndex && newTabIndex > -1) {
            this.m_indexCursorPos = 0;
            this.m_indexCursorTab = newTabIndex;
            this._populateLayerAtlas();
            bTabChanged = true;
            this._positionatedLibCursor();
            this._onLibItemChanged();
        }
        return bTabChanged;
    }

    protected int _findTabIndexAssociateWithLayer(String _layerName) {
        int res = -1;
        int i = 0;
        while (i < this.m_resourceLibrary.Tabs().size()) {
            if (this.m_resourceLibrary.Tabs().get(i).LinkedLayer().equals(_layerName)) {
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    public void showHideLayer(boolean _visible) {
        this.m_bVisible = _visible;
        this.m_layerBackground.visible = _visible;
        this.m_layerAtlas.visible = _visible;
        this.m_layerCursorAtlas.visible = _visible;
    }

    public void update() {
        if (Editor.EditMode()) {
            this._handleInput();
        }
    }

    protected void _toggleShowHide() {
        this.showHideLayer(!this.m_bVisible);
    }

    public void toggleShowHide() {
        this._toggleShowHide();
    }

    protected void _handleInput() {
        if (this.m_bVisible) {
            if (InputManager.IsNewButtonPress(Buttons.DPadRight) || InputManager.IsNewButtonPress(Buttons.RightShoulder) || InputManager.IsJustMouseWheelUp() && !InputManager.IsKeyDown(Keys.RightShift) && !InputManager.IsKeyDown(Keys.LeftShift)) {
                if (this.m_indexCursorPos < this.m_resourceLibrary.GetTabActorNum(this.m_indexCursorTab) - 1) {
                    ++this.m_indexCursorPos;
                    this._positionatedLibCursor();
                    this._onLibItemChanged();
                }
            } else if ((InputManager.IsNewButtonPress(Buttons.DPadLeft) || InputManager.IsNewButtonPress(Buttons.LeftShoulder) || InputManager.IsJustMouseWheelDown() && !InputManager.IsKeyDown(Keys.RightShift) && !InputManager.IsKeyDown(Keys.LeftShift)) && this.m_indexCursorPos > 0) {
                --this.m_indexCursorPos;
                this._positionatedLibCursor();
                this._onLibItemChanged();
            }
        }
    }

    public boolean selectActor(Actor _sameMaterialAsThisOne) {
        int index = -1;
        int numActor = this.m_resourceLibrary.GetTabActorNum(this.m_indexCursorTab);
        int i = 0;
        while (i < numActor) {
            Actor actor = this.m_resourceLibrary.GetTabActor(this.m_indexCursorTab, i);
            if (actor.Material() == _sameMaterialAsThisOne.Material() && actor.FriendlyName().equals(_sameMaterialAsThisOne.FriendlyName())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            this.m_indexCursorPos = index;
            this._positionatedLibCursor();
            this._onLibItemChanged();
        }
        return false;
    }

    public FlxSprite instanciateSprite(String _friendly) {
        return this.m_resourceLibrary.InstanciateSprite(_friendly);
    }

    public Actor instanciateActor(String _friendly, Level _level) {
        return this.m_resourceLibrary.InstanciateActor(_friendly, _level);
    }

    public Actor getLibraryActor(String _friendlyName) {
        return this.m_resourceLibrary.GetLibraryActor(_friendlyName);
    }

    public Actor instanciateLibActor(Level _level) {
        return this.m_resourceLibrary.InstanciateLibActor(_level, this.m_indexCursorTab, this.m_indexCursorPos);
    }
}

