/*
 * Decompiled with CFR 0.152.
 */
import Microsoft.Xna.Framework.Audio.AudioEngine;
import Microsoft.Xna.Framework.Audio.AudioStopOptions;
import Microsoft.Xna.Framework.Audio.Cue;
import Microsoft.Xna.Framework.Audio.SoundBank;
import Microsoft.Xna.Framework.Audio.WaveBank;
import java.io.IOException;
import java.math.BigDecimal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.ResourceLoader;

public class SoundTest {
    private Audio oggEffect;
    private Audio[] oggEffects;
    int idSelected = 0;
    DocumentBuilderFactory m_documentBuilderFactory = null;
    DocumentBuilder m_documentBuilder = null;
    AudioEngine engine;
    SoundBank soundBank;
    WaveBank waveBank;
    Cue cue = null;
    BigDecimal volume = new BigDecimal(1.0);
    boolean useJaxt = false;

    public void start() {
        this.initGL(800, 600);
        if (!this.useJaxt) {
            this.init();
        } else {
            this._initJACT();
        }
        while (true) {
            this.update();
            GL11.glClear((int)16384);
            this.render();
            Display.update();
            Display.sync((int)100);
            if (!Display.isCloseRequested()) continue;
            Display.destroy();
            AL.destroy();
            System.exit(0);
        }
    }

    private void initGL(int width, int height) {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
            Display.create();
            Display.setVSyncEnabled((boolean)true);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5888);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
    }

    protected void _initJACT() {
        String audioPath = "Content/sss/audio/Win/";
        this.engine = new AudioEngine(String.valueOf(audioPath) + "GameAudioProject.jgs");
        this.soundBank = new SoundBank(this.engine, String.valueOf(audioPath) + "Sound Bank.jsb");
        this.waveBank = new WaveBank(this.engine, String.valueOf(audioPath) + "Wave Bank.jwb");
        System.out.println(">> Sound bank loaded");
    }

    public void init() {
        String audioPath = "Content/sss/audio/Win/Wave Bank.jwb/";
        String soundName = "appel entrant";
        try {
            this.oggEffect = AudioLoader.getAudio("OGG", ResourceLoader.getResourceAsStream(String.valueOf(audioPath) + soundName + ".ogg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 200) {
                if (!this.useJaxt) {
                    --this.idSelected;
                    if (this.oggEffects != null && this.idSelected < 0) {
                        this.idSelected = this.oggEffects.length - 1;
                    }
                    this._changeVolume(0.01);
                } else {
                    System.out.println("pitch: " + (AudioEngine.GlobalPitchDebug += 0.1f));
                }
            } else if (Keyboard.getEventKey() == 208) {
                if (!this.useJaxt) {
                    ++this.idSelected;
                    if (this.oggEffects != null && this.idSelected >= this.oggEffects.length) {
                        this.idSelected = 0;
                    }
                    this._changeVolume(-0.01);
                } else {
                    System.out.println("pitch: " + (AudioEngine.GlobalPitchDebug -= 0.1f));
                }
            }
            if (Keyboard.getEventKey() == 57 && this.useJaxt && this.cue != null) {
                this.cue.Stop(AudioStopOptions.Immediate);
            }
            if (Keyboard.getEventKey() == 203) {
                this._changeVolume(-0.05);
            } else if (Keyboard.getEventKey() == 205) {
                this._changeVolume(0.05);
            }
            if (Keyboard.getEventKey() == 16) {
                if (!this.useJaxt) {
                    if (!this.oggEffect.isPlaying()) {
                        this.oggEffect.playAsSoundEffect(1.0f, this.volume.floatValue(), false);
                    }
                } else {
                    this.cue = this.soundBank.GetCue("m07 step");
                    this.cue.Play();
                }
            }
            if (Keyboard.getEventKey() == 31 && !this.useJaxt) {
                if (this.oggEffects != null) {
                    this.oggEffects[0].stop();
                    this.oggEffects[1].stop();
                } else {
                    this.oggEffect.stop();
                }
            }
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
            Keyboard.getEventKey();
        }
        SoundStore.get().poll(0);
    }

    void _changeVolume(double step) {
        this.volume = this.volume.add(new BigDecimal(step));
        if (this.volume.compareTo(new BigDecimal(0)) < 0) {
            this.volume = new BigDecimal(0);
        }
        System.out.println("volume: " + this.volume.floatValue());
        if (this.cue != null) {
            this.cue.SetVariable("MyVolume", this.volume.floatValue());
        } else {
            this.oggEffect.changeVolume(this.volume.floatValue());
        }
    }

    public void render() {
    }

    public static void main(String[] argv) {
        SoundTest soundExample = new SoundTest();
        soundExample.start();
    }
}

