/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Vector2;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxObject;
import org.flixel.FlxSprite;
import org.flixel.FlxU;
import org.flixel.data.FlxParticle;

public class FlxEmitter
extends FlxGroup {
    protected String m_id;
    protected boolean m_bStarted = false;
    int m_countLivingFast = 0;
    protected Vector2 minParticleSpeed;
    protected Vector2 maxParticleSpeed;
    protected Color particuleColor = Color.White();
    protected float minParticleScale = 1.0f;
    protected float maxParticleScale = 1.0f;
    protected float m_spawnDelay = 0.1f;
    protected boolean m_bExplode = false;
    protected float minLifeTime = 0.0f;
    protected float maxLifeTime = 0.0f;
    protected boolean m_bUseLifetime = false;
    protected float m_alphaDecreaseSpeed = 2.0f;
    protected boolean m_bMirroringV = false;
    public Vector2 particleDrag;
    protected float minRotation;
    public float maxRotation;
    public float gravity;
    public boolean on;
    public float delay;
    public int quantity;
    public boolean justEmitted;
    protected boolean _explode;
    protected float _timer;
    protected int _particle;
    protected int _counter;

    public String Id() {
        return this.m_id;
    }

    public void Id(String value) {
        this.m_id = value;
    }

    public boolean Started() {
        return this.m_bStarted;
    }

    public int countLivingFast() {
        if (this.m_bUseLifetime) {
            return this.m_countLivingFast;
        }
        return this.countLiving();
    }

    public void particuleColor(Color value) {
        this.particuleColor.copy(value);
    }

    public void SpawnDelay(float value) {
        this.m_spawnDelay = value;
    }

    public float SpawnDelay() {
        return this.m_spawnDelay;
    }

    public void Explode(boolean value) {
        this.m_bExplode = value;
    }

    public boolean Explode() {
        return this.m_bExplode;
    }

    public boolean MirroringV() {
        return this.m_bMirroringV;
    }

    public void MirroringV(boolean value) {
        this.m_bMirroringV = value;
    }

    public FlxEmitter() {
        this.constructor(0, 0);
    }

    public FlxEmitter(int X, int Y) {
        this.constructor(X, Y);
    }

    private void constructor(int X, int Y) {
        this.x = X;
        this.y = Y;
        this.width = 0.0f;
        this.height = 0.0f;
        this.minParticleSpeed = new Vector2(-100.0f, -100.0f);
        this.maxParticleSpeed = new Vector2(100.0f, 100.0f);
        this.minRotation = -360.0f;
        this.maxRotation = 360.0f;
        this.gravity = 400.0f;
        this.particleDrag = new Vector2();
        this.delay = 0.0f;
        this.quantity = 0;
        this._counter = 0;
        this._explode = true;
        this.exists = false;
        this.on = false;
        this.justEmitted = false;
    }

    public FlxEmitter createSprites(Texture2D Graphics2, int Quantity, int WidthOrZero, int HeightOrZero) {
        return this.createSprites(Graphics2, Quantity, true, 0.0f, 0.0f, WidthOrZero, HeightOrZero);
    }

    public FlxEmitter createSprites(Texture2D Graphics2, int Quantity, boolean Multiple, int WidthOrZero, int HeightOrZero) {
        return this.createSprites(Graphics2, Quantity, Multiple, 0.0f, 0.0f, WidthOrZero, HeightOrZero);
    }

    public FlxEmitter createSprites(Texture2D Graphics2, int Quantity, boolean Multiple, float Collide, float Bounce, int WidthOrZero, int HeightOrZero) {
        FlxSprite s;
        this.members = new ArrayList(Quantity);
        int tf = 1;
        if (Multiple) {
            s = new FlxSprite();
            s.loadGraphic(Graphics2, true);
            tf = s.frames;
            s.active = false;
        }
        int i = 0;
        while (i < Quantity) {
            s = Collide > 0.0f && Bounce > 0.0f ? new FlxParticle(Bounce) : new FlxSprite();
            if (Multiple) {
                int r = (int)(FlxU.random() * (float)tf);
                s.loadGraphic(Graphics2, true);
                s.frame(r);
            } else {
                s.loadGraphic(Graphics2, false, false, WidthOrZero, HeightOrZero);
            }
            s.active = false;
            if (Collide > 0.0f) {
                float sw = s.width;
                float sh = s.height;
                s.width = (int)(s.width * Collide);
                s.height = (int)(s.height * Collide);
                s.offset.X = (int)(sw - s.width) / 2;
                s.offset.Y = (int)(sh - s.height) / 2;
                s.solid = true;
            } else {
                s.solid = false;
            }
            s.exists = false;
            s.scrollFactor = this.scrollFactor;
            this.add(s);
            ++i;
        }
        return this;
    }

    public void setSize(int Width, int Height) {
        this.width = Width;
        this.height = Height;
    }

    public void setXSpeed() {
        this.setXSpeed(0.0f, 0.0f);
    }

    public void setXSpeed(float Min, float Max) {
        this.minParticleSpeed.X = Min;
        this.maxParticleSpeed.X = Max;
    }

    public void setScale(float Min, float Max) {
        this.minParticleScale = Min;
        this.maxParticleScale = Max;
    }

    public void lifeTime(float Min, float Max) {
        this.minLifeTime = Min;
        this.maxLifeTime = Max;
        if (this.minLifeTime != 0.0f || this.maxLifeTime != 0.0f) {
            this.m_bUseLifetime = true;
        }
    }

    public void alphaDisappearSpeed(float _speed) {
        this.m_alphaDecreaseSpeed = _speed;
    }

    public void setYSpeed() {
        this.setYSpeed(0.0f, 0.0f);
    }

    public void setYSpeed(float Min, float Max) {
        this.minParticleSpeed.Y = Min;
        this.maxParticleSpeed.Y = Max;
    }

    public void setRotation() {
        this.setRotation(0.0f, 0.0f);
    }

    public void setRotation(float Min, float Max) {
        this.minRotation = Min;
        this.maxRotation = Max;
    }

    protected void updateEmitter() {
        if (this._explode) {
            this._timer += FlxG.elapsed;
            if (this.delay > 0.0f && this._timer > this.delay) {
                this.kill();
                return;
            }
            if (this.on) {
                this.on = false;
                int i = this._particle;
                int l = this.members.size();
                if (this.quantity > 0) {
                    l = this.quantity;
                }
                l += this._particle;
                while (i < l) {
                    this.emitParticle();
                    ++i;
                }
            }
            return;
        }
        if (!this.on) {
            return;
        }
        this._timer += FlxG.elapsed;
        while (this._timer > this.delay && (this.quantity <= 0 || this._counter < this.quantity)) {
            this._timer -= this.delay;
            this.emitParticle();
        }
    }

    @Override
    protected void updateMembers() {
        int i = 0;
        int l = this.members.size();
        float alphaStep = FlxG.elapsed * this.m_alphaDecreaseSpeed;
        while (i < l) {
            FlxSprite o;
            if ((o = (FlxSprite)this.members.get(i++)) == null || !o.exists || !o.active) continue;
            if (this.m_bUseLifetime) {
                o.health -= FlxG.elapsed;
                if (o.health < 0.0f) {
                    o.alpha(o.alpha() - alphaStep);
                }
                if (o.alpha() > 0.0f) {
                    o.update();
                }
                if (!(o.alpha() <= 0.0f)) continue;
                o.active = false;
                --this.m_countLivingFast;
                continue;
            }
            o.update();
        }
    }

    @Override
    public void update() {
        this.justEmitted = false;
        super.update();
        this.updateEmitter();
    }

    public void start() {
        this.start(true, 0.0f, 0);
    }

    public void start(boolean Explode, float Delay) {
        Explode = this.m_bExplode;
        this.start(Explode, Delay, 0);
    }

    public void start(boolean Explode, float Delay, int Quantity) {
        Delay = this.m_spawnDelay;
        Explode = this.m_bExplode;
        this.m_bStarted = true;
        if (this.members.size() <= 0) {
            FlxG.log("WARNING: there are no sprites loaded in your emitter.\nAdd some to FlxEmitter.members or use FlxEmitter.createSprites().");
            return;
        }
        this._explode = Explode;
        if (!this._explode) {
            this._counter = 0;
        }
        if (!this.exists) {
            this._particle = 0;
        }
        this.exists = true;
        this.visible = true;
        this.active = true;
        this.dead = false;
        this.on = true;
        this._timer = 0.0f;
        if (this.quantity == 0) {
            this.quantity = Quantity;
        } else if (Quantity != 0) {
            this.quantity = Quantity;
        }
        if (Delay != 0.0f) {
            this.delay = Delay;
        }
        if (this.delay < 0.0f) {
            this.delay = -this.delay;
        }
        if (this.delay == 0.0f) {
            this.delay = Explode ? 3.0f : 0.1f;
        }
    }

    public void emitParticle() {
        ++this._counter;
        FlxSprite s = (FlxSprite)this.members.get(this._particle);
        if (this.m_bUseLifetime && !s.active) {
            ++this.m_countLivingFast;
        }
        s.visible = true;
        s.exists = true;
        s.active = true;
        s.x = this.x - (float)((int)s.width >> 1) + FlxU.random() * this.width;
        s.y = this.y - (float)((int)s.height >> 1) + FlxU.random() * this.height;
        s.velocity.X = this.minParticleSpeed.X;
        if (this.minParticleSpeed.X != this.maxParticleSpeed.X) {
            s.velocity.X += FlxU.random() * (this.maxParticleSpeed.X - this.minParticleSpeed.X);
            if (this.m_bMirroringV) {
                s.velocity.X *= -1.0f;
            }
        }
        s.velocity.Y = this.minParticleSpeed.Y;
        if (this.minParticleSpeed.Y != this.maxParticleSpeed.Y) {
            s.velocity.Y += FlxU.random() * (this.maxParticleSpeed.Y - this.minParticleSpeed.Y);
        }
        s.acceleration.Y = this.gravity;
        s.scale(this.minParticleScale);
        if (this.minParticleScale != this.maxParticleScale) {
            s.scale(s.scale() + FlxU.random() * (this.maxParticleScale - this.minParticleScale));
        }
        if (this.m_bUseLifetime) {
            s.alpha(1.0f);
            s.health = this.minLifeTime;
            if (this.minLifeTime != this.maxLifeTime) {
                s.health += FlxU.random() * (this.maxLifeTime - this.minLifeTime);
            }
        }
        s.color(this.particuleColor);
        s.angularVelocity = this.minRotation;
        if (this.minRotation != this.maxRotation) {
            s.angularVelocity += FlxU.random() * (this.maxRotation - this.minRotation);
            if (this.m_bMirroringV) {
                s.angularVelocity *= -1.0f;
            }
        }
        if (s.angularVelocity != 0.0f) {
            s.angle(FlxU.random() * 360.0f - 180.0f);
            if (this.m_bMirroringV) {
                s.angle(s.angle() * -1.0f);
            }
        }
        s.drag.X = this.particleDrag.X;
        s.drag.Y = this.particleDrag.Y;
        ++this._particle;
        if (this._particle >= this.members.size()) {
            this._particle = 0;
        }
        s.onEmit();
        this.justEmitted = true;
    }

    public void stop() {
        this.stop(3.0f);
    }

    public void stop(float Delay) {
        this.m_bStarted = false;
        this._explode = true;
        this.delay = Delay;
        if (this.delay < 0.0f) {
            this.delay = -Delay;
        }
        this.on = false;
    }

    public void at(FlxObject Object2) {
        this.x = Object2.x + Object2.origin().X;
        this.y = Object2.y + Object2.origin().Y;
    }

    @Override
    public void kill() {
        super.kill();
        this.on = false;
    }
}

