/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Game;
import Microsoft.Xna.Framework.GraphicsDeviceManager;
import SSS.API.GameAPIManager;
import SSS.API.GameAPIOverlayPosition;
import SSS.API.eGameAPI;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.BTM.DialogManager;
import SSS.Managers.FileManager;
import SSS.Util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.flixel.FlxG;
import org.flixel.FlxGame;
import org.newdawn.slick.util.ClasspathLocation;
import org.newdawn.slick.util.FileSystemLocation;
import org.newdawn.slick.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import precompiler.MACRO;

public class FlxFactory
extends Game {
    private int resX = 1280;
    private int resY = 720;
    private boolean _fullScreen = false;
    private boolean _vsync = true;
    private boolean _limitFramerate = false;
    private int _maxFramerate = 60;
    private GraphicsDeviceManager _graphics;
    private FlxGame _flixelgame = null;
    private boolean m_bForceGameAPIDown = false;

    public FlxFactory(String[] args) {
        this._Patch_Linux();
        this._graphics = new GraphicsDeviceManager(this);
        this.Content().RootDirectory("Content");
        this._readArgs(args);
        FlxG.width = 1280;
        FlxG.height = 720;
        this.FrameRateLimit(this._limitFramerate, this._maxFramerate);
        boolean bMacTooOld = false;
        if (Utility.GetOsType() == Utility.eOsType.OSX && MACRO.USED_GAME_API_IF_NOT_BLANK == eGameAPI.SteamGameAPI) {
            String osVersion = System.getProperty("os.version");
            System.out.println("OS version: " + osVersion);
            if (osVersion.startsWith("10.5") || osVersion.startsWith("10.4")) {
                System.out.println("WARN: Deactivating GameAPI services");
                bMacTooOld = true;
            }
        }
        if (MACRO.USE_BLANK_GAME_API || this.m_bForceGameAPIDown && Utility.GetOsType() == Utility.eOsType.OSX || bMacTooOld) {
            GameAPIManager.BuildAPI(eGameAPI.BlankGameAPI);
        } else {
            GameAPIManager.BuildAPI(MACRO.USED_GAME_API_IF_NOT_BLANK);
        }
        if (GameAPIManager.GameAPI().Init()) {
            GameAPIManager.GameAPI().SetOverlayNotificationPosition(GameAPIOverlayPosition.PositionTopRight);
        }
        this.changeResolution(this._fullScreen, this.resX, this.resY, this._vsync, false);
        FlxG.mouse.testBuildMouse();
        FlxG.Game = this;
        FlxG.GraphicDeviceManager = this._graphics;
    }

    protected void _Patch_Linux() {
    }

    public void changeResolution(boolean _fullscreen, int _resX, int _resY, boolean _vsync, boolean _saveChanges) {
        this._fullScreen = _fullscreen;
        this.resX = _resX;
        this.resY = _resY;
        this._vsync = _vsync;
        this._graphics.PreferMultiSampling(false);
        this._graphics.PreferredBackBufferWidth(this.resX);
        this._graphics.PreferredBackBufferHeight(this.resY);
        this._graphics.SynchronizeWithVerticalRetrace(_vsync);
        if (this._fullScreen != this._graphics.IsFullScreen()) {
            this._graphics.ToggleFullScreen();
        }
        try {
            this._graphics.ApplyChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (_saveChanges) {
            this.saveDisplaySettings();
        }
    }

    public void saveDisplaySettings() {
        try {
            Element elemDisplayOptions;
            Document dispOptDoc = this.Content().LoadXDocumentOutOfContent("config/DisplayOptions");
            if (dispOptDoc != null && (elemDisplayOptions = (Element)dispOptDoc.getElementsByTagName("DisplayOptions").item(0)) != null && elemDisplayOptions.hasChildNodes()) {
                NodeList listOptions = elemDisplayOptions.getChildNodes();
                int listOptionsId = 0;
                while (listOptionsId < listOptions.getLength()) {
                    Node node = listOptions.item(listOptionsId);
                    if (node.getNodeType() == 1) {
                        Element elem = (Element)node;
                        String nodeName = elem.getNodeName();
                        if (nodeName.equals("fullscreen")) {
                            elem.setAttribute("value", this._fullScreen ? "1" : "0");
                        } else if (!this._fullScreen && nodeName.equals("windowedWidth")) {
                            elem.setAttribute("value", Integer.toString(this.resX));
                        } else if (!this._fullScreen && nodeName.equals("windowedHeight")) {
                            elem.setAttribute("value", Integer.toString(this.resY));
                        } else if (this._fullScreen && nodeName.equals("fullscreenWidth")) {
                            elem.setAttribute("value", Integer.toString(this.resX));
                        } else if (this._fullScreen && nodeName.equals("fullscreenHeight")) {
                            elem.setAttribute("value", Integer.toString(this.resY));
                        } else if (nodeName.equals("stretched")) {
                            elem.setAttribute("value", FlxG.RenderingStreched() ? "1" : "0");
                        } else if (nodeName.equals("scale")) {
                            elem.setAttribute("value", Float.toString(FlxG.RenderingScale()));
                        }
                    }
                    ++listOptionsId;
                }
                this.Content().WriteXDocumentOutOfContent("config/DisplayOptions", dispOptDoc, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _readArgs(String[] args) {
        Element elemDisplayOptions;
        Document dispOptDoc;
        String arg;
        int len;
        boolean bFullScreenArg = this._fullScreen;
        boolean bVSync = this._vsync;
        int iResXArg = this.resX;
        int iResYArg = this.resY;
        File extraArgsFile = new File("args.txt");
        if (extraArgsFile.exists() && extraArgsFile.isFile() && (len = (int)extraArgsFile.length()) > 0) {
            byte[] data;
            block64: {
                data = new byte[len];
                int offset = 0;
                try {
                    int read;
                    FileInputStream is = new FileInputStream(extraArgsFile);
                    do {
                        read = ((InputStream)is).read(data, offset, len);
                        len -= read;
                        offset += read;
                    } while (read > 0);
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    if (!MACRO.DEBUG) break block64;
                    e.printStackTrace();
                }
            }
            String contentExtraArgs = new String(data);
            String[] extraArgs = contentExtraArgs.split(" ");
            int i = 0;
            while (i < extraArgs.length) {
                arg = extraArgs[i];
                if (MACRO.USED_GAME_API_IF_NOT_BLANK != eGameAPI.SteamGameAPI && arg.equals("-homegamedata") && ++i < extraArgs.length) {
                    boolean bHomeData = Integer.parseInt(extraArgs[i]) > 0;
                    MACRO.USE_EXTERNAL_GAMEDATA_FOLDER = bHomeData;
                }
                ++i;
            }
        }
        if (MACRO.USED_GAME_API_IF_NOT_BLANK == eGameAPI.SteamGameAPI) {
            MACRO.USE_EXTERNAL_GAMEDATA_FOLDER = false;
        }
        if (MACRO.USE_EXTERNAL_GAMEDATA_FOLDER) {
            if (Utility.GetOsType() == Utility.eOsType.Linux || Utility.GetOsType() == Utility.eOsType.OSX) {
                MACRO.ROOT_DATA_GAME_DIR_NAME = "." + MACRO.ROOT_DATA_GAME_DIR_NAME;
                FileManager.Instance().renameHome(MACRO.ROOT_DATA_GAME_DIR_NAME_OLD, MACRO.ROOT_DATA_GAME_DIR_NAME);
            }
            FileManager.Instance().changeSaveFileFromLocalToHomeDir();
            File newRootPath = new File(FileManager.Instance().getRootHomePath());
            if (!newRootPath.exists()) {
                newRootPath.mkdir();
            }
            ResourceLoader.removeAllResourceLocations();
            ResourceLoader.addResourceLocation(new FileSystemLocation(newRootPath));
            ResourceLoader.addResourceLocation(new ClasspathLocation());
            ResourceLoader.addResourceLocation(new FileSystemLocation(new File(".")));
        }
        if (MACRO.USE_EXTERNAL_GAMEDATA_FOLDER) {
            FileManager.Instance().checkHomeFolderPresence("Blocks That Matter Save");
            FileManager.Instance().checkHomeFolderPresence("config");
            FileManager.Instance().checkHomeFolderPresence("Community");
        }
        if ((dispOptDoc = this.Content().LoadXDocumentOutOfContent("config/DisplayOptions")) != null && (elemDisplayOptions = (Element)dispOptDoc.getElementsByTagName("DisplayOptions").item(0)) != null && elemDisplayOptions.hasChildNodes()) {
            int wWindowed = iResXArg;
            int hWindowed = iResYArg;
            int wFullscreen = iResXArg;
            int hFullscreen = iResYArg;
            NodeList listOptions = elemDisplayOptions.getChildNodes();
            int listOptionsId = 0;
            while (listOptionsId < listOptions.getLength()) {
                Node node = listOptions.item(listOptionsId);
                if (node.getNodeType() == 1) {
                    Element elem = (Element)node;
                    String nodeName = elem.getNodeName();
                    if (nodeName.equals("fullscreen")) {
                        bFullScreenArg = Integer.parseInt(elem.getAttribute("value")) > 0;
                    } else if (nodeName.equals("windowedWidth")) {
                        wWindowed = Integer.parseInt(elem.getAttribute("value"));
                    } else if (nodeName.equals("windowedHeight")) {
                        hWindowed = Integer.parseInt(elem.getAttribute("value"));
                    } else if (nodeName.equals("fullscreenWidth")) {
                        wFullscreen = Integer.parseInt(elem.getAttribute("value"));
                    } else if (nodeName.equals("fullscreenHeight")) {
                        hFullscreen = Integer.parseInt(elem.getAttribute("value"));
                    } else if (nodeName.equals("stretched")) {
                        FlxG.RenderingStreched(Integer.parseInt(elem.getAttribute("value")) > 0);
                    } else if (nodeName.equals("language")) {
                        FlxG.Langage = elem.getAttribute("value");
                        String guess = elem.getAttribute("guess");
                        if (guess != null && guess.length() > 0) {
                            FlxG.GuessLangage = Integer.parseInt(guess) > 0;
                        }
                    } else if (nodeName.equals("vsync")) {
                        bVSync = Integer.parseInt(elem.getAttribute("value")) > 0;
                    } else if (nodeName.equals("framerate")) {
                        this._limitFramerate = Integer.parseInt(elem.getAttribute("limit")) > 0;
                        this._maxFramerate = Integer.parseInt(elem.getAttribute("limitframerate"));
                    } else if (nodeName.equals("scale")) {
                        try {
                            float scale = Float.parseFloat(elem.getAttribute("value"));
                            FlxG.RenderingScale(scale);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (nodeName.equals("gameApiForceOff")) {
                        try {
                            int forceGameAPIDown = Integer.parseInt(elem.getAttribute("value"));
                            this.m_bForceGameAPIDown = forceGameAPIDown > 0;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (nodeName.equals("dialogAlwaysDisplay")) {
                        try {
                            int forceDialog = Integer.parseInt(elem.getAttribute("value"));
                            DialogManager.ForceDisplayDialogs = forceDialog > 0;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++listOptionsId;
            }
            if (MACRO.DIALOG_VIEWER) {
                bFullScreenArg = false;
            }
            if (bFullScreenArg) {
                iResXArg = wFullscreen;
                iResYArg = hFullscreen;
            } else {
                iResXArg = wWindowed;
                iResYArg = hWindowed;
            }
        }
        int i = 0;
        while (i < args.length) {
            arg = args[i];
            if (arg.equals("-f")) {
                if (++i < args.length) {
                    bFullScreenArg = Integer.parseInt(args[i]) > 0;
                }
            } else if (arg.equals("-w")) {
                if (++i < args.length) {
                    iResXArg = Integer.parseInt(args[i]);
                }
            } else if (arg.equals("-h")) {
                if (++i < args.length) {
                    iResYArg = Integer.parseInt(args[i]);
                }
            } else if (arg.equals("-l")) {
                if (++i < args.length) {
                    FlxG.Langage = args[i];
                }
            } else if (arg.equals("-v")) {
                if (++i < args.length) {
                    bVSync = Integer.parseInt(args[i]) > 0;
                }
            } else if (arg.equals("-homegamedata") && ++i < args.length) {
                boolean bHomeData = Integer.parseInt(args[i]) > 0;
                MACRO.USE_EXTERNAL_GAMEDATA_FOLDER = bHomeData;
            }
            ++i;
        }
        this._fullScreen = bFullScreenArg;
        this._vsync = bVSync;
        this.resX = iResXArg;
        this.resY = iResYArg;
    }

    @Override
    protected void Initialize() {
        this._flixelgame = new FlxGame();
        this.Components().add(this._flixelgame);
        if (GameAPIManager.GameAPI().Init()) {
            GameAPIManager.GameAPI().SetCloudEnabled(true);
            AchievementManager.Instance().buildAchievements();
        }
        super.Initialize();
    }

    @Override
    protected void OnExiting(Object sender, Object args) {
        GameAPIManager.GameAPI().ShutDown();
    }
}

