/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Audio.SoundEffect;
import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.DrawableGameComponent;
import Microsoft.Xna.Framework.GameTime;
import Microsoft.Xna.Framework.Graphics.BlendState;
import Microsoft.Xna.Framework.Graphics.DepthFormat;
import Microsoft.Xna.Framework.Graphics.DepthStencilState;
import Microsoft.Xna.Framework.Graphics.Effect;
import Microsoft.Xna.Framework.Graphics.RasterizerState;
import Microsoft.Xna.Framework.Graphics.RenderTarget2D;
import Microsoft.Xna.Framework.Graphics.RenderTargetUsage;
import Microsoft.Xna.Framework.Graphics.SamplerState;
import Microsoft.Xna.Framework.Graphics.SpriteSortMode;
import Microsoft.Xna.Framework.Graphics.SurfaceFormat;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.PlayerIndex;
import Microsoft.Xna.Framework.Point;
import Microsoft.Xna.Framework.Rectangle;
import Microsoft.Xna.Framework.Vector2;
import SSS.BTM.PlayState;
import SSS.Managers.BTM.AchievementManager;
import SSS.Managers.MusicManager;
import SSS.States.BTM.SplashScreenState;
import org.flixel.FlxG;
import org.flixel.FlxSoundManager;
import org.flixel.FlxSprite;
import org.flixel.FlxState;
import org.flixel.FlxText;
import org.flixel.data.FlxConsole;
import org.flixel.data.FlxPause;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import precompiler.MACRO;

public class FlxGame
extends DrawableGameComponent {
    private FlxState _firstScreen;
    private SoundEffect _sndBeep;
    FlxState _state;
    private RenderTarget2D backRender;
    int targetWidth = 0;
    int targetLeft = 0;
    private boolean _paused;
    FlxPause _pausePanel;
    boolean _soundTrayVisible;
    Rectangle _soundTrayRect;
    float _soundTrayTimer;
    FlxSprite[] _soundTrayBars;
    FlxText _soundCaption;
    FlxConsole _console;
    static boolean m_bCanCheckForTrialTimeOut = false;
    public static boolean CanCheckForTrialTimeOut;
    boolean m_bTimeCounterDone = false;
    float m_timeCounter = 0.0f;
    static float MaxTrialCounter;
    Rectangle m_renderingRect = new Rectangle();
    Effect m_colorCorrectionEffect;
    private String[] _helpStrings;
    private Point _quakeOffset = Point.Zero();

    static {
        MaxTrialCounter = 420.0f;
    }

    public FlxState getState() {
        return this._state;
    }

    public int targetWidth() {
        return this.targetWidth;
    }

    public int targetLeft() {
        return this.targetLeft;
    }

    public FlxConsole GetConsole() {
        return this._console;
    }

    public FlxGame() {
        super(FlxG.Game);
        if (!MACRO.LOAD_SOUND_ASYNC) {
            FlxSoundManager.Initialize("Content/sss/audio/");
        }
        FlxG.SSSUseNearTextureFiltering = true;
        this.initGame(FlxG.width, FlxG.height, new SplashScreenState(), new Color(19, 28, 27), false, new Color(58, 92, 57));
    }

    public void initGame(int GameSizeX, int GameSizeY, FlxState InitialState, Color BGColor, boolean showFlixelLogo, Color logoColor) {
        FlxG.backColor = BGColor;
        FlxG.setGameData(this, GameSizeX, GameSizeY);
        this._paused = false;
        if (!showFlixelLogo) {
            this._firstScreen = InitialState;
        }
    }

    protected void help(String X, String C, String Mouse2, String Arrows) {
        this._helpStrings = new String[4];
        if (X != null) {
            this._helpStrings[0] = X;
        }
        if (C != null) {
            this._helpStrings[1] = C;
        }
        if (Mouse2 != null) {
            this._helpStrings[2] = Mouse2;
        }
        if (Arrows != null) {
            this._helpStrings[3] = Arrows;
        }
        if (this._pausePanel != null) {
            this._pausePanel.helpX = this._helpStrings[0];
            this._pausePanel.helpC = this._helpStrings[1];
            this._pausePanel.helpMouse = this._helpStrings[2];
            this._pausePanel.helpArrows = this._helpStrings[3];
        }
    }

    @Override
    public void Initialize() {
        if (MACRO.USE_RT) {
            this.backRender = new RenderTarget2D(this.GraphicsDevice(), FlxG.width, FlxG.height, false, SurfaceFormat.Color, DepthFormat.None, 0, RenderTargetUsage.DiscardContents);
        }
    }

    private void initConsole() {
        this._console = new FlxConsole(this.targetLeft, this.targetWidth);
        this._console.log(String.valueOf(FlxG.LIBRARY_NAME) + " v" + Integer.toString(FlxG.LIBRARY_MAJOR_VERSION) + "." + Integer.toString(FlxG.LIBRARY_MINOR_VERSION));
        this._console.log("---------------------------------------");
        this._pausePanel = new FlxPause();
        if (this._helpStrings != null) {
            this._pausePanel.helpX = this._helpStrings[0];
            this._pausePanel.helpC = this._helpStrings[1];
            this._pausePanel.helpMouse = this._helpStrings[2];
            this._pausePanel.helpArrows = this._helpStrings[3];
        }
        this._soundTrayRect = new Rectangle((FlxG.width - 80) / 2, -30, 80, 30);
        this._soundTrayVisible = false;
        this._soundCaption = new FlxText((float)((FlxG.width - 80) / 2), -10.0f, 80.0f, "VOLUME");
        this._soundCaption.setFormat(null, (float)1.0f, (Color)Color.White(), (FlxText.FlxJustification)FlxText.FlxJustification.Center, (Color)Color.White()).height = 10.0f;
        int bx = 10;
        int by = 14;
        this._soundTrayBars = new FlxSprite[10];
        int i = 0;
        while (i < 10) {
            this._soundTrayBars[i] = new FlxSprite(this._soundTrayRect.X + bx * 1, -i, null);
            this._soundTrayBars[i].width = 4.0f;
            this._soundTrayBars[i].height = i + 1;
            this._soundTrayBars[i].scrollFactor = Vector2.Zero();
            bx += 6;
            --by;
            ++i;
        }
    }

    @Override
    protected void LoadContent() {
        this.targetWidth = FlxG.RenderingRatioCorrection() != 1.0f ? FlxG.width : (int)((float)this.GraphicsDevice().Viewport().Height * ((float)FlxG.width / (float)FlxG.height));
        this.targetLeft = (this.GraphicsDevice().Viewport().Width - this.targetWidth) / 2;
        FlxG.LoadContent(this.GraphicsDevice());
        this._sndBeep = FlxG.Content().LoadSoundEffect("flixel/beep");
        this.initConsole();
        if (this._firstScreen != null) {
            FlxG.state(this._firstScreen);
        }
    }

    protected void UnloadContent() {
        if (this._sndBeep != null) {
            this._sndBeep.Dispose();
        }
        if (FlxG.state() != null) {
            FlxG.state().destroy();
        }
    }

    public void switchState(FlxState newscreen) {
        FlxG.unfollow();
        FlxG.keys.reset();
        FlxG.gamepads.reset();
        FlxG.mouse.reset();
        FlxG.flash.stop();
        FlxG.fade.stop();
        FlxG.quake.stop();
        if (this._state != null) {
            this._state.destroy();
        }
        this._state = newscreen;
        this._state.create();
    }

    void unpauseGame() {
        FlxG.resetInput();
        this._paused = false;
    }

    void pauseGame() {
        this._paused = true;
    }

    @Override
    public void Update(GameTime gameTime) {
        PlayerIndex pi = null;
        FlxG.m_bHasFocusOld = FlxG.m_bHasFocus;
        FlxG.m_bHasFocus = Display.isVisible() && Display.isActive();
        FlxG.getTimer = (int)gameTime.TotalGameTime.TotalMilliseconds;
        FlxG.elapsed = (float)gameTime.ElapsedGameTime.TotalSeconds;
        if (FlxG.elapsed > FlxG.maxElapsed) {
            FlxG.elapsed = FlxG.maxElapsed;
        }
        FlxG.elapsed *= FlxG.timeScale;
        this._console.update();
        if (this._soundTrayTimer > 0.0f) {
            this._soundTrayTimer -= FlxG.elapsed;
        } else if (this._soundTrayRect.Y > -this._soundTrayRect.Height) {
            this._soundTrayRect.Y -= (int)(FlxG.elapsed * (float)FlxG.height * 2.0f);
            this._soundCaption.y = this._soundTrayRect.Y + 4;
            int i = 0;
            while (i < this._soundTrayBars.length) {
                this._soundTrayBars[i].y = (float)(this._soundTrayRect.Y + this._soundTrayRect.Height) - this._soundTrayBars[i].height - 2.0f;
                ++i;
            }
            if (this._soundTrayRect.Y < -this._soundTrayRect.Height) {
                this._soundTrayVisible = false;
            }
        }
        FlxG.keys.update();
        FlxG.gamepads.update();
        FlxG.mouse.update();
        FlxG.updateSounds();
        if (MACRO.USE_FLIXEL_STUFF && (FlxG.keys.isNewKeyPress(Keys.D1, null, pi) || FlxG.keys.isNewKeyPress(Keys.OemTilde, null, pi))) {
            this._console.toggle();
        }
        if (MACRO.DEBUG) {
            FlxG.keys.isNewKeyPress(Keys.Escape, null, pi);
        }
        if (this._paused) {
            return;
        }
        if (FlxG.state() != null) {
            FlxG.doFollow();
            FlxG.state().update();
            if (FlxG.flash.exists) {
                FlxG.flash.update();
            }
            if (FlxG.fade.exists) {
                FlxG.fade.update();
            }
            FlxG.quake.update();
            this._quakeOffset.X = FlxG.quake.x;
            this._quakeOffset.Y = FlxG.quake.y;
        }
        FlxSoundManager.Update();
        MusicManager.Instance().update();
        AchievementManager.Instance().update();
    }

    protected void _trialEnd(Object _sender) {
        FlxG.state(new PlayState(true, false, "BUY", "Specials"));
    }

    @Override
    public void Draw(GameTime gameTime) {
        if (MACRO.USE_RT) {
            this.GraphicsDevice().SetRenderTarget(this.backRender);
            this.GraphicsDevice().Clear(FlxG.backColorSSS);
        }
        if (!MACRO.USE_RT) {
            boolean bScretch = FlxG.RenderingStreched();
            float displayW = this.GraphicsDevice().DisplayMode().Width();
            float displayH = this.GraphicsDevice().DisplayMode().Height();
            float ratio_inv = 1.0f * (float)FlxG.height / (float)FlxG.width;
            float scalex = (float)FlxG.width / displayW;
            float scaley = bScretch ? (float)FlxG.height / displayH : scalex;
            float ratioNative = this.GraphicsDevice().NativeDisplayMode().AspectRatio();
            float ratio = this.GraphicsDevice().DisplayMode().AspectRatio();
            float rationCorrection = FlxG.GraphicDeviceManager.IsFullScreen() ? ratioNative / ratio : 1.0f;
            float w = displayW;
            float h = bScretch ? displayH : displayW * ratio_inv;
            float realW = w * FlxG.RenderingScale();
            float realH = h * FlxG.RenderingScale() * rationCorrection;
            int x = bScretch ? 0 : (int)((displayW - realW) * 0.5f);
            int y = bScretch ? 0 : (int)((displayH - realH) * 0.5f);
            GL11.glViewport((int)(x + FlxG.quake.x), (int)(y + FlxG.quake.y), (int)((int)realW), (int)((int)realH));
            GL11.glMatrixMode((int)5888);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)(w * scalex), (double)(h * scaley), (double)0.0, (double)1.0, (double)-1.0);
            GL11.glMatrixMode((int)5888);
            this.GraphicsDevice().SetRenderTarget(null);
            this.GraphicsDevice().Clear(FlxG.backColorSSS);
        }
        if (FlxG.state() != null) {
            FlxG.state().preProcess(FlxG.spriteBatch);
            FlxG.state().render(FlxG.spriteBatch);
            if (FlxG.SSSUseNearTextureFiltering) {
                FlxG.spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.NonPremultiplied, SamplerState.PointClamp, DepthStencilState.None, RasterizerState.CullCounterClockwise);
            } else {
                FlxG.spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.NonPremultiplied, SamplerState.LinearClamp, DepthStencilState.None, RasterizerState.CullCounterClockwise);
            }
            if (FlxG.flash.exists) {
                FlxG.flash.render(FlxG.spriteBatch);
            }
            if (FlxG.fade.exists) {
                FlxG.fade.render(FlxG.spriteBatch);
            }
            FlxG.state().renderOverall(FlxG.spriteBatch);
            if (FlxG.mouse.cursor.visible) {
                FlxG.mouse.cursor.render(FlxG.spriteBatch);
            }
            FlxG.spriteBatch.End();
            FlxG.state().postProcess(FlxG.spriteBatch);
        }
        this.GraphicsDevice().SetRenderTarget(null);
        if (MACRO.USE_RT) {
            this.GraphicsDevice().Clear(FlxG.backColor);
            FlxG.spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.Opaque, SamplerState.LinearClamp, DepthStencilState.None, RasterizerState.CullCounterClockwise, this.m_colorCorrectionEffect);
            this.m_renderingRect.Width = (int)((float)this.targetWidth * FlxG.RenderingScale());
            this.m_renderingRect.Height = (int)((float)this.GraphicsDevice().Viewport().Height * FlxG.RenderingScale() * FlxG.RenderingRatioCorrection());
            this.m_renderingRect.X = this.targetLeft + this._quakeOffset.X + (int)((float)(FlxG.width - this.m_renderingRect.Width) * 0.5f);
            this.m_renderingRect.Y = FlxG.RenderingRatioCorrection() != 1.0f ? this._quakeOffset.Y + (int)((float)(this.GraphicsDevice().Viewport().Height - this.m_renderingRect.Height) * 0.5f) : this._quakeOffset.Y + (int)((float)(FlxG.height - this.m_renderingRect.Height) * 0.5f);
            FlxG.spriteBatch.Draw((Texture2D)this.backRender, this.m_renderingRect, Color._White);
            FlxG.spriteBatch.End();
        }
        if (this._console.visible) {
            FlxG.spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.NonPremultiplied, SamplerState.PointClamp, DepthStencilState.None, RasterizerState.CullCounterClockwise);
            this._console.render(FlxG.spriteBatch);
            FlxG.spriteBatch.End();
        }
        ++FlxG.FrameId;
    }

    private void showSoundTray() {
        if (!FlxG.GetMute()) {
            this._sndBeep.Play(FlxG.GetVolume(), 0.0f, 0.0f);
        }
        this._soundTrayTimer = 1.0f;
        this._soundTrayRect.Y = 0;
        this._soundTrayVisible = true;
        this._soundCaption.y = this._soundTrayRect.Y + 4;
        int gv = Math.round(FlxG.GetVolume() * 10.0f);
        if (FlxG.GetMute()) {
            gv = 0;
        }
        int i = 0;
        while (i < this._soundTrayBars.length) {
            this._soundTrayBars[i].y = (float)(this._soundTrayRect.Y + this._soundTrayRect.Height) - this._soundTrayBars[i].height - 2.0f;
            if (i < gv) {
                this._soundTrayBars[i].alpha(1.0f);
            } else {
                this._soundTrayBars[i].alpha(0.5f);
            }
            ++i;
        }
    }
}

