/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Vector2;
import java.util.ArrayList;
import org.flixel.FlxObject;
import org.flixel.FlxU;

public class FlxGroup
extends FlxObject {
    public ArrayList<FlxObject> members;
    protected Vector2 _last;
    protected boolean _first;

    public FlxGroup() {
        this._group = true;
        this.solid = false;
        this.members = new ArrayList(200);
        this._last = Vector2.Zero();
        this._first = true;
    }

    public FlxObject add(FlxObject Object2) {
        return this.add(Object2, false);
    }

    public FlxObject add(FlxObject Object2, boolean ShareScroll) {
        if (this.members.indexOf(Object2) < 0) {
            this.members.add(Object2);
        }
        if (ShareScroll) {
            Object2.scrollFactor = this.scrollFactor;
        }
        return Object2;
    }

    public FlxObject replace(FlxObject OldObject, FlxObject NewObject) {
        int index = this.members.indexOf(OldObject);
        if (index < 0 || index >= this.members.size()) {
            return null;
        }
        this.members.set(index, NewObject);
        return NewObject;
    }

    public FlxObject remove(FlxObject Object2) {
        return this.remove(Object2, false);
    }

    public FlxObject remove(FlxObject Object2, boolean Splice) {
        int index = this.members.indexOf(Object2);
        if (index < 0 || index >= this.members.size()) {
            return null;
        }
        if (Splice) {
            this.members.remove(index);
        } else {
            this.members.set(index, null);
        }
        return Object2;
    }

    public FlxObject getFirstAvail() {
        int ml = this.members.size();
        for (int i = 0; i < ml; ++i) {
            FlxObject o = this.members.get(i);
            if (o == null || o.exists) continue;
            return o;
        }
        return null;
    }

    public int getFirstNull() {
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            if (this.members.get(i) == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean resetFirstAvail(int X, int Y) {
        FlxObject o = this.getFirstAvail();
        if (o == null) {
            return false;
        }
        o.reset(X, Y);
        return true;
    }

    public FlxObject getFirstExtant() {
        int ml = this.members.size();
        for (int i = 0; i < ml; ++i) {
            FlxObject o = this.members.get(i);
            if (o == null || !o.exists) continue;
            return o;
        }
        return null;
    }

    public FlxObject getFirstAlive() {
        int ml = this.members.size();
        for (int i = 0; i < ml; ++i) {
            FlxObject o = this.members.get(i);
            if (o == null || !o.exists || o.dead) continue;
            return o;
        }
        return null;
    }

    public FlxObject getFirstDead() {
        int ml = this.members.size();
        for (int i = 0; i < ml; ++i) {
            FlxObject o = this.members.get(i);
            if (o == null || !o.dead) continue;
            return o;
        }
        return null;
    }

    public int countLiving() {
        int count = -1;
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null) continue;
            if (count < 0) {
                count = 0;
            }
            if (!o.exists || o.dead) continue;
            ++count;
        }
        return count;
    }

    public int countDead() {
        int count = -1;
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null) continue;
            if (count < 0) {
                count = 0;
            }
            if (!o.dead) continue;
            ++count;
        }
        return count;
    }

    public int countOnScreen() {
        int count = -1;
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null) continue;
            if (count < 0) {
                count = 0;
            }
            if (!o.onScreen()) continue;
            ++count;
        }
        return count;
    }

    public FlxObject getRandom() {
        int c = 0;
        FlxObject o = null;
        int l = this.members.size();
        int i = (int)(FlxU.random() * (float)l);
        while (o == null && c < this.members.size()) {
            o = this.members.get(++i % l);
            ++c;
        }
        return o;
    }

    protected void saveOldPosition() {
        if (this._first) {
            this._first = false;
            this._last.X = 0.0f;
            this._last.Y = 0.0f;
            return;
        }
        this._last.X = this.x;
        this._last.Y = this.y;
    }

    protected void updateMembers() {
        float mx = 0.0f;
        float my = 0.0f;
        boolean moved = false;
        if (this.x != this._last.X || this.y != this._last.Y) {
            moved = true;
            mx = this.x - this._last.X;
            my = this.y - this._last.Y;
        }
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null || !o.exists) continue;
            if (moved) {
                if (o._group) {
                    o.reset(o.x + mx, o.y + my);
                } else {
                    o.x += mx;
                    o.y += my;
                }
            }
            if (o.active) {
                o.update();
            }
            if (!moved || !o.solid) continue;
            o.colHullX.width = o.colHullX.width + (mx > 0.0f ? mx : -mx);
            if (mx < 0.0f) {
                o.colHullX.x += mx;
            }
            o.colHullY.x = this.x;
            o.colHullY.height = o.colHullY.height + (my > 0.0f ? my : -my);
            if (my < 0.0f) {
                o.colHullY.y += my;
            }
            o.colVector.X += mx;
            o.colVector.Y += my;
        }
    }

    @Override
    public void update() {
        this.saveOldPosition();
        this.updateMotion();
        this.updateMembers();
        this.updateFlickering();
    }

    protected void renderMembers(SpriteBatch spriteBatch) {
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null || !o.exists || !o.visible) continue;
            o.render(spriteBatch);
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        this.renderMembers(spriteBatch);
    }

    protected void killMembers() {
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null) continue;
            o.kill();
        }
    }

    @Override
    public void kill() {
        this.killMembers();
        super.kill();
    }

    protected void destroyMembers() {
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null) continue;
            o.destroy();
        }
        this.members.clear();
    }

    @Override
    public void destroy() {
        this.destroyMembers();
        super.destroy();
    }

    @Override
    public void reset(float X, float Y) {
        this.saveOldPosition();
        super.reset(X, Y);
        float mx = 0.0f;
        float my = 0.0f;
        boolean moved = false;
        if (this.x != this._last.X || this.y != this._last.Y) {
            moved = true;
            mx = this.x - this._last.X;
            my = this.y - this._last.Y;
        }
        int i = 0;
        int ml = this.members.size();
        while (i < ml) {
            FlxObject o = this.members.get(i);
            ++i;
            if (o == null || !o.exists || !moved) continue;
            if (o._group) {
                o.reset(o.x + mx, o.y + my);
                continue;
            }
            o.x += mx;
            o.y += my;
            if (!this.solid) continue;
            o.colHullX.width = o.colHullX.width + (mx > 0.0f ? mx : -mx);
            if (mx < 0.0f) {
                o.colHullX.x += mx;
            }
            o.colHullY.x = this.x;
            o.colHullY.height = o.colHullY.height + (my > 0.0f ? my : -my);
            if (my < 0.0f) {
                o.colHullY.y += my;
            }
            o.colVector.X += mx;
            o.colVector.Y += my;
        }
    }
}

