/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Rectangle;
import Microsoft.Xna.Framework.Vector2;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxRect;
import org.flixel.FlxU;

public class FlxObject {
    public boolean exists;
    public boolean active;
    public boolean visible;
    public boolean solid;
    public boolean fixed;
    public Vector2 velocity;
    public Vector2 acceleration;
    public Vector2 drag;
    public Vector2 maxVelocity;
    protected float _angle = 0.0f;
    protected float _radians = 0.0f;
    public float angularVelocity;
    public float angularAcceleration;
    public float angularDrag;
    public float maxAngular;
    protected Vector2 _origin = Vector2.Zero();
    public float thrust;
    public float maxThrust;
    protected static Vector2 _pZero = Vector2.Zero();
    public Vector2 scrollFactor;
    protected boolean _flicker;
    protected float _flickerTimer;
    public float health;
    public boolean dead;
    protected Vector2 _point;
    protected Rectangle _rect;
    protected Vector2 _flashPoint;
    public boolean moves;
    public FlxRect colHullX;
    public FlxRect colHullY;
    public Vector2 colVector;
    public ArrayList<Vector2> colOffsets = new ArrayList();
    boolean _group;
    public boolean onFloor;
    public boolean collideLeft;
    public boolean collideRight;
    public boolean collideTop;
    public boolean collideBottom;
    public float x;
    public float y;
    public float width;
    public float height;

    public float angle() {
        return this._angle;
    }

    public void angle(float value) {
        this._angle = value;
        this._radians = MathHelper.ToRadians(this._angle);
    }

    public void origin(Vector2 value) {
        this._origin = value;
    }

    public Vector2 origin() {
        return this._origin;
    }

    public FlxObject() {
        this.constructor1(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public FlxObject(float X, float Y, float Width, float Height) {
        this.constructor1(X, Y, Width, Height);
    }

    private void constructor1(float X, float Y, float Width, float Height) {
        this.x = X;
        this.y = Y;
        this.width = Width;
        this.height = Height;
        this.exists = true;
        this.active = true;
        this.visible = true;
        this.solid = true;
        this.fixed = false;
        this.moves = true;
        this.collideLeft = true;
        this.collideRight = true;
        this.collideTop = true;
        this.collideBottom = true;
        this._origin = Vector2.Zero();
        this.velocity = Vector2.Zero();
        this.acceleration = Vector2.Zero();
        this.drag = Vector2.Zero();
        this.maxVelocity = new Vector2(10000.0f, 10000.0f);
        this.angle(0.0f);
        this.angularVelocity = 0.0f;
        this.angularAcceleration = 0.0f;
        this.angularDrag = 0.0f;
        this.maxAngular = 10000.0f;
        this.thrust = 0.0f;
        this.scrollFactor = new Vector2(1.0f, 1.0f);
        this._flicker = false;
        this._flickerTimer = -1.0f;
        this.health = 1.0f;
        this.dead = false;
        this._point = Vector2.Zero();
        this._rect = Rectangle.Empty.clone();
        this._flashPoint = Vector2.Zero();
        this.colHullX = FlxRect.Empty();
        this.colHullY = FlxRect.Empty();
        this.colVector = Vector2.Zero();
        this.colOffsets.add(Vector2.Zero());
        this._group = false;
    }

    public void destroy() {
    }

    public void refreshHulls() {
        this.colHullX.x = this.x;
        this.colHullX.y = this.y;
        this.colHullX.width = this.width;
        this.colHullX.height = this.height;
        this.colHullY.x = this.x;
        this.colHullY.y = this.y;
        this.colHullY.width = this.width;
        this.colHullY.height = this.height;
    }

    protected void updateMotion() {
        Vector2 thrustComponents;
        if (!this.moves) {
            return;
        }
        if (this.solid) {
            this.refreshHulls();
        }
        this.onFloor = false;
        this.angularVelocity = FlxU.computeVelocity(this.angularVelocity, this.angularAcceleration, this.angularDrag, this.maxAngular);
        this.angle(this.angle() + this.angularVelocity * FlxG.elapsed);
        if (this.thrust != 0.0f) {
            thrustComponents = FlxU.rotatePoint(-this.thrust, 0.0f, 0.0f, 0.0f, this.angle());
            Vector2 maxComponents = FlxU.rotatePoint(-this.maxThrust, 0.0f, 0.0f, 0.0f, this.angle());
            float max = Math.abs(maxComponents.X);
            if (max > Math.abs(maxComponents.Y)) {
                maxComponents.Y = max;
            } else {
                max = Math.abs(maxComponents.Y);
            }
            this.maxVelocity.X = Math.abs(max);
            this.maxVelocity.Y = Math.abs(max);
        } else {
            thrustComponents = Vector2.Zero();
        }
        this.velocity.X = FlxU.computeVelocity(this.velocity.X, this.acceleration.X + thrustComponents.X, this.drag.X, this.maxVelocity.X);
        this.velocity.Y = FlxU.computeVelocity(this.velocity.Y, this.acceleration.Y + thrustComponents.Y, this.drag.Y, this.maxVelocity.Y);
        this.x += this.velocity.X * FlxG.elapsed;
        this.y += this.velocity.Y * FlxG.elapsed;
        if (!this.solid) {
            return;
        }
        this.colVector.X = this.velocity.X * FlxG.elapsed;
        this.colVector.Y = this.velocity.Y * FlxG.elapsed;
        this.colHullX.width = this.colHullX.width + (this.colVector.X > 0.0f ? this.colVector.X : -this.colVector.X);
        if (this.colVector.X < 0.0f) {
            this.colHullX.x += this.colVector.X;
        }
        this.colHullY.x = this.x;
        this.colHullY.height = this.colHullY.height + (this.colVector.Y > 0.0f ? this.colVector.Y : -this.colVector.Y);
        if (this.colVector.Y < 0.0f) {
            this.colHullY.y += this.colVector.Y;
        }
    }

    public void updateFlickering() {
        if (this.flickering()) {
            if (this._flickerTimer > 0.0f) {
                this._flickerTimer -= FlxG.elapsed;
                if (this._flickerTimer == 0.0f) {
                    this._flickerTimer = -1.0f;
                }
            }
            if (this._flickerTimer < 0.0f) {
                this.flicker(-1.0f);
            } else {
                this._flicker = !this._flicker;
                this.visible = !this._flicker;
            }
        }
    }

    public void update() {
        this.updateMotion();
        this.updateFlickering();
    }

    public void render(SpriteBatch spriteBatch) {
    }

    public boolean overlaps(FlxObject Object2) {
        this._point = this.getScreenXY();
        float tx = this._point.X;
        float ty = this._point.Y;
        this._point = Object2.getScreenXY();
        return !(this._point.X <= tx - Object2.width || this._point.X >= tx + this.width || this._point.Y <= ty - Object2.height) && !(this._point.Y >= ty + this.height);
    }

    public boolean overlapsPoint(float X, float Y) {
        return this.overlapsPoint(X, Y, false);
    }

    public boolean overlapsPoint(float X, float Y, boolean PerPixel) {
        Y += FlxU.floor(FlxG.scroll.Y);
        this._point = this.getScreenXY();
        return !((X += FlxU.floor(FlxG.scroll.X)) <= this._point.X || X >= this._point.X + this.width || Y <= this._point.Y) && !(Y >= this._point.Y + this.height);
    }

    public boolean overlapsPointWithScale(float X, float Y, float scalex, float scaley) {
        Y += FlxU.floor(FlxG.scroll.Y);
        float dx = this.width * 0.5f - scalex * this.width * 0.5f;
        float dy = this.height * 0.5f - scaley * this.height * 0.5f;
        this._point = this.getScreenXY();
        return !((X += FlxU.floor(FlxG.scroll.X)) <= this._point.X + dx || X >= this._point.X + dx + this.width * scalex || Y <= this._point.Y + dy) && !(Y >= this._point.Y + dy + this.height * scaley);
    }

    public boolean collide(FlxObject Object2) {
        return FlxU.collide(this, Object2 == null ? this : Object2);
    }

    public void preCollide(FlxObject Object2) {
    }

    public void hitLeft(FlxObject Contact, float Velocity) {
        this.hitSide(Contact, Velocity);
    }

    public void hitRight(FlxObject Contact, float Velocity) {
        this.hitSide(Contact, Velocity);
    }

    public void hitSide(FlxObject Contact, float Velocity) {
        if (!this.fixed || Contact.fixed && (this.velocity.Y != 0.0f || this.velocity.X != 0.0f)) {
            this.velocity.X = Velocity;
        }
    }

    public void hitTop(FlxObject Contact, float Velocity) {
        if (!this.fixed || Contact.fixed && (this.velocity.Y != 0.0f || this.velocity.X != 0.0f)) {
            this.velocity.Y = Velocity;
        }
    }

    public void hitBottom(FlxObject Contact, float Velocity) {
        this.onFloor = true;
        if (!this.fixed || Contact.fixed && (this.velocity.Y != 0.0f || this.velocity.X != 0.0f)) {
            this.velocity.Y = Velocity;
        }
    }

    public void hurt(float Damage) {
        this.health -= Damage;
        if (this.health <= 0.0f) {
            this.kill();
        }
    }

    public void kill() {
        this.exists = false;
        this.dead = true;
    }

    public void flicker(float Duration2) {
        this._flickerTimer = Duration2;
        if (this._flickerTimer < 0.0f) {
            this._flicker = false;
            this.visible = true;
        }
    }

    public boolean flickering() {
        return this._flickerTimer >= 0.0f;
    }

    public Vector2 getScreenXY() {
        Vector2 Point2 = Vector2.Zero();
        Point2.X = FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X);
        Point2.Y = FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y);
        return Point2;
    }

    public boolean onScreen() {
        this._point = this.getScreenXY();
        return !(this._point.X + this.width < 0.0f || this._point.X > (float)FlxG.width || this._point.Y + this.height < 0.0f) && !(this._point.Y > (float)FlxG.height);
    }

    public void reset(float X, float Y) {
        this.x = X;
        this.y = Y;
        this.exists = true;
        this.dead = false;
    }

    public Color getBoundingColor() {
        if (this.solid) {
            if (this.fixed) {
                return new Color(0, 242, 37, 127);
            }
            return new Color(255, 0, 18, 127);
        }
        return new Color(0, 144, 233, 127);
    }
}

