/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Audio.AudioStopOptions;
import Microsoft.Xna.Framework.Audio.Cue;
import Microsoft.Xna.Framework.Audio.SoundEffectInstance;
import Microsoft.Xna.Framework.Audio.SoundState;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Tween.Tweenable;
import org.flixel.FlxG;
import org.flixel.FlxObject;
import org.flixel.FlxSoundManager;

public class FlxSound
extends FlxObject
implements Tweenable {
    public boolean survive;
    protected boolean _playing;
    protected boolean _init;
    protected SoundEffectInstance _sound;
    protected String m_embeddedSoundId = null;
    protected boolean m_bCueSound = false;
    protected Cue m_cueSound;
    protected boolean m_bUnstopable = false;
    protected boolean m_bLetPlayMultipleTime = false;
    protected float _position;
    protected float _volume;
    protected float _volumeAdjust;
    protected FlxObject _core;
    protected float _radius;
    protected boolean _pan;
    protected float _fadeOutTimer;
    protected float _fadeOutTotal;
    protected boolean _pauseOnFadeOut;
    protected float _fadeInTimer;
    protected float _fadeInTotal;
    protected Vector2 _point2;

    public String CueSoundId() {
        return this.m_embeddedSoundId;
    }

    public boolean Unstopable() {
        return this.m_bUnstopable;
    }

    public void Unstopable(boolean value) {
        this.m_bUnstopable = value;
    }

    public boolean playing() {
        if (this.m_bCueSound && this.m_cueSound != null) {
            this._playing = this.m_cueSound.IsPlaying();
        }
        return this._playing;
    }

    public void playing(boolean value) {
        this._playing = value;
    }

    protected boolean _looped() {
        if (this._sound == null) {
            return false;
        }
        return this._sound.IsLooped();
    }

    protected void _looped(boolean value) {
        if (this._sound != null) {
            this._sound.IsLooped(value);
        }
    }

    public boolean IsFadingOut() {
        return this._fadeOutTimer > 0.0f;
    }

    public boolean IsFadingIn() {
        return this._fadeInTimer > 0.0f;
    }

    public FlxSound() {
        this.fixed = true;
    }

    protected void init() {
        this.m_bCueSound = false;
        this.m_cueSound = null;
        this._sound = null;
        this._position = 0.0f;
        this._volume = 1.0f;
        this._volumeAdjust = 1.0f;
        this._looped(false);
        this._core = null;
        this._radius = 0.0f;
        this._pan = false;
        this._fadeOutTimer = 0.0f;
        this._fadeOutTotal = 0.0f;
        this._pauseOnFadeOut = false;
        this._fadeInTimer = 0.0f;
        this._fadeInTotal = 0.0f;
        this.active = false;
        this.visible = false;
        this.solid = false;
        this.playing(false);
    }

    public FlxSound loadEmbedded(String EmbeddedSound, boolean Looped, boolean _bCueSound, boolean _bMultiplePlay) {
        this.m_bLetPlayMultipleTime = _bMultiplePlay;
        this.stop();
        this.init();
        this.m_bCueSound = _bCueSound;
        if (this.m_bCueSound) {
            this.m_embeddedSoundId = EmbeddedSound;
            this.m_cueSound = this.m_bLetPlayMultipleTime ? null : FlxSoundManager.getCueSound(EmbeddedSound);
        } else {
            this._sound = FlxSoundManager.getSound(EmbeddedSound);
        }
        this._looped(Looped);
        this.updateTransform();
        this.active = true;
        return this;
    }

    public FlxSound proximity(float X, float Y, FlxObject Core, float Radius) {
        return this.proximity(X, Y, Core, Radius, true);
    }

    public FlxSound proximity(float X, float Y, FlxObject Core, float Radius, boolean Pan) {
        this.x = X;
        this.y = Y;
        this._core = Core;
        this._radius = Radius;
        this._pan = Pan;
        return this;
    }

    public void play(float _fromx, float _fromy, float _micx, float _micy) {
        if (this.m_bCueSound && this.m_bLetPlayMultipleTime) {
            FlxSoundManager.playCueSound3D(this.m_embeddedSoundId, _fromx, _fromy, _micx, _micy);
        } else {
            this.play();
        }
    }

    public void play() {
        if (this.m_bCueSound) {
            if (this.m_bLetPlayMultipleTime) {
                FlxSoundManager.playCueSound(this.m_embeddedSoundId);
                return;
            }
            if (this.m_cueSound == null) {
                return;
            }
            if (this.m_cueSound.IsPaused()) {
                this.m_cueSound.Resume();
            } else if (this.m_cueSound.IsStopped() || this.m_bLetPlayMultipleTime) {
                this.m_cueSound.Dispose();
                this.m_cueSound = FlxSoundManager.getCueSound(this.m_embeddedSoundId);
                this.updateTransform();
                this.m_cueSound.Play();
            } else if (!this.m_cueSound.IsPlaying()) {
                this.m_cueSound.Dispose();
                this.m_cueSound = FlxSoundManager.getCueSound(this.m_embeddedSoundId);
                this.updateTransform();
                this.m_cueSound.Play();
            }
        } else {
            if (this._sound == null) {
                return;
            }
            this._sound.Play();
        }
        this.volume(this.volume());
        this.playing(true);
        this.active = true;
        this._position = 0.0f;
    }

    public void updateDistanceAttenuation(float _emitx, float _emity, float _micx, float _micy) {
        if (this.m_bCueSound && this.m_cueSound != null) {
            float dx = _emitx - _micx;
            float dy = _emity - _micy;
            float dist = (float)Math.sqrt((dx /= 1.0f * (float)FlxG.width) * dx + (dy /= -1.0f * (float)FlxG.height) * dy);
            this.m_cueSound.SetVariable("Distance", dist);
        }
    }

    public void pause() {
        if (this.m_bCueSound) {
            if (this.m_cueSound == null) {
                return;
            }
            this.m_cueSound.Pause();
        } else {
            if (this._sound == null) {
                return;
            }
            this._sound.Pause();
        }
        this.playing(false);
    }

    public void stop(boolean _bForce) {
        if (_bForce) {
            this.Unstopable(false);
        }
        this.stop();
    }

    public void inverseFade() {
        if (this.IsFadingIn()) {
            this._fadeOutTimer = this._fadeInTimer;
            this._fadeInTimer = 0.0f;
        } else if (this.IsFadingOut()) {
            this._fadeInTimer = this._fadeOutTimer;
            this._fadeOutTimer = 0.0f;
        }
    }

    public void stopFades() {
        this._fadeOutTimer = 0.0f;
        this._fadeInTimer = 0.0f;
    }

    public void stop() {
        this._position = 0.0f;
        this.playing(false);
        this.active = false;
        if (this.m_bCueSound) {
            if (this.m_cueSound == null) {
                return;
            }
            if (this.m_cueSound.IsDisposed()) {
                return;
            }
            if (this.m_bUnstopable) {
                this.volume(0.0f);
            } else {
                this.m_cueSound.Stop(AudioStopOptions.Immediate);
            }
        } else {
            if (this._sound == null) {
                return;
            }
            this._sound.Stop();
        }
    }

    public void fadeOut(float Seconds) {
        this.fadeOut(Seconds, false);
    }

    public void fadeOut(float Seconds, boolean PauseInstead) {
        this._pauseOnFadeOut = PauseInstead;
        this._fadeInTimer = 0.0f;
        this._fadeOutTotal = this._fadeOutTimer = Seconds;
    }

    public void fadeIn(float Seconds) {
        this._fadeOutTimer = 0.0f;
        this._fadeInTotal = this._fadeInTimer = Seconds;
        this.play();
    }

    public float volume() {
        return this._volume;
    }

    public void volume(float value) {
        this._volume = value;
        if (this._volume < 0.0f) {
            this._volume = 0.0f;
        } else if (this._volume > 1.0f) {
            this._volume = 1.0f;
        }
        this.updateTransform();
    }

    protected void updateSound() {
        if (this._position != 0.0f) {
            return;
        }
        float radial = 1.0f;
        float fade = 1.0f;
        if (this.m_bCueSound) {
            if (this.m_cueSound != null && !this.m_cueSound.IsPlaying()) {
                this.active = false;
            }
        } else if (this._sound.State() != SoundState.Playing) {
            this.active = false;
        }
        if (this._core != null) {
            Vector2 _point = new Vector2();
            Vector2 _point2 = new Vector2();
            _point = this._core.getScreenXY();
            _point2 = this.getScreenXY();
            float dx = _point.X - _point2.X;
            float dy = _point.Y - _point2.Y;
            radial = (float)((double)this._radius - Math.sqrt(dx * dx + dy * dy)) / this._radius;
            if (radial < 0.0f) {
                radial = 0.0f;
            }
            if (radial > 1.0f) {
                radial = 1.0f;
            }
            if (this._pan) {
                float d = -dx / this._radius;
                if (d < -1.0f) {
                    d = -1.0f;
                } else if (d > 1.0f) {
                    d = 1.0f;
                }
                if (this.m_bCueSound && this.m_cueSound != null) {
                    this.m_cueSound.SetVariable("Pan", d);
                } else if (this._sound != null) {
                    this._sound.Pan(d);
                }
            }
        }
        if (this._fadeOutTimer > 0.0f) {
            this._fadeOutTimer -= FlxG.elapsed;
            if (this._fadeOutTimer <= 0.0f) {
                if (this._pauseOnFadeOut) {
                    this.pause();
                } else {
                    this.stop();
                }
            }
            if ((fade = this._fadeOutTimer / this._fadeOutTotal) < 0.0f) {
                fade = 0.0f;
            }
        } else if (this._fadeInTimer > 0.0f) {
            this._fadeInTimer -= FlxG.elapsed;
            fade = this._fadeInTimer / this._fadeInTotal;
            if (fade < 0.0f) {
                fade = 0.0f;
            }
            fade = 1.0f - fade;
        }
        this._volumeAdjust = radial * fade;
        this.updateTransform();
    }

    @Override
    public void update() {
        super.update();
        this.updateSound();
    }

    @Override
    public void destroy() {
        if (this.active) {
            this.stop();
        }
        if (this.m_bCueSound) {
            this._destroyCue();
        }
    }

    protected void _destroyCue() {
        if (this.m_cueSound != null) {
            this.m_cueSound.Dispose();
            this.m_cueSound = null;
        }
    }

    void updateTransform() {
        if (this.m_bCueSound) {
            if (this.m_cueSound == null) {
                return;
            }
            this.m_cueSound.SetVariable("MyVolume", this._volume * this._volumeAdjust);
        } else {
            if (this._sound == null) {
                return;
            }
            this._sound.Volume(this._volume * this._volumeAdjust);
        }
    }

    @Override
    public void TweenPosition(float _cx, float _cy) {
    }

    @Override
    public void TweenColor(float _r, float _g, float _b) {
    }

    @Override
    public void TweenAlpha(float _a) {
    }

    @Override
    public void TweenAngle(float _angle) {
    }

    @Override
    public void TweenScale(float _scalex, float _scaley) {
    }

    @Override
    public void TweenVolume(float _volumeValue) {
        this.volume(_volumeValue);
    }

    @Override
    public Vector2 GetTweenPosition() {
        return Vector2.Zero();
    }

    @Override
    public Vector3 GetTweenColor() {
        return Vector3.Zero();
    }

    @Override
    public Vector2 GetTweenScale() {
        return Vector2.One();
    }

    @Override
    public float GetTweenAlpha() {
        return 0.0f;
    }

    @Override
    public float GetTweenAngle() {
        return 0.0f;
    }

    @Override
    public float GetTweenVolume() {
        return this.volume();
    }
}

