/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Audio.AudioCategory;
import Microsoft.Xna.Framework.Audio.AudioEmitter;
import Microsoft.Xna.Framework.Audio.AudioEngine;
import Microsoft.Xna.Framework.Audio.AudioListener;
import Microsoft.Xna.Framework.Audio.Cue;
import Microsoft.Xna.Framework.Audio.SoundBank;
import Microsoft.Xna.Framework.Audio.SoundEffect;
import Microsoft.Xna.Framework.Audio.SoundEffectInstance;
import Microsoft.Xna.Framework.Audio.WaveBank;
import Microsoft.Xna.Framework.Vector3;
import System.Windows.Forms.MessageBox;
import java.util.ArrayList;
import org.flixel.FlxG;

public class FlxSoundManager {
    static AudioEngine audioEngine;
    static WaveBank waveBank;
    static SoundBank soundBank;
    static boolean muted;
    static AudioCategory defaultCategory;
    static AudioListener audioListener;
    static AudioEmitter audioEmitter;
    static int counter;
    static boolean m_bInitialized;
    static float m_generalVolume;
    private static ArrayList<SoundEffect> _sounds;

    static {
        counter = 0;
        m_bInitialized = false;
        m_generalVolume = 1.0f;
        _sounds = new ArrayList();
    }

    public static void Initialize(String _pathContent) {
        audioEngine = new AudioEngine(String.valueOf(_pathContent) + "Win/GameAudioProject.jgs");
        waveBank = new WaveBank(audioEngine, String.valueOf(_pathContent) + "Win/Wave Bank.jwb");
        soundBank = new SoundBank(audioEngine, String.valueOf(_pathContent) + "Win/Sound Bank.jsb");
        muted = false;
        audioListener = new AudioListener();
        audioEmitter = new AudioEmitter();
        defaultCategory = audioEngine.GetCategory("Default");
        m_bInitialized = true;
    }

    public static void Update() {
        if (m_bInitialized) {
            audioEngine.Update();
        }
    }

    public static void SetGeneralVolume(float _volume) {
        m_generalVolume = _volume;
        if (!muted && defaultCategory != null) {
            defaultCategory.SetVolume(_volume);
        }
    }

    public static boolean Muted() {
        return muted;
    }

    public static void Mute() {
        if (defaultCategory != null) {
            muted = !muted;
            defaultCategory.SetVolume(muted ? 0.0f : m_generalVolume);
        }
    }

    public static void playCueSound(String EmbeddedSound) {
        try {
            soundBank.PlayCue(EmbeddedSound);
        }
        catch (Exception e) {
            MessageBox.Show("Play sound fail: " + EmbeddedSound, "Missing Cue in data base");
        }
    }

    public static void playCueSound3D(String EmbeddedSound, float _sndx, float _sndy, float _micx, float _micy) {
        try {
            audioEmitter.Position(new Vector3(_sndx / (float)FlxG.width, _sndy / (-1.0f * (float)FlxG.height), 0.0f));
            audioListener.Position(new Vector3(_micx / (float)FlxG.width, _micy / (-1.0f * (float)FlxG.height), 0.0f));
            soundBank.PlayCue(EmbeddedSound, audioListener, audioEmitter);
        }
        catch (Exception e) {
            MessageBox.Show("Play sound fail: " + EmbeddedSound, "Missing Cue in data base");
        }
    }

    public static Cue getCueSound(String EmbeddedSound) {
        try {
            ++counter;
            return soundBank.GetCue(EmbeddedSound);
        }
        catch (Exception e) {
            MessageBox.Show("Play sound fail: " + EmbeddedSound, "Missing Cue in data base");
            return null;
        }
    }

    public static SoundEffectInstance getSound(String EmbeddedSound) {
        SoundEffect se = null;
        int i = 0;
        while (i < _sounds.size()) {
            se = _sounds.get(i);
            if (se != null && se.Name().compareTo(EmbeddedSound) == 0) {
                return se.CreateInstance();
            }
            ++i;
        }
        se = FlxG.Content().LoadSoundEffect(EmbeddedSound);
        _sounds.add(se);
        se.Name(EmbeddedSound);
        return se.CreateInstance();
    }
}

