/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Graphics.SpriteEffects;
import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Point;
import Microsoft.Xna.Framework.Rectangle;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Tween.Tweenable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.flixel.FlxEvent;
import org.flixel.FlxG;
import org.flixel.FlxObject;
import org.flixel.FlxU;
import org.flixel.data.FlxAnim;
import org.flixel.data.SssAnchorAnimation;

public class FlxSprite
extends FlxObject
implements Tweenable {
    protected Texture2D _tex;
    private boolean _stretchToFit = false;
    boolean m_bUseRounding = true;
    public Point offset = Point.Zero();
    protected Vector2 m_scale = Vector2.One();
    public String blend;
    public boolean antialiasing;
    public boolean finished;
    public int frameWidth;
    public int frameHeight;
    public int frames;
    private ArrayList<FlxAnim> _animations;
    private int _flipped;
    protected FlxAnim _curAnim;
    private HashMap<String, SssAnchorAnimation> _anchorAnimations = null;
    protected int _curFrame;
    boolean m_bFrameJustChanged = false;
    protected int _caf;
    private float _frameTimer;
    private FlxEvent.FlxAnimationCallback _callback;
    private Flx2DFacing _facing2d = Flx2DFacing.NotUsed;
    protected Rectangle _flashRect;
    protected Rectangle _flashRect2;
    protected Point _flashPointZero;
    protected float _alpha;
    protected Color _color = Color.White();
    private int _bytealpha = 255;
    Rectangle m_renderingRect = new Rectangle();
    static Vector2 PointScreenXYDouble = Vector2.Zero();
    static double xx;
    static double yy;
    static double scrollxx;
    static double scrollyy;
    static double floorx;
    static double floory;
    static Vector2 ScreenPositionTopLeft;
    static Vector2 VectorSprite;
    static Vector2 VectorScreen;

    static {
        ScreenPositionTopLeft = new Vector2();
        VectorSprite = new Vector2();
        VectorScreen = new Vector2();
    }

    public boolean UseRounding() {
        return this.m_bUseRounding;
    }

    public void UseRounding(boolean value) {
        this.m_bUseRounding = value;
    }

    public float scale() {
        return this.m_scale.Y;
    }

    public void scale(float value) {
        this.m_scale.X = value;
        this.m_scale.Y = value;
    }

    public float scaleX() {
        return this.m_scale.X;
    }

    public void scaleX(float value) {
        this.m_scale.X = value;
    }

    public float scaleY() {
        return this.m_scale.Y;
    }

    public void scaleY(float value) {
        this.m_scale.Y = value;
    }

    public FlxAnim CurAnim() {
        return this._curAnim;
    }

    public String getAnimName(int _index) {
        if (_index >= 0 && _index < this._animations.size()) {
            return this._animations.get((int)_index).name;
        }
        return null;
    }

    public HashMap<String, SssAnchorAnimation> getAnchorAnimations() {
        return this._anchorAnimations;
    }

    public Vector3 getAnchorSyncWithAnim(String _anchorId) {
        if (this._curAnim != null && this._anchorAnimations != null) {
            return this._anchorAnimations.get((Object)_anchorId).frames[this._curFrame];
        }
        return Vector3._Zero;
    }

    public Vector3 getAnchorSyncWithAnim(SssAnchorAnimation anchorAnim) {
        if (this._curAnim != null && anchorAnim != null) {
            return anchorAnim.frames[this._curAnim.frames[this._curFrame]];
        }
        return Vector3._Zero;
    }

    public SssAnchorAnimation getAnchor(String _anchorId) {
        return this._anchorAnimations.get(_anchorId);
    }

    public boolean CurFrameJustChanged() {
        return this.m_bFrameJustChanged;
    }

    public int CurFrame() {
        return this._curFrame;
    }

    public void CurFrame(int value) {
        this._curFrame = value;
    }

    public void hackShrinkFlashRect(int value) {
        this._flashRect.X += value;
        this._flashRect.Y += value;
        this._flashRect.Height -= value;
        this._flashRect.Width -= value;
    }

    public float realWidth() {
        return this._stretchToFit ? this.width : (float)this._flashRect.Width;
    }

    public float realHeight() {
        return this._stretchToFit ? this.height : (float)this._flashRect.Height;
    }

    public Color color() {
        return this._color;
    }

    public void color(Color value) {
        if (this._color == null || this._color.R != value.R || this._color.G != value.G || this._color.B != value.B) {
            this._color = new Color(value.R, value.G, value.B, this._bytealpha);
        }
    }

    public float alpha() {
        return this._alpha;
    }

    public void alpha(float value) {
        this._alpha = value;
        this._bytealpha = (int)(255.0f * this._alpha);
        this._color = new Color(this._color.R, this._color.G, this._color.B, this._bytealpha);
    }

    public ArrayList<FlxAnim> animations() {
        return this._animations;
    }

    public FlxSprite() {
        this.constructor(0.0f, 0.0f, null);
    }

    public FlxSprite(float X, float Y) {
        this.constructor(X, Y, null);
    }

    public FlxSprite(float X, float Y, Texture2D SimpleGraphic) {
        this.constructor(X, Y, SimpleGraphic);
    }

    private void constructor(float X, float Y, Texture2D SimpleGraphic) {
        this.x = X;
        this.y = Y;
        this._flashRect = new Rectangle();
        this._flashRect2 = new Rectangle();
        this._flashPointZero = new Point();
        this.offset = new Point();
        this.scale(1.0f);
        this._alpha = 1.0f;
        this._color = Color.White();
        this.blend = null;
        this.antialiasing = false;
        this.finished = false;
        this.facing(Flx2DFacing.NotUsed);
        this._animations = new ArrayList(5);
        this._flipped = 0;
        this._curAnim = null;
        this._curFrame = 0;
        this._caf = 0;
        this._frameTimer = 0.0f;
        this._callback = null;
        if (SimpleGraphic == null) {
            this.createGraphic(8, 8, this.color());
        } else {
            this.loadGraphic(SimpleGraphic);
        }
    }

    public FlxSprite(FlxSprite _sprite) {
        this._copyConstructor(_sprite);
    }

    protected void _copyConstructor(FlxSprite _sprite) {
        this.constructor(0.0f, 0.0f, null);
        this.loadGraphic(_sprite._tex, _sprite.animations().size() > 0, _sprite._flipped != 0, (int)_sprite.width, (int)_sprite.height);
        this.color(_sprite.color());
        if (_sprite.animations().size() > 0) {
            for (FlxAnim flxAnim : _sprite.animations()) {
                this.addAnimation(flxAnim.name, flxAnim.frames, flxAnim.getFramerate(), flxAnim.looped);
            }
            if (_sprite.CurAnim() != null) {
                this.play(_sprite.CurAnim().name);
            }
        }
        if (_sprite._anchorAnimations != null) {
            for (Map.Entry entry : _sprite.getAnchorAnimations().entrySet()) {
                this.addAnchorAnimation((String)entry.getKey(), ((SssAnchorAnimation)entry.getValue()).frames);
            }
        }
        this.scale(_sprite.scale());
    }

    public FlxSprite loadGraphic(Texture2D Graphic) {
        return this.loadGraphic(Graphic, false, false, 0, 0);
    }

    public FlxSprite loadGraphic(Texture2D Graphic, boolean Animated) {
        return this.loadGraphic(Graphic, Animated, false, 0, 0);
    }

    public FlxSprite loadGraphic(Texture2D Graphic, boolean Animated, boolean Reverse, int Width) {
        return this.loadGraphic(Graphic, Animated, Reverse, Width, 0);
    }

    public FlxSprite loadGraphic(Texture2D Graphic, boolean Animated, boolean Reverse, int Width, int Height) {
        if (Graphic == null) {
            return this.createGraphic(Width, Height, Color.White());
        }
        this._stretchToFit = false;
        this._tex = Graphic;
        this._flipped = Reverse ? Graphic.Width() >> 1 : 0;
        if (Width == 0) {
            Width = Animated ? Graphic.Height() : (this._flipped > 0 ? (int)((float)Graphic.Width() * 0.5f) : Graphic.Width());
        }
        this.frameWidth = Width;
        this.width = this.frameWidth;
        if (Height == 0) {
            Height = Animated ? (int)this.width : Graphic.Height();
        }
        this.frameHeight = Height;
        this.height = this.frameHeight;
        this.resetHelpers();
        return this;
    }

    public FlxSprite createGraphic(int Width, int Height, Color Color2) {
        this._tex = FlxG.GetXnaSheet();
        this._stretchToFit = true;
        this._facing2d = Flx2DFacing.NotUsed;
        this.frameWidth = 1;
        this.frameHeight = 1;
        this.width = Width;
        this.height = Height;
        this._color = Color2;
        this.resetHelpers();
        return this;
    }

    public void resetHelpers() {
        this._flashRect2.X = 0;
        this._flashRect2.Y = 0;
        if (!this._stretchToFit) {
            this._flashRect.X = 0;
            this._flashRect.Y = 0;
            this._flashRect.Width = this.frameWidth;
            this._flashRect.Height = this.frameHeight;
            this._flashRect2.Width = this._tex.Width();
            this._flashRect2.Height = this._tex.Height();
        } else {
            this._flashRect.X = 1;
            this._flashRect.Y = 1;
            this._flashRect.Width = this.frameWidth;
            this._flashRect.Height = this.frameHeight;
            this._flashRect2.Width = (int)this.width;
            this._flashRect2.Height = (int)this.height;
        }
        this._origin.X = (float)this.frameWidth * 0.5f;
        this._origin.Y = (float)this.frameHeight * 0.5f;
        this.frames = this._flashRect2.Width / this._flashRect.Width * (this._flashRect2.Height / this._flashRect.Height);
        this._caf = 0;
        this.refreshHulls();
    }

    protected void updateAnimation() {
        if (this._curAnim != null && this._curAnim.delay > 0.0f && (this._curAnim.looped || !this.finished)) {
            this.m_bFrameJustChanged = false;
            this._frameTimer += FlxG.elapsed;
            while (this._frameTimer > this._curAnim.delay) {
                this._frameTimer -= this._curAnim.delay;
                if (this._curFrame == this._curAnim.frames.length - 1) {
                    if (this._curAnim.looped) {
                        this._curFrame = 0;
                    }
                    this.finished = true;
                } else {
                    this.m_bFrameJustChanged = true;
                    ++this._curFrame;
                }
                this._caf = this._curAnim.frames[this._curFrame];
                this.calcFrame();
            }
        }
    }

    @Override
    public void update() {
        this.updateMotion();
        this.updateAnimation();
        this.updateFlickering();
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (!this.visible || !this.exists || this.alpha() <= 0.0f) {
            return;
        }
        if (this.m_scale.X != this.m_scale.Y) {
            Vector2 pos = Vector2.Zero();
            Vector2 vc = Vector2.Zero();
            Vector2.add(this.getScreenXY_ForRendering(), this.origin(), pos);
            pos.X += ((float)this._flashRect.Width - this.width) * (this._origin.X / this.width);
            pos.Y += ((float)this._flashRect.Height - this.height) * (this._origin.Y / this.height);
            vc = new Vector2(this._flashRect.Width, this._flashRect.Height);
            if (!this._stretchToFit) {
                vc.X *= this._origin.X / this.width;
                vc.Y *= this._origin.Y / this.height;
            } else {
                vc.X *= this._origin.X / (this.width + 1.0f);
                vc.Y *= this._origin.Y / (this.height + 1.0f);
            }
            this.m_renderingRect.X = (int)(pos.X - 0.5f);
            this.m_renderingRect.Y = (int)(pos.Y - 0.5f);
            this.m_renderingRect.Width = (int)(((float)this._flashRect.Width + 0.5f) * this.m_scale.X);
            this.m_renderingRect.Height = (int)(((float)this._flashRect.Height + 0.5f) * this.m_scale.Y);
            if (this._facing2d == Flx2DFacing.NotUsed) {
                if (this._stretchToFit) {
                    spriteBatch.Draw(this._tex, new Rectangle((int)pos.X, (int)pos.Y, (int)this.width, (int)this.height), this._flashRect, this._color, this._radians, vc, SpriteEffects.None, 0.0f);
                } else {
                    spriteBatch.Draw(this._tex, this.m_renderingRect, this._flashRect, this._color, this._radians, vc, SpriteEffects.None, 0.0f);
                }
            } else if (this._facing2d == Flx2DFacing.Right) {
                spriteBatch.Draw(this._tex, this.m_renderingRect, this._flashRect, this._color, this._radians, vc, SpriteEffects.None, 0.0f);
            } else {
                spriteBatch.Draw(this._tex, this.m_renderingRect, this._flashRect, this._color, this._radians, vc, SpriteEffects.FlipHorizontally, 0.0f);
            }
            if (FlxG.showBounds) {
                pos = this.getScreenXY_ForRendering();
                pos.X += (float)this.offset.X;
                pos.Y += (float)this.offset.Y;
                this.drawBounds(spriteBatch, (int)pos.X, (int)pos.Y);
            }
        } else {
            Vector2 pos = Vector2.Zero();
            Vector2 vc = Vector2.Zero();
            Vector2.add(this.getScreenXY_ForRendering(), this.origin(), pos);
            pos.X += ((float)this._flashRect.Width - this.width) * (this._origin.X / this.width);
            pos.Y += ((float)this._flashRect.Height - this.height) * (this._origin.Y / this.height);
            vc = new Vector2(this._flashRect.Width, this._flashRect.Height);
            if (!this._stretchToFit) {
                vc.X *= this._origin.X / this.width;
                vc.Y *= this._origin.Y / this.height;
            } else {
                vc.X *= this._origin.X / (this.width + 1.0f);
                vc.Y *= this._origin.Y / (this.height + 1.0f);
            }
            if (this._facing2d == Flx2DFacing.NotUsed) {
                if (this._stretchToFit) {
                    spriteBatch.Draw(this._tex, new Rectangle((int)pos.X, (int)pos.Y, (int)this.width, (int)this.height), this._flashRect, this._color, this._radians, vc, SpriteEffects.None, 0.0f);
                } else {
                    spriteBatch.Draw(this._tex, pos, this._flashRect, this._color, this._radians, vc, this.scale(), SpriteEffects.None, 0.0f);
                }
            } else if (this._facing2d == Flx2DFacing.Right) {
                spriteBatch.Draw(this._tex, pos, this._flashRect, this._color, this._radians, vc, this.scale(), SpriteEffects.None, 0.0f);
            } else {
                spriteBatch.Draw(this._tex, pos, this._flashRect, this._color, this._radians, vc, this.scale(), SpriteEffects.FlipHorizontally, 0.0f);
            }
            if (FlxG.showBounds) {
                pos = this.getScreenXY_ForRendering();
                pos.X += (float)this.offset.X;
                pos.Y += (float)this.offset.Y;
                this.drawBounds(spriteBatch, (int)pos.X, (int)pos.Y);
            }
        }
    }

    @Override
    public boolean overlapsPoint(float X, float Y, boolean PerPixel) {
        X += FlxU.floor(FlxG.scroll.X);
        Y += FlxU.floor(FlxG.scroll.Y);
        this._point = this.getScreenXY();
        return !(!this._stretchToFit ? X <= this._point.X || X >= this._point.X + (float)this.frameWidth || Y <= this._point.Y || Y >= this._point.Y + (float)this.frameHeight : X <= this._point.X || X >= this._point.X + this.width || Y <= this._point.Y || Y >= this._point.Y + this.height);
    }

    public void onEmit() {
    }

    public void addAnimation(String Name, int[] Frames) {
        this._animations.add(new FlxAnim(Name, Frames, 0, true));
    }

    public void addAnimation(String Name, int[] Frames, int FrameRate) {
        this._animations.add(new FlxAnim(Name, Frames, FrameRate, true));
    }

    public void addAnimation(String Name, int[] Frames, int FrameRate, boolean Looped) {
        this._animations.add(new FlxAnim(Name, Frames, FrameRate, Looped));
    }

    public void addAnchorAnimation(String Name, Vector3[] Frames) {
        if (this._anchorAnimations == null) {
            this._anchorAnimations = new HashMap();
        }
        this._anchorAnimations.put(Name, new SssAnchorAnimation(Name, Frames));
    }

    public void play(String AnimName, boolean Force, int CurFrame) {
        if (!Force && this._curAnim != null && AnimName.equals(this._curAnim.name)) {
            return;
        }
        this._curFrame = CurFrame;
        this._caf = 0;
        this._frameTimer = 0.0f;
        int i = 0;
        while (i < this._animations.size()) {
            if (this._animations.get((int)i).name.equals(AnimName)) {
                this._curAnim = this._animations.get(i);
                this.finished = this._curAnim.delay <= 0.0f;
                this._caf = this._curAnim.frames[this._curFrame];
                this.calcFrame();
                return;
            }
            ++i;
        }
    }

    public void play(int _idAnim, boolean Force) {
        this.play(this._animations.get((int)_idAnim).name, Force, 0);
    }

    public void play(String AnimName, boolean Force) {
        this.play(AnimName, Force, 0);
    }

    public void play(String AnimName) {
        this.play(AnimName, false, 0);
    }

    public Flx2DFacing facing() {
        return this._facing2d;
    }

    public void facing(Flx2DFacing value) {
        boolean c = this._facing2d != value;
        this._facing2d = value;
        if (c) {
            this.calcFrame();
        }
    }

    public void randomFrame() {
        this._curAnim = null;
        this._caf = (int)(FlxU.random() * (float)(this._tex.Width() / this.frameWidth));
        this.calcFrame();
    }

    public int frame() {
        return this._caf;
    }

    public void frame(int value) {
        this._curAnim = null;
        this._caf = value;
        this.calcFrame();
    }

    @Override
    public Vector2 getScreenXY() {
        Vector2 Point2 = Vector2.Zero();
        Point2.X = FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X) - (float)this.offset.X;
        Point2.Y = FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y) - (float)this.offset.Y;
        return Point2;
    }

    protected Vector2 getScreenXY_ForRendering() {
        Vector2 Point2 = Vector2.Zero();
        if (this.m_bUseRounding && this.scrollFactor.X == 0.0f && this.scrollFactor.Y == 0.0f) {
            this.m_bUseRounding = false;
        }
        if (this.m_bUseRounding) {
            Point2.X = FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X) - (float)this.offset.X;
            Point2.Y = FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y) - (float)this.offset.Y;
        } else {
            Point2.X = this.x + FlxG.scroll.X * this.scrollFactor.X - (float)this.offset.X;
            Point2.Y = this.y + FlxG.scroll.Y * this.scrollFactor.Y - (float)this.offset.Y;
        }
        return Point2;
    }

    protected Vector2 getScreenXY_Rounded() {
        Vector2 Point2 = Vector2.Zero();
        Point2.X = (int)(this.x + FlxG.scroll.X * this.scrollFactor.X - (float)this.offset.X);
        Point2.Y = (int)(this.y + FlxG.scroll.Y * this.scrollFactor.Y - (float)this.offset.Y);
        return Point2;
    }

    protected Vector2 getScreenXY_Precise() {
        xx = this.x;
        yy = this.y;
        scrollxx = FlxG.scroll.X * this.scrollFactor.X;
        scrollyy = FlxG.scroll.Y * this.scrollFactor.Y;
        floorx = FlxU.floorDouble(xx + FlxU.roundingErrorDouble) + FlxU.floorDouble(scrollxx) - (double)this.offset.X;
        floory = FlxU.floorDouble(yy + FlxU.roundingErrorDouble) + FlxU.floorDouble(scrollyy) - (double)this.offset.Y;
        FlxSprite.PointScreenXYDouble.X = (float)floorx;
        FlxSprite.PointScreenXYDouble.Y = (float)floory;
        return PointScreenXYDouble;
    }

    public boolean isVisibleOnScreen() {
        FlxSprite.ScreenPositionTopLeft.X = FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X) - (float)this.offset.X;
        FlxSprite.ScreenPositionTopLeft.Y = FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y) - (float)this.offset.Y;
        FlxSprite.VectorSprite.X = (float)FlxG.width - FlxSprite.ScreenPositionTopLeft.X;
        FlxSprite.VectorSprite.Y = (float)FlxG.height - FlxSprite.ScreenPositionTopLeft.Y;
        FlxSprite.VectorScreen.X = FlxSprite.ScreenPositionTopLeft.X + (float)this.frameWidth * this.m_scale.X;
        FlxSprite.VectorScreen.Y = FlxSprite.ScreenPositionTopLeft.Y + (float)this.frameHeight * this.m_scale.Y;
        if (FlxSprite.VectorScreen.X < 0.0f || FlxSprite.VectorScreen.Y < 0.0f) {
            return false;
        }
        return !(FlxSprite.VectorSprite.X < 0.0f) && !(FlxSprite.VectorSprite.Y < 0.0f);
    }

    public boolean isVisibleOnScreen(float _scale) {
        float offsetScalex = ((float)this.frameWidth * this.m_scale.X - (float)this.frameWidth * _scale) * 0.5f;
        float offsetScaley = ((float)this.frameHeight * this.m_scale.Y - (float)this.frameHeight * _scale) * 0.5f;
        FlxSprite.ScreenPositionTopLeft.X = FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X) - (float)this.offset.X + offsetScalex;
        FlxSprite.ScreenPositionTopLeft.Y = FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y) - (float)this.offset.Y + offsetScaley;
        FlxSprite.VectorSprite.X = (float)FlxG.width - FlxSprite.ScreenPositionTopLeft.X;
        FlxSprite.VectorSprite.Y = (float)FlxG.height - FlxSprite.ScreenPositionTopLeft.Y;
        FlxSprite.VectorScreen.X = FlxSprite.ScreenPositionTopLeft.X + (float)this.frameWidth * this.m_scale.X * _scale;
        FlxSprite.VectorScreen.Y = FlxSprite.ScreenPositionTopLeft.Y + (float)this.frameHeight * this.m_scale.Y * _scale;
        if (FlxSprite.VectorScreen.X < 0.0f || FlxSprite.VectorScreen.Y < 0.0f) {
            return false;
        }
        return !(FlxSprite.VectorSprite.X < 0.0f) && !(FlxSprite.VectorSprite.Y < 0.0f);
    }

    protected void calcFrame() {
        if (this._stretchToFit) {
            this._flashRect = new Rectangle(0, 0, this.frameWidth, this.frameHeight);
            return;
        }
        int rx = this._caf * this.frameWidth;
        int ry = 0;
        int w = this._tex.Width();
        int modulo = this._tex.Width() % this.frameWidth;
        if (modulo > 0) {
            w -= modulo;
        }
        if (rx >= w && w > 0) {
            ry = rx / w * this.frameHeight;
            rx %= w;
        }
        if (this._facing2d == Flx2DFacing.Left && this._flipped > 0) {
            rx = (this._flipped << 1) - rx - this.frameWidth;
        }
        this._flashRect = new Rectangle(rx, ry, this.frameWidth, this.frameHeight);
        if (this._callback != null && this._curAnim != null) {
            this._callback.callback(this._curAnim.name, this._curFrame, this._caf);
        }
    }

    protected void drawBounds(SpriteBatch spriteBatch, int X, int Y) {
        spriteBatch.Draw(FlxG.GetXnaSheet(), new Rectangle((int)(FlxU.floor(this.x + FlxU.roundingError) + FlxU.floor(FlxG.scroll.X * this.scrollFactor.X)), (int)(FlxU.floor(this.y + FlxU.roundingError) + FlxU.floor(FlxG.scroll.Y * this.scrollFactor.Y)), (int)this.width, (int)this.height), new Rectangle(1, 1, 1, 1), this.getBoundingColor());
    }

    @Override
    public void TweenPosition(float _cx, float _cy) {
        this.x = _cx - this.width * 0.5f;
        this.y = _cy - this.height * 0.5f;
    }

    @Override
    public void TweenColor(float _r, float _g, float _b) {
        this.color(new Color(_r, _g, _b));
    }

    @Override
    public void TweenAlpha(float _a) {
        this.alpha(_a);
    }

    @Override
    public void TweenAngle(float _angle) {
        this.angle(_angle);
    }

    @Override
    public void TweenScale(float _scalex, float _scaley) {
        this.scaleX(_scalex);
        this.scaleY(_scaley);
    }

    @Override
    public void TweenVolume(float _volume) {
    }

    @Override
    public Vector2 GetTweenPosition() {
        return new Vector2(this.x + this.width * 0.5f, this.y + this.height * 0.5f);
    }

    @Override
    public Vector3 GetTweenColor() {
        return new Vector3((float)this._color.R / 255.0f, (float)this._color.G / 255.0f, (float)this._color.B / 255.0f);
    }

    @Override
    public Vector2 GetTweenScale() {
        return new Vector2(this.scaleX(), this.scaleY());
    }

    @Override
    public float GetTweenAlpha() {
        return this.alpha();
    }

    @Override
    public float GetTweenAngle() {
        return this.angle();
    }

    @Override
    public float GetTweenVolume() {
        return 0.0f;
    }

    public static enum Flx2DFacing {
        NotUsed,
        Left,
        Right,
        Up,
        Down;

    }
}

