/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Graphics.SpriteEffects;
import Microsoft.Xna.Framework.Graphics.SpriteFont;
import Microsoft.Xna.Framework.Rectangle;
import Microsoft.Xna.Framework.Vector2;
import Microsoft.Xna.Framework.Vector3;
import SSS.Tween.Tweenable;
import org.flixel.FlxG;
import org.flixel.FlxSprite;

public class FlxText
extends FlxSprite
implements Tweenable {
    private String _text;
    private SpriteFont _font;
    private Vector2 _fontmeasure = Vector2.Zero();
    private final float m_factorScale = 0.26666668f;
    private float _scale = 1.0f;
    public boolean ComposedText = false;
    public boolean UseSpecialBalises = false;
    public int InterlineSpace = 10;
    public static String LineDelimiterRegEx = "\\[r\\]";
    public static String LineDelimiterTag = "[r]";
    public FlxJustification alignment = FlxJustification.Left;
    boolean m_bUseShadow = false;
    float m_shadowOffset = 1.0f;
    protected Color shadow;
    public Color backColor;

    public int textWidth() {
        return (int)this._fontmeasure.X;
    }

    public int textHeight() {
        return (int)this._fontmeasure.Y;
    }

    @Override
    public Vector2 origin() {
        return this._origin.multiply(this._scale);
    }

    @Override
    public void origin(Vector2 value) {
        this._origin = value.multiply(1.0f / this._scale);
    }

    public void autoSize() {
        this.width = this.textWidth();
        this.height = this.textHeight();
    }

    public FlxText(float X, float Y, float Width) {
        super(X, Y);
        this.constructor(X, Y, Width, 10.0f, "", Color.White(), FlxG.GetFont(), 1.0f, FlxJustification.Center, 0.0f);
    }

    public FlxText(float X, float Y, float Width, String Text2) {
        super(X, Y);
        if (Text2 == null) {
            Text2 = "";
        }
        this.constructor(X, Y, Width, 10.0f, Text2, Color.White(), FlxG.GetFont(), 1.0f, FlxJustification.Center, 0.0f);
    }

    public void constructor(float X, float Y, float Width, float Height, String sText, Color cColor, SpriteFont fFont, float fScale, FlxJustification fJustification, float fAngle) {
        this._text = sText;
        this.color(cColor);
        this.shadow = Color.Black();
        this.backColor = new Color(255, 255, 255, 0);
        if (fFont == null) {
            fFont = FlxG.GetFont();
        }
        this._font = fFont;
        this.angle(fAngle);
        this.alignment = fJustification;
        this.x = X;
        this.y = Y;
        this.width = Width;
        this.height = Height;
        this.scrollFactor = Vector2.Zero();
        this.solid = false;
        this.moves = false;
        this.scale(fScale);
    }

    public FlxText setFormat(SpriteFont Font2, float Scale, Color Color2, FlxJustification Alignment2, Color ShadowColor) {
        if (Font2 == null) {
            Font2 = FlxG.GetFont();
        }
        this._font = Font2;
        this.color(Color2);
        this.alignment = Alignment2;
        this.shadow = ShadowColor;
        this.scale(Scale);
        return this;
    }

    public String text() {
        return this._text;
    }

    public void text(String value) {
        this._text = this.UseSpecialBalises && !this.ComposedText ? (value.contains(LineDelimiterTag) ? value.replaceAll(LineDelimiterRegEx, "\n") : value) : value;
        this.recalcMeasurements();
    }

    @Override
    public float scaleX() {
        return this._scale;
    }

    @Override
    public void scaleX(float value) {
        this.scale(value);
    }

    @Override
    public float scaleY() {
        return this._scale;
    }

    @Override
    public void scaleY(float value) {
        this.scale(value);
    }

    @Override
    public float scale() {
        return this._scale;
    }

    @Override
    public void scale(float value) {
        this._origin.selMultiply(this._scale);
        this._scale = value * 0.26666668f;
        this._origin.selMultiply(1.0f / this._scale);
        this.recalcMeasurements();
    }

    public SpriteFont font() {
        return this._font;
    }

    public void font(SpriteFont value) {
        this._font = value;
        if (this._font == null) {
            this._font = FlxG.GetFont();
        }
        this.recalcMeasurements();
    }

    public boolean UseShadow() {
        return this.m_bUseShadow;
    }

    public void UseShadow(boolean value) {
        this.m_bUseShadow = value;
    }

    public float ShadowOffset() {
        return this.m_shadowOffset;
    }

    public void ShadowOffset(float value) {
        this.m_shadowOffset = value;
    }

    public Color shadow() {
        return this.shadow;
    }

    public void shadow(Color value) {
        this.shadow = value;
    }

    private void recalcMeasurements() {
        try {
            if (this._text != null && this._text.length() > 0 && this._fontmeasure != null) {
                Vector2.multiply(this._font.MeasureString(this._text), this._scale, this._fontmeasure);
                this.origin(new Vector2(this._fontmeasure.X / 2.0f, this._fontmeasure.Y / 2.0f));
            } else {
                this._fontmeasure = Vector2.Zero();
            }
        }
        catch (Exception e) {
            this._fontmeasure = Vector2.Zero();
        }
    }

    @Override
    public void render(SpriteBatch spriteBatch) {
        if (!this.visible || !this.exists || this.alpha() <= 0.0f || this._text.length() == 0) {
            return;
        }
        if (this.UseSpecialBalises) {
            this._renderText(spriteBatch, this._text, -this.origin().Y);
        } else {
            this._renderText(spriteBatch, this._text, 0.0f);
        }
    }

    protected void _renderText(SpriteBatch spriteBatch, String _textContent, float offset) {
        Vector2 pos = Vector2.Zero();
        if (this.scrollFactor.X != 0.0f || this.scrollFactor.Y != 0.0f) {
            Vector2.add(this.getScreenXY_ForRendering(), this.origin(), pos);
        } else {
            pos.X = this.x + this.origin().X;
            pos.Y = this.y + this.origin().Y;
            pos.X += FlxG.scroll.X * this.scrollFactor.X;
            pos.Y += FlxG.scroll.Y * this.scrollFactor.Y;
        }
        pos.Y += offset;
        if (this.backColor.A > 0) {
            spriteBatch.Draw(FlxG.GetXnaSheet(), new Rectangle((int)this.x, (int)this.y, (int)this.width, (int)this.height), new Rectangle(1, 1, 1, 1), this.backColor);
        }
        if (this.m_bUseShadow && !this.shadow.isSameColor(this.color())) {
            this.shadow.A = this.color().A;
            pos.X += this.ShadowOffset();
            pos.Y += this.ShadowOffset();
            if (this.alignment == FlxJustification.Left) {
                spriteBatch.DrawString(this._font, _textContent, pos, this.shadow, this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
            } else if (this.alignment == FlxJustification.Right) {
                spriteBatch.DrawString(this._font, _textContent, new Vector2(pos.X + this.width - (float)this.textWidth(), pos.Y), this.shadow, this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
            } else if (this.alignment == FlxJustification.Center) {
                spriteBatch.DrawString(this._font, _textContent, new Vector2(pos.X + (this.width - (float)this.textWidth()) / 2.0f, pos.Y), this.shadow, this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
            }
            pos.X -= this.ShadowOffset();
            pos.Y -= this.ShadowOffset();
        }
        if (this.alignment == FlxJustification.Left) {
            spriteBatch.DrawString(this._font, _textContent, pos, this.color(), this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
        } else if (this.alignment == FlxJustification.Right) {
            spriteBatch.DrawString(this._font, _textContent, new Vector2(pos.X + this.width - (float)this.textWidth(), pos.Y), this.color(), this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
        } else if (this.alignment == FlxJustification.Center) {
            spriteBatch.DrawString(this._font, _textContent, new Vector2(pos.X + (this.width - (float)this.textWidth()) / 2.0f, pos.Y), this.color(), this._radians, this._origin, this._scale, SpriteEffects.None, 0.0f);
        }
    }

    @Override
    public void TweenPosition(float _cx, float _cy) {
        this.x = _cx - this.width * 0.5f;
        this.y = _cy - this.height * 0.5f;
    }

    @Override
    public void TweenColor(float _r, float _g, float _b) {
        this.color(new Color(_r, _g, _b));
    }

    @Override
    public void TweenAlpha(float _a) {
        this.alpha(_a);
    }

    @Override
    public void TweenAngle(float _angle) {
        this.angle(_angle);
    }

    @Override
    public void TweenScale(float _scalex, float _scaley) {
        this.scale(_scalex);
    }

    @Override
    public Vector3 GetTweenColor() {
        return new Vector3((float)this.color().R / 255.0f, (float)this.color().G / 255.0f, (float)this.color().B / 255.0f);
    }

    @Override
    public Vector2 GetTweenPosition() {
        return new Vector2(this.x + this.width * 0.5f, this.y + this.height * 0.5f);
    }

    @Override
    public Vector2 GetTweenScale() {
        return new Vector2(this.scaleX(), this.scaleY());
    }

    @Override
    public float GetTweenAlpha() {
        return this.alpha();
    }

    public static enum FlxJustification {
        Left,
        Right,
        Center;

    }

    public static enum FlxVerticalJustification {
        Top,
        Bottom,
        Center;

    }
}

