/*
 * Decompiled with CFR 0.152.
 */
package org.flixel;

import Microsoft.Xna.Framework.Vector2;
import java.util.ArrayList;
import java.util.Random;
import org.flixel.FlxEvent;
import org.flixel.FlxG;
import org.flixel.FlxGroup;
import org.flixel.FlxObject;
import org.flixel.FlxQuadTree;
import org.flixel.FlxRect;
import org.flixel.event.FlxSpriteCollisionEvent;

public class FlxU {
    private static Random _randglobal = new Random();
    private static Random _rand;
    static float roundingError;
    static float roundingErrorTest;
    static double roundingErrorTestDouble;
    static double roundingErrorDouble;
    public static FlxQuadTree quadTree;
    static FlxSpriteCollisionEvent spriteCollicionEvent;
    static FlxEvent.SpriteCollisionEvent solveXCollisionImpl;
    static FlxEvent.SpriteCollisionEvent solveYCollisionImpl;
    static double tmp11;
    static double tmp12;
    static double tmp21;
    static double tmp22;
    static double tmp31;
    static double tmp32;
    static double tmp41;
    static double tmp42;

    static {
        roundingError = 1.0E-4f;
        roundingErrorTest = 1.0E-4f;
        roundingErrorTestDouble = 0.001;
        roundingErrorDouble = 1.0E-7;
        spriteCollicionEvent = new FlxSpriteCollisionEvent(null, null);
        solveXCollisionImpl = new FlxEvent.SpriteCollisionEvent(){

            @Override
            public boolean callback(Object _sender, FlxObject Attacker, FlxObject Target) {
                spriteCollicionEvent.Object1(Attacker);
                spriteCollicionEvent.Object2(Target);
                return FlxU.solveXCollision(_sender, spriteCollicionEvent);
            }
        };
        solveYCollisionImpl = new FlxEvent.SpriteCollisionEvent(){

            @Override
            public boolean callback(Object _sender, FlxObject Attacker, FlxObject Target) {
                spriteCollicionEvent.Object1(Attacker);
                spriteCollicionEvent.Object2(Target);
                return FlxU.solveYCollision(_sender, spriteCollicionEvent);
            }
        };
    }

    public static void openURL(String URL2) {
    }

    public static float abs(float N) {
        return N > 0.0f ? N : -N;
    }

    public static float floor(float N) {
        float n = (int)N;
        return N > 0.0f ? n : (n != N ? n - 1.0f : n);
    }

    public static double floorDouble(double N) {
        double n = (int)N;
        return N > 0.0 ? n : (n != N ? n - 1.0 : n);
    }

    public static float ceil(float N) {
        float n = (int)N;
        return N > 0.0f ? (n != N ? n + 1.0f : n) : n;
    }

    public static float min(float N1, float N2) {
        return N1 <= N2 ? N1 : N2;
    }

    public static float max(float N1, float N2) {
        return N1 >= N2 ? N1 : N2;
    }

    public static float random() {
        if (_rand == null) {
            int seed = _randglobal.nextInt();
            _rand = new Random(seed);
        }
        return _rand.nextFloat();
    }

    public static float random(float Seed) {
        if (Seed == 0.0f) {
            Seed = Float.MIN_VALUE;
        }
        if (Seed >= 1.0f) {
            if (Seed % 1.0f == 0.0f) {
                Seed /= (float)Math.PI;
            }
            Seed %= 1.0f;
        } else if (Seed < 0.0f) {
            Seed = Seed % 1.0f + 1.0f;
        }
        return 69621 * (int)(Seed * 2.1474836E9f) % Integer.MAX_VALUE / Integer.MAX_VALUE;
    }

    public static int startProfile() {
        return FlxG.getTimer;
    }

    public static int endProfile(int Start2, String Name, boolean Log2) {
        int t = FlxG.getTimer;
        if (Log2) {
            FlxG.log(String.valueOf(Name) + ": " + (t - Start2) / 1000 + "s");
        }
        return t;
    }

    public static Vector2 rotatePoint(float X, float Y, float PivotX, float PivotY, float Angle) {
        float radians = -Angle / 180.0f * (float)Math.PI;
        float dx = X - PivotX;
        float dy = PivotY - Y;
        return new Vector2((float)((double)PivotX + Math.cos(radians) * (double)dx - Math.sin(radians) * (double)dy), (float)((double)PivotY - (Math.sin(radians) * (double)dx + Math.cos(radians) * (double)dy)));
    }

    public static float getAngle(float X, float Y) {
        return (float)(Math.atan2(Y, X) * 180.0 / Math.PI);
    }

    public static int getColor(int Red, int Green, int Blue) {
        return FlxU.getColor(Red, Green, Blue, 1.0f);
    }

    public static int getColor(int Red, int Green, int Blue, float Alpha) {
        return ((int)(Alpha > 1.0f ? Alpha : Alpha * 255.0f) & 0xFF) << 24 | (Red & 0xFF) << 16 | (Green & 0xFF) << 8 | Blue & 0xFF;
    }

    public static int getColorHSB(float Hue, float Saturation, float Brightness) {
        return FlxU.getColorHSB(Hue, Saturation, Brightness, 1.0f);
    }

    public static int getColorHSB(float Hue, float Saturation, float Brightness, float Alpha) {
        float blue;
        float green;
        float red;
        if ((double)Saturation == 0.0) {
            red = Brightness;
            green = Brightness;
            blue = Brightness;
        } else {
            if (Hue == 360.0f) {
                Hue = 0.0f;
            }
            int slice = (int)Hue / 60;
            float hf = Hue / 60.0f - (float)slice;
            float aa = Brightness * (1.0f - Saturation);
            float bb = Brightness * (1.0f - Saturation * hf);
            float cc = Brightness * (1.0f - Saturation * (1.0f - hf));
            switch (slice) {
                case 0: {
                    red = Brightness;
                    green = cc;
                    blue = aa;
                    break;
                }
                case 1: {
                    red = bb;
                    green = Brightness;
                    blue = aa;
                    break;
                }
                case 2: {
                    red = aa;
                    green = Brightness;
                    blue = cc;
                    break;
                }
                case 3: {
                    red = aa;
                    green = bb;
                    blue = Brightness;
                    break;
                }
                case 4: {
                    red = cc;
                    green = aa;
                    blue = Brightness;
                    break;
                }
                case 5: {
                    red = Brightness;
                    green = aa;
                    blue = bb;
                    break;
                }
                default: {
                    red = 0.0f;
                    green = 0.0f;
                    blue = 0.0f;
                }
            }
        }
        return ((int)(Alpha > 1.0f ? Alpha : Alpha * 255.0f) & 0xFF) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static float computeVelocity(float Velocity, float Acceleration, float Drag, float Max) {
        if (Acceleration != 0.0f) {
            Velocity += Acceleration * FlxG.elapsed;
        } else if (Drag != 0.0f) {
            float d = Drag * FlxG.elapsed;
            Velocity = Velocity - d > 0.0f ? (Velocity -= d) : (Velocity + d < 0.0f ? (Velocity += d) : 0.0f);
        }
        if (Velocity != 0.0f && Max != 10000.0f) {
            if (Velocity > Max) {
                Velocity = Max;
            } else if (Velocity < -Max) {
                Velocity = -Max;
            }
        }
        return Velocity;
    }

    public static void setWorldBounds(float X, float Y, float Width, float Height) {
        FlxU.setWorldBounds(X, Y, Width, Height, 3);
    }

    public static void setWorldBounds(float X, float Y, float Width, float Height, int Divisions) {
        FlxQuadTree.bounds.x = X;
        FlxQuadTree.bounds.y = Y;
        if (Width > 0.0f) {
            FlxQuadTree.bounds.width = Width;
        }
        if (Height > 0.0f) {
            FlxQuadTree.bounds.height = Height;
        }
        if (Divisions > 0) {
            FlxQuadTree.divisions = Divisions;
        }
    }

    public static boolean overlap(FlxObject Object1, FlxObject Object2, FlxEvent.SpriteCollisionEvent Callback) {
        if (Object1 == null || !Object1.exists || Object2 == null || !Object2.exists) {
            return false;
        }
        quadTree = new FlxQuadTree(FlxQuadTree.bounds.x, FlxQuadTree.bounds.y, FlxQuadTree.bounds.width, FlxQuadTree.bounds.height, null);
        quadTree.add(Object1, 0);
        if (Object1 == Object2) {
            return quadTree.overlap(false, Callback);
        }
        quadTree.add(Object2, 1);
        return quadTree.overlap(true, Callback);
    }

    public static boolean collide(FlxObject Object1, FlxObject Object2) {
        boolean match;
        if (Object1 == null || !Object1.exists || Object2 == null || !Object2.exists) {
            return false;
        }
        quadTree = new FlxQuadTree(FlxQuadTree.bounds.x, FlxQuadTree.bounds.y, FlxQuadTree.bounds.width, FlxQuadTree.bounds.height, null);
        quadTree.add(Object1, 0);
        boolean bl = match = Object1 == Object2;
        if (!match) {
            quadTree.add(Object2, 1);
        }
        boolean cx = quadTree.overlap(!match, solveXCollisionImpl);
        boolean cy = quadTree.overlap(!match, solveYCollisionImpl);
        return cx || cy;
    }

    public static boolean solveXCollision(Object sender, FlxSpriteCollisionEvent e) {
        boolean p1hn2;
        float o1 = e.Object1().colVector.X;
        float o2 = e.Object2().colVector.X;
        if (o1 == o2) {
            return false;
        }
        e.Object1().preCollide(e.Object2());
        e.Object2().preCollide(e.Object1());
        boolean hit = false;
        boolean obj1Stopped = o1 == 0.0f;
        boolean obj1MoveNeg = o1 < 0.0f;
        boolean obj1MovePos = o1 > 0.0f;
        boolean obj2Stopped = o2 == 0.0f;
        boolean obj2MoveNeg = o2 < 0.0f;
        boolean obj2MovePos = o2 > 0.0f;
        FlxRect obj1Hull = e.Object1().colHullX;
        FlxRect obj2Hull = e.Object2().colHullX;
        ArrayList<Vector2> co1 = e.Object1().colOffsets;
        ArrayList<Vector2> co2 = e.Object2().colOffsets;
        int l1 = co1.size();
        int l2 = co2.size();
        boolean bl = !(obj1Stopped && obj2MoveNeg || obj1MovePos && obj2Stopped || obj1MovePos && obj2MoveNeg || obj1MoveNeg && obj2MoveNeg && (o1 > 0.0f ? o1 : -o1) < (o2 > 0.0f ? o2 : -o2) || obj1MovePos && obj2MovePos && (o1 > 0.0f ? o1 : -o1) > (o2 > 0.0f ? o2 : -o2)) ? false : (p1hn2 = true);
        if (p1hn2 ? !e.Object1().collideRight || !e.Object2().collideLeft : !e.Object1().collideLeft || !e.Object2().collideRight) {
            return false;
        }
        int i1 = 0;
        while (i1 < l1) {
            float ox1 = co1.get((int)i1).X;
            float oy1 = co1.get((int)i1).Y;
            obj1Hull.x += ox1;
            obj1Hull.y += oy1;
            int i2 = 0;
            while (i2 < l2) {
                boolean f2;
                boolean f1;
                float overlap;
                float oy2;
                float ox2;
                block33: {
                    block32: {
                        float r2;
                        float r1;
                        ox2 = co2.get((int)i2).X;
                        oy2 = co2.get((int)i2).Y;
                        obj2Hull.x += ox2;
                        obj2Hull.y += oy2;
                        tmp11 = (double)obj1Hull.x + (double)obj1Hull.width;
                        tmp12 = (double)obj2Hull.x + roundingErrorTestDouble;
                        tmp21 = (double)obj1Hull.x + roundingErrorTestDouble;
                        tmp22 = (double)obj2Hull.x + (double)obj2Hull.width;
                        tmp31 = (double)obj1Hull.y + (double)obj1Hull.height;
                        tmp32 = (double)obj2Hull.y + roundingErrorTestDouble;
                        tmp41 = (double)obj1Hull.y + roundingErrorTestDouble;
                        tmp42 = (double)obj2Hull.y + (double)obj2Hull.height;
                        if (tmp11 < tmp12 || tmp21 > tmp22 || tmp31 < tmp32 || tmp41 > tmp42) {
                            obj2Hull.x -= ox2;
                            obj2Hull.y -= oy2;
                            ++i2;
                            continue;
                        }
                        if (p1hn2) {
                            r1 = obj1MoveNeg ? obj1Hull.x + e.Object1().colHullY.width : obj1Hull.x + obj1Hull.width;
                            r2 = obj2MoveNeg ? obj2Hull.x : obj2Hull.x + obj2Hull.width - e.Object2().colHullY.width;
                        } else {
                            r1 = obj2MoveNeg ? -obj2Hull.x - e.Object2().colHullY.width : -obj2Hull.x - obj2Hull.width;
                            r2 = obj1MoveNeg ? -obj1Hull.x : -obj1Hull.x - obj1Hull.width + e.Object1().colHullY.width;
                        }
                        overlap = r1 - r2;
                        f1 = e.Object1().fixed;
                        f2 = e.Object2().fixed;
                        if (f1 && f2) {
                            f1 &= e.Object1().colVector.X == 0.0f && o1 == 0.0f;
                            f2 &= e.Object2().colVector.X == 0.0f && o2 == 0.0f;
                        }
                        if (overlap == 0.0f || !f1 && (double)(overlap > 0.0f ? overlap : -overlap) > (double)obj1Hull.width * 0.8) break block32;
                        if (f2) break block33;
                        float f = overlap > 0.0f ? overlap : -overlap;
                        if (!((double)f > (double)obj2Hull.width * 0.8)) break block33;
                    }
                    obj2Hull.x -= ox2;
                    obj2Hull.y -= oy2;
                    ++i2;
                    continue;
                }
                hit = true;
                float sv1 = e.Object2().velocity.X;
                float sv2 = e.Object1().velocity.X;
                if (!f1 && f2) {
                    if (e.Object1()._group) {
                        e.Object1().reset(e.Object1().x - overlap, e.Object1().y);
                    } else {
                        e.Object1().x -= overlap;
                    }
                } else if (f1 && !f2) {
                    if (e.Object2()._group) {
                        e.Object2().reset(e.Object2().x + overlap, e.Object2().y);
                    } else {
                        e.Object2().x += overlap;
                    }
                } else if (!f1 && !f2) {
                    overlap /= 2.0f;
                    if (e.Object1()._group) {
                        e.Object1().reset(e.Object1().x - overlap, e.Object1().y);
                    } else {
                        e.Object1().x -= overlap;
                    }
                    if (e.Object2()._group) {
                        e.Object2().reset(e.Object2().x + overlap, e.Object2().y);
                    } else {
                        e.Object2().x += overlap;
                    }
                    sv1 *= 0.5f;
                    sv2 *= 0.5f;
                }
                if (p1hn2) {
                    e.Object1().hitRight(e.Object2(), sv1);
                    e.Object2().hitLeft(e.Object1(), sv2);
                } else {
                    e.Object1().hitLeft(e.Object2(), sv1);
                    e.Object2().hitRight(e.Object1(), sv2);
                }
                if (!f1 && overlap != 0.0f) {
                    if (p1hn2) {
                        obj1Hull.width -= overlap;
                    } else {
                        obj1Hull.x -= overlap;
                        obj1Hull.width += overlap;
                    }
                    e.Object1().colHullY.x -= overlap;
                }
                if (!f2 && overlap != 0.0f) {
                    if (p1hn2) {
                        obj2Hull.x += overlap;
                        obj2Hull.width -= overlap;
                    } else {
                        obj2Hull.width += overlap;
                    }
                    e.Object2().colHullY.x += overlap;
                }
                obj2Hull.x -= ox2;
                obj2Hull.y -= oy2;
                ++i2;
            }
            obj1Hull.x -= ox1;
            obj1Hull.y -= oy1;
            ++i1;
        }
        return hit;
    }

    public static boolean solveYCollision(Object sender, FlxSpriteCollisionEvent e) {
        boolean p1hn2;
        float o1 = e.Object1().colVector.Y;
        float o2 = e.Object2().colVector.Y;
        if (o1 == o2) {
            return false;
        }
        e.Object1().preCollide(e.Object2());
        e.Object2().preCollide(e.Object1());
        boolean hit = false;
        boolean obj1Stopped = o1 == 0.0f;
        boolean obj1MoveNeg = o1 < 0.0f;
        boolean obj1MovePos = o1 > 0.0f;
        boolean obj2Stopped = o2 == 0.0f;
        boolean obj2MoveNeg = o2 < 0.0f;
        boolean obj2MovePos = o2 > 0.0f;
        FlxRect obj1Hull = e.Object1().colHullY;
        FlxRect obj2Hull = e.Object2().colHullY;
        ArrayList<Vector2> co1 = e.Object1().colOffsets;
        ArrayList<Vector2> co2 = e.Object2().colOffsets;
        int l1 = co1.size();
        int l2 = co2.size();
        boolean bl = !(obj1Stopped && obj2MoveNeg || obj1MovePos && obj2Stopped || obj1MovePos && obj2MoveNeg || obj1MoveNeg && obj2MoveNeg && (o1 > 0.0f ? o1 : -o1) < (o2 > 0.0f ? o2 : -o2) || obj1MovePos && obj2MovePos && (o1 > 0.0f ? o1 : -o1) > (o2 > 0.0f ? o2 : -o2)) ? false : (p1hn2 = true);
        if (p1hn2 ? !e.Object1().collideBottom || !e.Object2().collideTop : !e.Object1().collideTop || !e.Object2().collideBottom) {
            return false;
        }
        int i1 = 0;
        while (i1 < l1) {
            float ox1 = co1.get((int)i1).X;
            float oy1 = co1.get((int)i1).Y;
            obj1Hull.x += ox1;
            obj1Hull.y += oy1;
            int i2 = 0;
            while (i2 < l2) {
                boolean f2;
                boolean f1;
                float overlap;
                float oy2;
                float ox2;
                block36: {
                    block35: {
                        float r2;
                        float r1;
                        ox2 = co2.get((int)i2).X;
                        oy2 = co2.get((int)i2).Y;
                        obj2Hull.x += ox2;
                        obj2Hull.y += oy2;
                        tmp11 = (double)obj1Hull.x + (double)obj1Hull.width;
                        tmp12 = (double)obj2Hull.x + roundingErrorTestDouble;
                        tmp21 = (double)obj1Hull.x + roundingErrorTestDouble;
                        tmp22 = (double)obj2Hull.x + (double)obj2Hull.width;
                        tmp31 = (double)obj1Hull.y + (double)obj1Hull.height;
                        tmp32 = (double)obj2Hull.y + roundingErrorTestDouble;
                        tmp41 = (double)obj1Hull.y + roundingErrorTestDouble;
                        tmp42 = (double)obj2Hull.y + (double)obj2Hull.height;
                        if (tmp11 < tmp12 || tmp21 > tmp22 || tmp31 < tmp32 || tmp41 > tmp42) {
                            obj2Hull.x -= ox2;
                            obj2Hull.y -= oy2;
                            ++i2;
                            continue;
                        }
                        if (p1hn2) {
                            r1 = obj1MoveNeg ? obj1Hull.y + e.Object1().colHullX.height : obj1Hull.y + obj1Hull.height;
                            r2 = obj2MoveNeg ? obj2Hull.y : obj2Hull.y + obj2Hull.height - e.Object2().colHullX.height;
                        } else {
                            r1 = obj2MoveNeg ? -obj2Hull.y - e.Object2().colHullX.height : -obj2Hull.y - obj2Hull.height;
                            r2 = obj1MoveNeg ? -obj1Hull.y : -obj1Hull.y - obj1Hull.height + e.Object1().colHullX.height;
                        }
                        overlap = r1 - r2;
                        f1 = e.Object1().fixed;
                        f2 = e.Object2().fixed;
                        if (f1 && f2) {
                            f1 &= e.Object1().colVector.X == 0.0f && o1 == 0.0f;
                            f2 &= e.Object2().colVector.X == 0.0f && o2 == 0.0f;
                        }
                        if (overlap == 0.0f || !f1 && (double)(overlap > 0.0f ? overlap : -overlap) > (double)obj1Hull.height * 0.8) break block35;
                        if (f2) break block36;
                        float f = overlap > 0.0f ? overlap : -overlap;
                        if (!((double)f > (double)obj2Hull.height * 0.8)) break block36;
                    }
                    obj2Hull.x -= ox2;
                    obj2Hull.y -= oy2;
                    ++i2;
                    continue;
                }
                hit = true;
                float sv1 = e.Object2().velocity.Y;
                float sv2 = e.Object1().velocity.Y;
                if (!f1 && f2) {
                    if (e.Object1()._group) {
                        e.Object1().reset(e.Object1().x, e.Object1().y - overlap);
                    } else {
                        e.Object1().y -= overlap;
                    }
                } else if (f1 && !f2) {
                    if (e.Object2()._group) {
                        e.Object2().reset(e.Object2().x, e.Object2().y + overlap);
                    } else {
                        e.Object2().y += overlap;
                    }
                } else if (!f1 && !f2) {
                    overlap /= 2.0f;
                    if (e.Object1()._group) {
                        e.Object1().reset(e.Object1().x, e.Object1().y - overlap);
                    } else {
                        e.Object1().y -= overlap;
                    }
                    if (e.Object2()._group) {
                        e.Object2().reset(e.Object2().x, e.Object2().y + overlap);
                    } else {
                        e.Object2().y += overlap;
                    }
                    sv1 *= 0.5f;
                    sv2 *= 0.5f;
                }
                if (p1hn2) {
                    e.Object1().hitBottom(e.Object2(), sv1);
                    e.Object2().hitTop(e.Object1(), sv2);
                } else {
                    e.Object1().hitTop(e.Object2(), sv1);
                    e.Object2().hitBottom(e.Object1(), sv2);
                }
                if (!f1 && overlap != 0.0f) {
                    if (p1hn2) {
                        obj1Hull.y -= overlap;
                        if (f2 && e.Object2().moves) {
                            sv1 = e.Object2().colVector.X;
                            e.Object1().x += sv1;
                            obj1Hull.x += sv1;
                            e.Object1().colHullX.x += sv1;
                        }
                    } else {
                        obj1Hull.y -= overlap;
                        obj1Hull.height += overlap;
                    }
                }
                if (!f2 && overlap != 0.0f) {
                    if (p1hn2) {
                        obj2Hull.y += overlap;
                        obj2Hull.height -= overlap;
                    } else {
                        obj2Hull.height += overlap;
                        if (f1 && e.Object1().moves) {
                            sv2 = e.Object1().colVector.X;
                            e.Object2().x += sv2;
                            obj2Hull.x += sv2;
                            e.Object2().colHullX.x += sv2;
                        }
                    }
                }
                obj2Hull.x -= ox2;
                obj2Hull.y -= oy2;
                ++i2;
            }
            obj1Hull.x -= ox1;
            obj1Hull.y -= oy1;
            ++i1;
        }
        return hit;
    }

    public static Vector2 getScreenXY(float _x, float _y, FlxGroup _projectionFromGroup) {
        Vector2 Point2 = Vector2.Zero();
        Point2.X = FlxU.floor(_x + roundingError) + FlxU.floor(FlxG.scroll.X * _projectionFromGroup.scrollFactor.X);
        Point2.Y = FlxU.floor(_y + roundingError) + FlxU.floor(FlxG.scroll.Y * _projectionFromGroup.scrollFactor.Y);
        return Point2;
    }

    public static float getScreenX(float _x, FlxGroup _projectionFromGroup) {
        return FlxU.floor(_x + roundingError) + FlxU.floor(FlxG.scroll.X * _projectionFromGroup.scrollFactor.X);
    }
}

