/*
 * Decompiled with CFR 0.152.
 */
package org.flixel.data;

import Microsoft.Xna.Framework.Color;
import Microsoft.Xna.Framework.Graphics.SpriteBatch;
import Microsoft.Xna.Framework.Rectangle;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxText;
import precompiler.MACRO;

public class FlxConsole {
    private int MAX_CONSOLE_LINES = 256;
    public boolean visible = false;
    private Rectangle _srcRect = new Rectangle(1, 1, 1, 1);
    private Rectangle _consoleRect;
    private Color _consoleColor;
    private FlxText _consoleText;
    private FlxText _consoleFPS;
    private int[] _FPS = new int[8];
    private int _curFPS;
    private ArrayList<String> _consoleLines;
    private float _consoleY;
    private float _consoleYT;
    private boolean _fpsUpdate;

    public Color color() {
        return this._consoleColor;
    }

    public FlxConsole(int targetLeft, int targetWidth) {
        this._consoleRect = new Rectangle(0, 0, FlxG.spriteBatch.GraphicsDevice.Viewport().Width, FlxG.spriteBatch.GraphicsDevice.Viewport().Height);
        this._consoleColor = new Color(0, 0, 0, 127);
        this._consoleText = new FlxText((float)targetLeft, -800.0f, (float)targetWidth, "").setFormat(null, 1.0f, Color.White(), FlxText.FlxJustification.Left, Color.White());
        this._consoleText.height = FlxG.height;
        this._consoleFPS = new FlxText((float)(targetLeft + targetWidth - 30), -800.0f, 30.0f, "").setFormat(null, 1.0f, Color.White(), FlxText.FlxJustification.Right, Color.White());
        this._consoleLines = new ArrayList();
        this.MAX_CONSOLE_LINES = FlxG.spriteBatch.GraphicsDevice.Viewport().Height / (int)this._consoleText.font().MeasureString((String)"Qq").Y - 1;
    }

    public void log(String Data) {
        if (MACRO.DEBUG) {
            if (Data == null) {
                Data = "ERROR: NULL GAME LOG MESSAGE";
            }
            this._consoleLines.add(String.valueOf(FlxG.FrameId) + ": " + Data);
            if (this._consoleLines.size() > this.MAX_CONSOLE_LINES) {
                this._consoleLines.remove(0);
                String newText = "";
                int i = 0;
                while (i < this._consoleLines.size()) {
                    newText = String.valueOf(newText) + this._consoleLines.get(i) + "\n";
                    ++i;
                }
                this._consoleText.text(newText);
            } else {
                this._consoleText.text().concat(String.valueOf(FlxG.FrameId) + ": " + Data + "\n");
            }
        }
    }

    public void toggle() {
        if (this._consoleYT == (float)FlxG.spriteBatch.GraphicsDevice.Viewport().Height) {
            this._consoleYT = 0.0f;
        } else {
            this._consoleYT = FlxG.spriteBatch.GraphicsDevice.Viewport().Height;
            this.visible = true;
        }
    }

    public void update() {
        if (this.visible) {
            this._consoleFPS.y = this._consoleText.y = (float)(-FlxG.spriteBatch.GraphicsDevice.Viewport().Height + this._consoleRect.Height + 8);
        }
        if (this._consoleY < this._consoleYT) {
            this._consoleY += (float)(FlxG.height * 10) * FlxG.elapsed;
        } else if (this._consoleY > this._consoleYT) {
            this._consoleY -= (float)(FlxG.height * 10) * FlxG.elapsed;
        }
        if (this._consoleY > (float)FlxG.spriteBatch.GraphicsDevice.Viewport().Height) {
            this._consoleY = FlxG.spriteBatch.GraphicsDevice.Viewport().Height;
        } else if (this._consoleY < 0.0f) {
            this._consoleY = 0.0f;
            this.visible = false;
        }
        this._consoleRect.Height = (int)Math.floor(this._consoleY);
    }

    public void render(SpriteBatch spriteBatch) {
        this._FPS[this._curFPS] = (int)(1.0f / FlxG.elapsed);
        if (++this._curFPS >= this._FPS.length) {
            this._curFPS = 0;
        }
        boolean bl = this._fpsUpdate = !this._fpsUpdate;
        if (this._fpsUpdate) {
            int fps = 0;
            int i = 0;
            while (i < this._FPS.length) {
                fps += this._FPS[i];
                ++i;
            }
            this._consoleFPS.text(String.valueOf(Integer.toString((int)Math.floor(fps / this._FPS.length))) + " fps");
        }
        spriteBatch.Draw(FlxG.GetXnaSheet(), this._consoleRect, this._srcRect, this._consoleColor);
        this._consoleText.render(spriteBatch);
        this._consoleFPS.render(spriteBatch);
    }
}

