/*
 * Decompiled with CFR 0.152.
 */
package org.flixel.data;

import Microsoft.Xna.Framework.Input.Buttons;
import Microsoft.Xna.Framework.Input.GamePad;
import Microsoft.Xna.Framework.Input.GamePadState;
import Microsoft.Xna.Framework.PlayerIndex;
import SSS.Util.Utility;
import org.flixel.FlxG;
import org.lwjgl.input.Controllers;

public class FlxGamepad {
    private PlayerIndex pi;
    public final int MaxInputs = 4;
    protected PlayerIndex[] InputIdToEnum = new PlayerIndex[]{PlayerIndex.One, PlayerIndex.Two, PlayerIndex.Three, PlayerIndex.Four};
    public boolean[] GamePadWasConnected;
    private GamePadState[] _curGamepad = new GamePadState[4];
    private GamePadState[] _lastGamepad = new GamePadState[4];
    private boolean _curGamepadConnectedFlag;
    private boolean _lastGamepadConnectedFlag;
    protected static boolean GamepadConnectedFlagMask = true;
    protected boolean _curGuide = false;
    protected boolean _lastGuide = false;
    private final float REPEAT_TIMER_LONG = 0.5f;
    private final float REPEAT_TIMER = 0.1f;
    private float _timerCountDown = 0.0f;
    static PlayerIndex[] PlayerIndexes = new PlayerIndex[]{PlayerIndex.One, PlayerIndex.Two, PlayerIndex.Three, PlayerIndex.Four};

    public static void GamepadConnectedFlagMask(boolean value) {
        GamepadConnectedFlagMask = value;
    }

    public static boolean GamepadConnectedFlagMask() {
        return GamepadConnectedFlagMask;
    }

    public GamePadState[] curPadState() {
        return this._curGamepad;
    }

    public FlxGamepad() {
        this.GamePadWasConnected = new boolean[4];
        this._lastGamepadConnectedFlag = this._curGamepadConnectedFlag = this.isAnyGamepadConnected();
    }

    public void update() {
        if (this._timerCountDown > 0.0f) {
            this._timerCountDown -= FlxG.elapsed;
        }
        int i = 0;
        while (i < 4) {
            this._lastGamepad[i] = this._curGamepad[i];
            this._curGamepad[i] = GamePad.GetState(this.InputIdToEnum[i], FlxG.FrameId);
            if (this._curGamepad[i].IsConnected()) {
                this.GamePadWasConnected[i] = true;
            }
            ++i;
        }
        this._lastGuide = this._curGuide;
        this._curGuide = Utility.GuideIsVisible();
        this._lastGamepadConnectedFlag = this._curGamepadConnectedFlag;
        this._curGamepadConnectedFlag = this.isAnyGamepadConnected();
        if (Controllers.isCreated() && Controllers.getControllerCount() > 0) {
            Controllers.poll();
        }
    }

    public boolean isNewGuidePress() {
        return !this._lastGuide && this._curGuide;
    }

    public boolean isNewButtonPress(Buttons button) {
        return this.isNewButtonPress(button, FlxG.controllingPlayer(), this.pi);
    }

    public boolean isNewButtonPress(Buttons button, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            return this._curGamepad[i].IsButtonDown(button) && this._lastGamepad[i].IsButtonUp(button);
        }
        return this.isNewButtonPress(button, PlayerIndex.One, playerIndex) || this.isNewButtonPress(button, PlayerIndex.Two, playerIndex) || this.isNewButtonPress(button, PlayerIndex.Three, playerIndex) || this.isNewButtonPress(button, PlayerIndex.Four, playerIndex);
    }

    public boolean isNewGamepadConnected() {
        return this._curGamepadConnectedFlag && !this._lastGamepadConnectedFlag;
    }

    public boolean isNewGamepadDisconnected() {
        return !this._curGamepadConnectedFlag && this._lastGamepadConnectedFlag;
    }

    public boolean isGamepadConnected() {
        return GamepadConnectedFlagMask && this._curGamepadConnectedFlag;
    }

    public boolean isNewButtonRelease(Buttons button) {
        return this.isNewButtonRelease(button, FlxG.controllingPlayer(), this.pi);
    }

    public boolean isNewButtonRelease(Buttons button, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            return this._curGamepad[i].IsButtonUp(button) && this._lastGamepad[i].IsButtonDown(button);
        }
        return this.isNewButtonRelease(button, PlayerIndex.One, playerIndex) || this.isNewButtonRelease(button, PlayerIndex.Two, playerIndex) || this.isNewButtonRelease(button, PlayerIndex.Three, playerIndex) || this.isNewButtonRelease(button, PlayerIndex.Four, playerIndex);
    }

    public boolean isButtonDown(Buttons button) {
        return this.isButtonDown(button, FlxG.controllingPlayer(), this.pi);
    }

    public boolean isButtonDown(Buttons button, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            if (button == Buttons.LeftThumbstickLeft) {
                return this._curGamepad[i].ThumbSticks().Left().X < -FlxG.ThumbStickDeadThreashold;
            }
            if (button == Buttons.LeftThumbstickRight) {
                return this._curGamepad[i].ThumbSticks().Left().X > FlxG.ThumbStickDeadThreashold;
            }
            if (button == Buttons.LeftThumbstickUp) {
                return this._curGamepad[i].ThumbSticks().Left().Y > FlxG.ThumbStickDeadThreashold;
            }
            if (button == Buttons.LeftThumbstickDown) {
                return this._curGamepad[i].ThumbSticks().Left().Y < -FlxG.ThumbStickDeadThreashold;
            }
            return this._curGamepad[i].IsButtonDown(button);
        }
        return this.isButtonDown(button, PlayerIndex.One, playerIndex) || this.isButtonDown(button, PlayerIndex.Two, playerIndex) || this.isButtonDown(button, PlayerIndex.Three, playerIndex) || this.isButtonDown(button, PlayerIndex.Four, playerIndex);
    }

    public float getAnalogButtonValue(Buttons button, PlayerIndex controllingPlayer) {
        if (controllingPlayer != null) {
            int i = controllingPlayer.ordinal();
            if (button == Buttons.LeftThumbstickLeft) {
                return this._curGamepad[i].ThumbSticks().Left().X;
            }
            if (button == Buttons.LeftThumbstickRight) {
                return this._curGamepad[i].ThumbSticks().Left().X;
            }
            if (button == Buttons.LeftThumbstickUp) {
                return this._curGamepad[i].ThumbSticks().Left().Y;
            }
            if (button == Buttons.LeftThumbstickDown) {
                return this._curGamepad[i].ThumbSticks().Left().Y;
            }
        }
        return 0.0f;
    }

    public void reset() {
        int i = 0;
        while (i < 4) {
            this._curGamepad[i] = this._lastGamepad[i];
            ++i;
        }
    }

    public boolean isMenuSelect(PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        return this.isNewButtonPress(Buttons.A, controllingPlayer, playerIndex) || this.isNewButtonPress(Buttons.Start, controllingPlayer, playerIndex);
    }

    public boolean isMenuCancel(PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        return this.isNewButtonPress(Buttons.B, controllingPlayer, playerIndex) || this.isNewButtonPress(Buttons.Back, controllingPlayer, playerIndex);
    }

    public boolean isMenuUp(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = PlayerIndex.One;
        if (this.isNewButtonPress(Buttons.DPadUp, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        if (this.isNewButtonPress(Buttons.LeftThumbstickUp, controllingPlayer, playerIndex)) {
            GamePadState gamePadState = this._curGamepad[playerIndex.ordinal()];
            if ((double)gamePadState.ThumbSticks().Left().Y > 0.25) {
                this._timerCountDown = 0.5f;
                return true;
            }
            this.reset();
        }
        GamePadState repeatPadState = this._curGamepad[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && ((double)repeatPadState.ThumbSticks().Left().Y > 0.25 || repeatPadState.IsButtonDown(Buttons.DPadUp))) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuDown(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = PlayerIndex.One;
        if (this.isNewButtonPress(Buttons.DPadDown, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        if (this.isNewButtonPress(Buttons.LeftThumbstickDown, controllingPlayer, playerIndex)) {
            GamePadState gamePadState = this._curGamepad[playerIndex.ordinal()];
            if ((double)gamePadState.ThumbSticks().Left().Y < -0.25) {
                this._timerCountDown = 0.5f;
                return true;
            }
            this.reset();
        }
        GamePadState repeatPadState = this._curGamepad[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && ((double)repeatPadState.ThumbSticks().Left().Y < -0.25 || repeatPadState.IsButtonDown(Buttons.DPadDown))) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuLeft(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = PlayerIndex.One;
        if (this.isNewButtonPress(Buttons.DPadLeft, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        if (this.isNewButtonPress(Buttons.LeftThumbstickLeft, controllingPlayer, playerIndex)) {
            GamePadState gamePadState = this._curGamepad[playerIndex.ordinal()];
            if ((double)gamePadState.ThumbSticks().Left().X < -0.25) {
                this._timerCountDown = 0.5f;
                return true;
            }
            this.reset();
        }
        GamePadState repeatPadState = this._curGamepad[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && ((double)repeatPadState.ThumbSticks().Left().X < -0.25 || repeatPadState.IsButtonDown(Buttons.DPadLeft))) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuRight(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = PlayerIndex.One;
        if (this.isNewButtonPress(Buttons.DPadRight, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        if (this.isNewButtonPress(Buttons.LeftThumbstickRight, controllingPlayer, playerIndex)) {
            GamePadState gamePadState = this._curGamepad[playerIndex.ordinal()];
            if ((double)gamePadState.ThumbSticks().Left().X > 0.25) {
                this._timerCountDown = 0.5f;
                return true;
            }
            this.reset();
        }
        GamePadState repeatPadState = this._curGamepad[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && ((double)repeatPadState.ThumbSticks().Left().X > 0.25 || repeatPadState.IsButtonDown(Buttons.DPadRight))) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isPauseGame(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = PlayerIndex.One;
        return this.isNewButtonPress(Buttons.Start, controllingPlayer, playerIndex);
    }

    public boolean isNewThumbstickLeft(PlayerIndex controllingPlayer) {
        PlayerIndex pi = PlayerIndex.One;
        return this.isButtonDown(Buttons.LeftThumbstickLeft, controllingPlayer, pi) && (double)this._curGamepad[pi.ordinal()].ThumbSticks().Left().X < -0.25 && (double)this._lastGamepad[pi.ordinal()].ThumbSticks().Left().X >= -0.25;
    }

    public boolean isNewThumbstickRight(PlayerIndex controllingPlayer) {
        PlayerIndex pi = PlayerIndex.One;
        return this.isButtonDown(Buttons.LeftThumbstickRight, controllingPlayer, pi) && (double)this._curGamepad[pi.ordinal()].ThumbSticks().Left().X > 0.25 && (double)this._lastGamepad[pi.ordinal()].ThumbSticks().Left().X <= 0.25;
    }

    public boolean isNewThumbstickUp(PlayerIndex controllingPlayer) {
        PlayerIndex pi = PlayerIndex.One;
        return this.isButtonDown(Buttons.LeftThumbstickUp, controllingPlayer, pi) && (double)this._curGamepad[pi.ordinal()].ThumbSticks().Left().Y > 0.25 && (double)this._lastGamepad[pi.ordinal()].ThumbSticks().Left().Y <= 0.25;
    }

    public boolean isNewThumbstickDown(PlayerIndex controllingPlayer) {
        PlayerIndex pi = PlayerIndex.One;
        return this.isButtonDown(Buttons.LeftThumbstickDown, controllingPlayer, pi) && (double)this._curGamepad[pi.ordinal()].ThumbSticks().Left().Y < -0.25 && (double)this._lastGamepad[pi.ordinal()].ThumbSticks().Left().Y >= -0.25;
    }

    protected boolean isAnyGamepadConnected() {
        int i = 0;
        while (i < PlayerIndexes.length) {
            GamePadState gs = this._curGamepad[i];
            if (gs != null && gs.IsConnected()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

