/*
 * Decompiled with CFR 0.152.
 */
package org.flixel.data;

import Microsoft.Xna.Framework.Input.Keyboard;
import Microsoft.Xna.Framework.Input.KeyboardState;
import Microsoft.Xna.Framework.Input.Keys;
import Microsoft.Xna.Framework.PlayerIndex;
import org.flixel.FlxG;

public class FlxKeyboard {
    private PlayerIndex pi;
    public static final int MaxInputs = 1;
    protected PlayerIndex[] InputIdToEnum = new PlayerIndex[]{PlayerIndex.One, PlayerIndex.Two, PlayerIndex.Three, PlayerIndex.Four};
    private KeyboardState[] _curKeyboard;
    private KeyboardState[] _lastKeyboard;
    private static final float REPEAT_TIMER_LONG = 0.5f;
    private static final float REPEAT_TIMER = 0.1f;
    private float _timerCountDown = 0.0f;
    PlayerIndex defaultJavaKeyboardIndex = PlayerIndex.One;
    PlayerIndex playerIndexDefault = PlayerIndex.One;

    public boolean ESCAPE() {
        return this.isKeyDown(Keys.Escape, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F1() {
        return this.isKeyDown(Keys.F1, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F2() {
        return this.isKeyDown(Keys.F2, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F3() {
        return this.isKeyDown(Keys.F3, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F4() {
        return this.isKeyDown(Keys.F4, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F5() {
        return this.isKeyDown(Keys.F5, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F6() {
        return this.isKeyDown(Keys.F6, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F7() {
        return this.isKeyDown(Keys.F7, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F8() {
        return this.isKeyDown(Keys.F8, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F9() {
        return this.isKeyDown(Keys.F9, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F10() {
        return this.isKeyDown(Keys.F10, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F11() {
        return this.isKeyDown(Keys.F11, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F12() {
        return this.isKeyDown(Keys.F12, FlxG.controllingPlayer(), this.pi);
    }

    public boolean ONE() {
        return this.isKeyDown(Keys.D1, FlxG.controllingPlayer(), this.pi);
    }

    public boolean TWO() {
        return this.isKeyDown(Keys.D2, FlxG.controllingPlayer(), this.pi);
    }

    public boolean THREE() {
        return this.isKeyDown(Keys.D3, FlxG.controllingPlayer(), this.pi);
    }

    public boolean FOUR() {
        return this.isKeyDown(Keys.D4, FlxG.controllingPlayer(), this.pi);
    }

    public boolean FIVE() {
        return this.isKeyDown(Keys.D5, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SIX() {
        return this.isKeyDown(Keys.D6, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SEVEN() {
        return this.isKeyDown(Keys.D7, FlxG.controllingPlayer(), this.pi);
    }

    public boolean EIGHT() {
        return this.isKeyDown(Keys.D8, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NINE() {
        return this.isKeyDown(Keys.D9, FlxG.controllingPlayer(), this.pi);
    }

    public boolean ZERO() {
        return this.isKeyDown(Keys.D0, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADONE() {
        return this.isKeyDown(Keys.NumPad1, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADTWO() {
        return this.isKeyDown(Keys.NumPad2, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADTHREE() {
        return this.isKeyDown(Keys.NumPad3, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADFOUR() {
        return this.isKeyDown(Keys.NumPad4, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADFIVE() {
        return this.isKeyDown(Keys.NumPad5, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADSIX() {
        return this.isKeyDown(Keys.NumPad6, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADSEVEN() {
        return this.isKeyDown(Keys.NumPad7, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADEIGHT() {
        return this.isKeyDown(Keys.NumPad8, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADNINE() {
        return this.isKeyDown(Keys.NumPad9, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADZERO() {
        return this.isKeyDown(Keys.NumPad0, FlxG.controllingPlayer(), this.pi);
    }

    public boolean MINUS() {
        return this.isKeyDown(Keys.OemMinus, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADMINUS() {
        return this.isKeyDown(Keys.OemMinus, FlxG.controllingPlayer(), this.pi);
    }

    public boolean PLUS() {
        return this.isKeyDown(Keys.OemPlus, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADPLUS() {
        return this.isKeyDown(Keys.OemPlus, FlxG.controllingPlayer(), this.pi);
    }

    public boolean DELETE() {
        return this.isKeyDown(Keys.Delete, FlxG.controllingPlayer(), this.pi);
    }

    public boolean BACKSPACE() {
        return this.isKeyDown(Keys.Back, FlxG.controllingPlayer(), this.pi);
    }

    public boolean Q() {
        return this.isKeyDown(Keys.Q, FlxG.controllingPlayer(), this.pi);
    }

    public boolean W() {
        return this.isKeyDown(Keys.W, FlxG.controllingPlayer(), this.pi);
    }

    public boolean E() {
        return this.isKeyDown(Keys.E, FlxG.controllingPlayer(), this.pi);
    }

    public boolean R() {
        return this.isKeyDown(Keys.R, FlxG.controllingPlayer(), this.pi);
    }

    public boolean T() {
        return this.isKeyDown(Keys.T, FlxG.controllingPlayer(), this.pi);
    }

    public boolean Y() {
        return this.isKeyDown(Keys.Y, FlxG.controllingPlayer(), this.pi);
    }

    public boolean U() {
        return this.isKeyDown(Keys.U, FlxG.controllingPlayer(), this.pi);
    }

    public boolean I() {
        return this.isKeyDown(Keys.I, FlxG.controllingPlayer(), this.pi);
    }

    public boolean O() {
        return this.isKeyDown(Keys.O, FlxG.controllingPlayer(), this.pi);
    }

    public boolean P() {
        return this.isKeyDown(Keys.P, FlxG.controllingPlayer(), this.pi);
    }

    public boolean LBRACKET() {
        return this.isKeyDown(Keys.OemOpenBrackets, FlxG.controllingPlayer(), this.pi);
    }

    public boolean RBRACKET() {
        return this.isKeyDown(Keys.OemCloseBrackets, FlxG.controllingPlayer(), this.pi);
    }

    public boolean BACKSLASH() {
        return this.isKeyDown(Keys.OemBackslash, FlxG.controllingPlayer(), this.pi);
    }

    public boolean CAPSLOCK() {
        return this.isKeyDown(Keys.CapsLock, FlxG.controllingPlayer(), this.pi);
    }

    public boolean A() {
        return this.isKeyDown(Keys.A, FlxG.controllingPlayer(), this.pi);
    }

    public boolean S() {
        return this.isKeyDown(Keys.S, FlxG.controllingPlayer(), this.pi);
    }

    public boolean D() {
        return this.isKeyDown(Keys.D, FlxG.controllingPlayer(), this.pi);
    }

    public boolean F() {
        return this.isKeyDown(Keys.F, FlxG.controllingPlayer(), this.pi);
    }

    public boolean G() {
        return this.isKeyDown(Keys.G, FlxG.controllingPlayer(), this.pi);
    }

    public boolean H() {
        return this.isKeyDown(Keys.H, FlxG.controllingPlayer(), this.pi);
    }

    public boolean J() {
        return this.isKeyDown(Keys.J, FlxG.controllingPlayer(), this.pi);
    }

    public boolean K() {
        return this.isKeyDown(Keys.K, FlxG.controllingPlayer(), this.pi);
    }

    public boolean L() {
        return this.isKeyDown(Keys.L, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SEMICOLON() {
        return this.isKeyDown(Keys.OemSemicolon, FlxG.controllingPlayer(), this.pi);
    }

    public boolean QUOTE() {
        return this.isKeyDown(Keys.OemQuotes, FlxG.controllingPlayer(), this.pi);
    }

    public boolean ENTER() {
        return this.isKeyDown(Keys.Enter, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SHIFT() {
        return this.isKeyDown(Keys.LeftShift, FlxG.controllingPlayer(), this.pi) || this.isKeyDown(Keys.RightShift, FlxG.controllingPlayer(), this.pi);
    }

    public boolean Z() {
        return this.isKeyDown(Keys.Z, FlxG.controllingPlayer(), this.pi);
    }

    public boolean X() {
        return this.isKeyDown(Keys.X, FlxG.controllingPlayer(), this.pi);
    }

    public boolean C() {
        return this.isKeyDown(Keys.C, FlxG.controllingPlayer(), this.pi);
    }

    public boolean V() {
        return this.isKeyDown(Keys.V, FlxG.controllingPlayer(), this.pi);
    }

    public boolean B() {
        return this.isKeyDown(Keys.B, FlxG.controllingPlayer(), this.pi);
    }

    public boolean N() {
        return this.isKeyDown(Keys.N, FlxG.controllingPlayer(), this.pi);
    }

    public boolean M() {
        return this.isKeyDown(Keys.M, FlxG.controllingPlayer(), this.pi);
    }

    public boolean COMMA() {
        return this.isKeyDown(Keys.OemComma, FlxG.controllingPlayer(), this.pi);
    }

    public boolean PERIOD() {
        return this.isKeyDown(Keys.OemPeriod, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADPERIOD() {
        return this.isKeyDown(Keys.OemPeriod, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SLASH() {
        return this.isKeyDown(Keys.Divide, FlxG.controllingPlayer(), this.pi);
    }

    public boolean NUMPADSLASH() {
        return this.isKeyDown(Keys.Divide, FlxG.controllingPlayer(), this.pi);
    }

    public boolean CONTROL() {
        return this.isKeyDown(Keys.LeftControl, FlxG.controllingPlayer(), this.pi) || this.isKeyDown(Keys.RightControl, FlxG.controllingPlayer(), this.pi);
    }

    public boolean ALT() {
        return this.isKeyDown(Keys.LeftAlt, FlxG.controllingPlayer(), this.pi) || this.isKeyDown(Keys.RightAlt, FlxG.controllingPlayer(), this.pi);
    }

    public boolean SPACE() {
        return this.isKeyDown(Keys.Space, FlxG.controllingPlayer(), this.pi);
    }

    public boolean UP() {
        return this.isKeyDown(Keys.Up, FlxG.controllingPlayer(), this.pi);
    }

    public boolean DOWN() {
        return this.isKeyDown(Keys.Down, FlxG.controllingPlayer(), this.pi);
    }

    public boolean LEFT() {
        return this.isKeyDown(Keys.Left, FlxG.controllingPlayer(), this.pi);
    }

    public boolean RIGHT() {
        return this.isKeyDown(Keys.Right, FlxG.controllingPlayer(), this.pi);
    }

    public boolean justPressed(Keys key) {
        return this.isNewKeyPress(key, FlxG.controllingPlayer(), this.pi);
    }

    public KeyboardState[] curKeyState() {
        return this._curKeyboard;
    }

    public FlxKeyboard() {
        this._curKeyboard = new KeyboardState[1];
        this._lastKeyboard = new KeyboardState[1];
    }

    public void update() {
        if (this._timerCountDown > 0.0f) {
            this._timerCountDown -= FlxG.elapsed;
        }
        int i = 0;
        while (i < 1) {
            this._lastKeyboard[i] = this._curKeyboard[i];
            this._curKeyboard[i] = Keyboard.GetState(this.InputIdToEnum[i], FlxG.FrameId);
            ++i;
        }
    }

    public boolean isNewKeyPress(Keys key, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        controllingPlayer = this.defaultJavaKeyboardIndex;
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            return this._curKeyboard[i].IsKeyDown(key) && this._lastKeyboard[i].IsKeyUp(key);
        }
        return this.isNewKeyPress(key, PlayerIndex.One, playerIndex) || this.isNewKeyPress(key, PlayerIndex.Two, playerIndex) || this.isNewKeyPress(key, PlayerIndex.Three, playerIndex) || this.isNewKeyPress(key, PlayerIndex.Four, playerIndex);
    }

    public boolean isNewKeyRelease(Keys key, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        controllingPlayer = this.defaultJavaKeyboardIndex;
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            return this._curKeyboard[i].IsKeyUp(key) && this._lastKeyboard[i].IsKeyDown(key);
        }
        return this.isNewKeyRelease(key, PlayerIndex.One, playerIndex) || this.isNewKeyRelease(key, PlayerIndex.Two, playerIndex) || this.isNewKeyRelease(key, PlayerIndex.Three, playerIndex) || this.isNewKeyRelease(key, PlayerIndex.Four, playerIndex);
    }

    public boolean isKeyDown(Keys key, PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        controllingPlayer = this.defaultJavaKeyboardIndex;
        if (controllingPlayer != null) {
            playerIndex = controllingPlayer;
            int i = playerIndex.ordinal();
            return this._curKeyboard[i].IsKeyDown(key);
        }
        return this.isKeyDown(key, PlayerIndex.One, playerIndex) || this.isKeyDown(key, PlayerIndex.Two, playerIndex) || this.isKeyDown(key, PlayerIndex.Three, playerIndex) || this.isKeyDown(key, PlayerIndex.Four, playerIndex);
    }

    public void reset() {
        int i = 0;
        while (i < 1) {
            this._curKeyboard[i] = this._lastKeyboard[i];
            ++i;
        }
    }

    public boolean isMenuSelect(PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        return this.isNewKeyPress(Keys.Space, controllingPlayer, playerIndex) || this.isNewKeyPress(Keys.Enter, controllingPlayer, playerIndex);
    }

    public boolean isMenuCancel(PlayerIndex controllingPlayer, PlayerIndex playerIndex) {
        return this.isNewKeyPress(Keys.Escape, controllingPlayer, playerIndex);
    }

    public boolean isMenuUp(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = this.playerIndexDefault;
        if (this.isNewKeyPress(Keys.Up, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        KeyboardState repeatKybdState = this._curKeyboard[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && repeatKybdState.IsKeyDown(Keys.Up)) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuDown(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = this.playerIndexDefault;
        if (this.isNewKeyPress(Keys.Down, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        KeyboardState repeatKybdState = this._curKeyboard[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && repeatKybdState.IsKeyDown(Keys.Down)) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuLeft(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = this.playerIndexDefault;
        if (this.isNewKeyPress(Keys.Left, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        KeyboardState repeatKybdState = this._curKeyboard[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && repeatKybdState.IsKeyDown(Keys.Left)) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isMenuRight(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = this.playerIndexDefault;
        if (this.isNewKeyPress(Keys.Right, controllingPlayer, playerIndex)) {
            this._timerCountDown = 0.5f;
            return true;
        }
        KeyboardState repeatKybdState = this._curKeyboard[playerIndex.ordinal()];
        if (this._timerCountDown <= 0.0f && repeatKybdState.IsKeyDown(Keys.Right)) {
            this._timerCountDown = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isPauseGame(PlayerIndex controllingPlayer) {
        PlayerIndex playerIndex = this.playerIndexDefault;
        return this.isNewKeyPress(Keys.P, controllingPlayer, playerIndex) || this.isNewKeyPress(Keys.Pause, controllingPlayer, playerIndex);
    }
}

