/*
 * Decompiled with CFR 0.152.
 */
package org.flixel.data;

import Microsoft.Xna.Framework.Graphics.Texture2D;
import Microsoft.Xna.Framework.Input.ButtonState;
import Microsoft.Xna.Framework.Input.Mouse;
import Microsoft.Xna.Framework.Input.MouseState;
import Microsoft.Xna.Framework.MathHelper;
import Microsoft.Xna.Framework.Vector2;
import SSS.Events.CallbackSimple;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.flixel.FlxG;
import org.flixel.FlxSprite;
import org.flixel.MouseEventType;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;

public class FlxMouse {
    private Texture2D ImgDefaultCursor;
    private MouseState _curMouse = new MouseState();
    private MouseState _lastMouse = new MouseState();
    private ArrayList<CallbackSimple> _mouseEvent = new ArrayList();
    public int wheel;
    public int screenX = 0;
    public int screenY = 0;
    public FlxSprite cursor = new FlxSprite();
    float m_autohideTime = 1.0f;
    float m_unhideMinDistance = 5.0f;
    float m_timer = 0.0f;
    boolean m_bBuilt = false;
    int m_dx = 0;
    int m_dy = 0;
    float m_delta = 0.0f;
    float m_globalX = 0.0f;
    float m_globalY = 0.0f;
    float m_x = 0.0f;
    float m_y = 0.0f;
    Cursor m_blankCursor = null;
    Cursor m_nativeCursor = null;
    boolean m_bUsingNativeCursor = true;

    public void addMouseListener(CallbackSimple MouseEvent2) {
        this._mouseEvent.add(MouseEvent2);
    }

    public void removeMouseListener(CallbackSimple MouseEvent2) {
        this._mouseEvent.remove(MouseEvent2);
    }

    public float x() {
        return this.m_x;
    }

    public float y() {
        return this.m_y;
    }

    public FlxMouse() {
        this.cursor.visible = false;
        this.m_globalX = (float)FlxG.width * 0.5f;
        this.m_globalY = (float)FlxG.height * 0.5f;
    }

    public void testBuildMouse() {
        try {
            if (!org.lwjgl.input.Mouse.isCreated()) {
                org.lwjgl.input.Mouse.create();
            }
            this.m_nativeCursor = org.lwjgl.input.Mouse.getNativeCursor();
            int[] array = new int[256];
            this.m_blankCursor = new Cursor(16, 16, 0, 0, 1, IntBuffer.wrap(array), null);
            this.useBlankCursor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void useBlankCursor() {
        if (this.m_bUsingNativeCursor) {
            try {
                org.lwjgl.input.Mouse.setNativeCursor((Cursor)this.m_blankCursor);
                this.m_bUsingNativeCursor = false;
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
    }

    public void useNativeCursor() {
        if (!this.m_bUsingNativeCursor) {
            try {
                org.lwjgl.input.Mouse.setNativeCursor((Cursor)this.m_nativeCursor);
                this.m_bUsingNativeCursor = true;
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
    }

    public void show(Texture2D Graphic) {
        this.show(Graphic, 0, 0);
    }

    public void show(Texture2D Graphic, int XOffset, int YOffset) {
        if (Graphic != null) {
            this.load(Graphic, XOffset, YOffset);
        } else if (this.cursor != null) {
            this.cursor.visible = true;
        } else {
            this.load(null);
        }
    }

    public void show() {
        if (this.cursor != null) {
            this.cursor.visible = true;
        }
    }

    public void hide() {
        if (this.cursor != null) {
            this.cursor.visible = false;
        }
    }

    public void load(Texture2D Graphic) {
        this.load(Graphic, 0, 0);
    }

    public void load(Texture2D Graphic, int XOffset, int YOffset) {
        if (Graphic == null) {
            Graphic = this.ImgDefaultCursor;
        }
        this.cursor = new FlxSprite(this.screenX, this.screenY, Graphic);
        this.cursor.solid = false;
        this.cursor.offset.X = XOffset;
        this.cursor.offset.Y = YOffset;
        this.cursor.scrollFactor = Vector2.Zero();
        this.m_bBuilt = true;
    }

    public void unload() {
        if (this.cursor != null) {
            if (this.cursor.visible) {
                this.load(null);
            } else {
                this.cursor = null;
            }
        }
    }

    public void update() {
        block5: {
            block6: {
                this._lastMouse = this._curMouse;
                this._curMouse = Mouse.GetState(FlxG.FrameId);
                this._updateDelta();
                if (FlxG.GraphicDeviceManager.IsFullScreen()) {
                    int targetLeft = FlxG._game().targetLeft();
                    this.m_globalX -= (float)this.m_dx;
                    this.m_globalY += (float)this.m_dy;
                    this.m_globalX = MathHelper.Clamp(this.m_globalX, targetLeft, targetLeft + FlxG.width);
                    this.m_globalY = MathHelper.Clamp(this.m_globalY, 0.0f, FlxG.height);
                    this.m_x = (this.m_globalX - (float)targetLeft) / FlxG.scale();
                    this.m_y = this.m_globalY / FlxG.scale();
                } else {
                    float scalex = 1280.0f / (float)FlxG.GraphicDeviceManager.PreferredBackBufferWidth();
                    float scaley = 720.0f / (float)FlxG.GraphicDeviceManager.PreferredBackBufferHeight();
                    this.m_x = (float)this._curMouse.X() * scalex;
                    this.m_y = (float)FlxG.height - (float)this._curMouse.Y() * scaley;
                }
                this.cursor.x = this.x();
                this.cursor.y = this.y();
                this._checkVisible();
                if (!this.cursor.visible) {
                    return;
                }
                if (this._mouseEvent == null) break block5;
                if (!this.justPressed()) break block6;
                for (CallbackSimple cs : this._mouseEvent) {
                    cs.onCallback(this, (Object)MouseEventType.MouseDown);
                }
                break block5;
            }
            if (!this.justReleased()) break block5;
            for (CallbackSimple cs : this._mouseEvent) {
                cs.onCallback(this, (Object)MouseEventType.MouseUp);
            }
        }
    }

    void _updateDelta() {
        this.m_dx = this._lastMouse.X() - this._curMouse.X();
        this.m_dy = this._lastMouse.Y() - this._curMouse.Y();
        this.m_delta = this.m_dx * this.m_dx + this.m_dy * this.m_dy;
        this.m_delta *= this.m_delta;
    }

    void _checkVisible() {
        if (!this.m_bBuilt || this.cursor == null) {
            return;
        }
        if (this.cursor.visible) {
            if (this.m_delta <= 0.1f) {
                this.m_timer += FlxG.elapsed;
                if (this.m_timer > this.m_autohideTime) {
                    this.m_timer = 0.0f;
                    this.hide();
                }
            }
        } else if (this.m_delta > this.m_unhideMinDistance * this.m_unhideMinDistance) {
            this.show();
        }
    }

    public void reset() {
        this._curMouse = this._lastMouse;
        this._mouseEvent.clear();
    }

    public boolean pressed() {
        return this._curMouse.LeftButton() == ButtonState.Pressed || this._curMouse.RightButton() == ButtonState.Pressed;
    }

    public boolean leftPressed() {
        return this._curMouse.LeftButton() == ButtonState.Pressed;
    }

    public boolean rightPressed() {
        return this._curMouse.RightButton() == ButtonState.Pressed;
    }

    public boolean justPressed() {
        return this._curMouse.LeftButton() == ButtonState.Pressed && this._lastMouse.LeftButton() == ButtonState.Released || this._curMouse.RightButton() == ButtonState.Pressed && this._lastMouse.RightButton() == ButtonState.Released;
    }

    public boolean justReleased() {
        return this._curMouse.LeftButton() == ButtonState.Released && this._lastMouse.LeftButton() == ButtonState.Pressed || this._curMouse.RightButton() == ButtonState.Released && this._lastMouse.RightButton() == ButtonState.Pressed;
    }

    public boolean justMoved() {
        return (float)this.m_dx != 0.0f || (float)this.m_dy != 0.0f;
    }

    public boolean justLeftPressed() {
        return this._curMouse.LeftButton() == ButtonState.Pressed && this._lastMouse.LeftButton() == ButtonState.Released;
    }

    public boolean justRightPressed() {
        return this._curMouse.RightButton() == ButtonState.Pressed && this._lastMouse.RightButton() == ButtonState.Released;
    }

    public boolean justWheelUp() {
        return this._curMouse.ScrollWheelValue() > 0;
    }

    public boolean justWheelDown() {
        return this._curMouse.ScrollWheelValue() < 0;
    }

    public int deltaWheel() {
        return this._curMouse.ScrollWheelValue();
    }
}

