/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.input;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class TestControllers
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int total;
    private JTextField[] values;
    private JTextField[] names;
    private Controller controller;
    private int buttonCount;
    private int itemCount;

    public TestControllers(int index) {
        this.controller = Controllers.getController((int)index);
        this.controller.poll();
        this.setLayout(null);
        this.buttonCount = this.controller.getButtonCount();
        this.itemCount = this.controller.getButtonCount() + this.controller.getAxisCount() + 2;
        this.values = new JTextField[this.itemCount];
        this.names = new JTextField[this.itemCount];
        int i = 0;
        while (i < this.controller.getButtonCount()) {
            this.names[i] = new JTextField();
            this.names[i].setEditable(false);
            this.names[i].setBounds(0, i * 30, 100, 30);
            this.names[i].setText(this.controller.getButtonName(i));
            this.add(this.names[i]);
            this.values[i] = new JTextField();
            this.values[i].setEditable(false);
            this.values[i].setBounds(100, i * 30, 100, 30);
            this.add(this.values[i]);
            ++i;
        }
        i = this.buttonCount;
        while (i < this.buttonCount + this.controller.getAxisCount()) {
            this.names[i] = new JTextField();
            this.names[i].setEditable(false);
            this.names[i].setBounds(0, i * 30, 100, 30);
            this.names[i].setText(this.controller.getAxisName(i - this.buttonCount));
            this.add(this.names[i]);
            this.values[i] = new JTextField();
            this.values[i].setEditable(false);
            this.values[i].setBounds(100, i * 30, 100, 30);
            this.add(this.values[i]);
            ++i;
        }
        i = this.itemCount - 2;
        this.names[i] = new JTextField();
        this.names[i].setEditable(false);
        this.names[i].setBounds(0, i * 30, 100, 30);
        this.names[i].setText("POV X");
        this.add(this.names[i]);
        this.values[i] = new JTextField();
        this.values[i].setEditable(false);
        this.values[i].setBounds(100, i * 30, 100, 30);
        this.add(this.values[i]);
        i = this.itemCount - 1;
        this.names[i] = new JTextField();
        this.names[i].setEditable(false);
        this.names[i].setBounds(0, i * 30, 100, 30);
        this.names[i].setText("POV Y");
        this.add(this.names[i]);
        this.values[i] = new JTextField();
        this.values[i].setEditable(false);
        this.values[i].setBounds(100, i * 30, 100, 30);
        this.add(this.values[i]);
        ++total;
        this.setPreferredSize(new Dimension(200, 30 * this.itemCount));
        JFrame frame = new JFrame(this.controller.getName());
        frame.setContentPane(new JScrollPane(this));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (--total == 0) {
                    System.exit(0);
                }
            }
        });
        frame.setSize(230, 400);
        frame.setLocation(index * 30, index * 30);
        frame.setVisible(true);
    }

    public void updateDetails() {
        int i = 0;
        while (i < this.controller.getButtonCount()) {
            this.values[i].setText("" + this.controller.isButtonPressed(i));
            ++i;
        }
        i = this.buttonCount;
        while (i < this.buttonCount + this.controller.getAxisCount()) {
            this.values[i].setText("" + this.controller.getAxisValue(i - this.buttonCount));
            ++i;
        }
        this.values[this.itemCount - 2].setText("" + this.controller.getPovX());
        this.values[this.itemCount - 1].setText("" + this.controller.getPovY());
    }

    public static void main(String[] argv) {
        try {
            Controllers.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        int count = Controllers.getControllerCount();
        System.out.println(String.valueOf(count) + " Controllers Found");
        int i = 0;
        while (i < count) {
            Controller controller = Controllers.getController((int)i);
            System.out.println(controller.getName());
            System.out.println("Num axis: " + controller.getAxisCount());
            System.out.println("Num btn: " + controller.getButtonCount());
            ++i;
        }
        if (count == 0) {
            System.exit(0);
        }
        TestControllers[] controllerWindows = new TestControllers[count];
        int i2 = 0;
        while (i2 < count) {
            controllerWindows[i2] = new TestControllers(i2);
            ++i2;
        }
        boolean running = true;
        while (running) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Controllers.poll();
            while (Controllers.next()) {
                System.out.println("Event Fired: ");
                System.out.println("\t" + Controllers.getEventNanoseconds());
                System.out.println("\t" + Controllers.getEventSource() + ":" + Controllers.getEventControlIndex() + ":" + Controllers.isEventButton());
                System.out.println("\t" + Controllers.isEventXAxis() + ":" + Controllers.isEventYAxis());
            }
            int i3 = 0;
            while (i3 < count) {
                controllerWindows[i3].updateDetails();
                ++i3;
            }
        }
    }
}

