/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.net.URL;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.Log;

public class Sound {
    private Audio sound;

    public Sound(URL url) throws SlickException {
        block6: {
            SoundStore.get().init();
            String ref2 = url.getFile();
            try {
                if (ref2.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore.get().getOgg(url.openStream());
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore.get().getWAV(url.openStream());
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore.get().getAIF(url.openStream());
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".xm") || ref2.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore.get().getMOD(url.openStream());
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                Log.error(e);
                throw new SlickException("Failed to load sound: " + ref2);
            }
        }
    }

    public Sound(String ref2) throws SlickException {
        block6: {
            SoundStore.get().init();
            try {
                if (ref2.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore.get().getOgg(ref2);
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore.get().getWAV(ref2);
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore.get().getAIF(ref2);
                    break block6;
                }
                if (ref2.toLowerCase().endsWith(".xm") || ref2.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore.get().getMOD(ref2);
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                Log.error(e);
                throw new SlickException("Failed to load sound: " + ref2);
            }
        }
    }

    public void play() {
        this.play(1.0f, 1.0f);
    }

    public void play(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), false);
    }

    public void playAt(float x, float y, float z) {
        this.playAt(1.0f, 1.0f, x, y, z);
    }

    public void playAt(float pitch, float volume, float x, float y, float z) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), false, x, y, z);
    }

    public void loop() {
        this.loop(1.0f, 1.0f);
    }

    public void loop(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), true);
    }

    public boolean playing() {
        return this.sound.isPlaying();
    }

    public void stop() {
        this.sound.stop();
    }
}

