/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.newdawn.slick.util.ResourceLocation;

public class FileSystemLocation
implements ResourceLocation {
    private File root;

    public FileSystemLocation(File root) {
        this.root = root;
    }

    @Override
    public URL getResource(String ref2) {
        File file;
        block4: {
            try {
                file = new File(this.root, ref2);
                if (!file.exists()) {
                    file = new File(ref2);
                }
                if (file.exists()) break block4;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return file.toURI().toURL();
    }

    @Override
    public InputStream getResourceAsStream(String ref2) {
        try {
            File file = new File(this.root, ref2);
            if (!file.exists()) {
                file = new File(ref2);
            }
            return new FileInputStream(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public OutputStream getResourceAsOutputStream(String ref2) {
        try {
            File file = new File(this.root, ref2);
            if (!file.exists()) {
                file = new File(ref2);
            }
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            return null;
        }
    }
}

